/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.QueryResultEntry;
import com.hazelcast.util.IterationType;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class QueryResultSet
extends AbstractSet
implements IdentifiedDataSerializable {
    private final transient SerializationService serializationService;
    private final Set<QueryResultEntry> entries = Collections.newSetFromMap(new ConcurrentHashMap());
    private IterationType iterationType;
    private boolean data;

    public QueryResultSet() {
        this.serializationService = null;
    }

    public QueryResultSet(SerializationService serializationService, IterationType iterationType, boolean data) {
        this.serializationService = serializationService;
        this.data = data;
        this.iterationType = iterationType;
    }

    @Override
    public boolean add(QueryResultEntry entry) {
        return this.entries.add(entry);
    }

    @Override
    public boolean add(Object entry) {
        return this.entries.add((QueryResultEntry)entry);
    }

    @Override
    public Iterator iterator() {
        return new QueryResultIterator();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.data);
        out.writeUTF(this.iterationType.toString());
        out.writeInt(this.entries.size());
        for (QueryResultEntry queryResultEntry : this.entries) {
            out.writeObject(queryResultEntry);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.data = in.readBoolean();
        this.iterationType = IterationType.valueOf(in.readUTF());
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.entries.add((QueryResultEntry)in.readObject());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("QueryResultSet{");
        sb.append("entries=").append(this.entries);
        sb.append(", iterationType=").append((Object)this.iterationType);
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }

    private class QueryResultIterator
    implements Iterator {
        final Iterator<QueryResultEntry> iter;

        private QueryResultIterator() {
            this.iter = QueryResultSet.this.entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            QueryResultEntry entry = this.iter.next();
            if (QueryResultSet.this.iterationType == IterationType.VALUE) {
                Data valueData = entry.getValueData();
                return QueryResultSet.this.data ? valueData : QueryResultSet.this.serializationService.toObject(valueData);
            }
            if (QueryResultSet.this.iterationType == IterationType.KEY) {
                Data keyData = entry.getKeyData();
                return QueryResultSet.this.data ? keyData : QueryResultSet.this.serializationService.toObject(keyData);
            }
            Data keyData = entry.getKeyData();
            Data valueData = entry.getValueData();
            return QueryResultSet.this.data ? new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, valueData) : new AbstractMap.SimpleImmutableEntry<Object, Object>(QueryResultSet.this.serializationService.toObject(keyData), QueryResultSet.this.serializationService.toObject(valueData));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

