/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic;

import com.hazelcast.core.Member;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.util.Clock;
import java.io.IOException;

public class TopicEvent
implements DataSerializable {
    public String name;
    public long publishTime;
    public Member publishingMember;
    public Data data;

    public TopicEvent() {
    }

    public TopicEvent(String name, Data data, Member publishingMember) {
        this.publishTime = Clock.currentTimeMillis();
        this.publishingMember = publishingMember;
        this.name = name;
        this.data = data;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.publishTime);
        out.writeObject(this.publishingMember);
        IOUtil.writeNullableData(out, this.data);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.publishTime = in.readLong();
        this.publishingMember = (Member)in.readObject();
        this.data = IOUtil.readNullableData(in);
    }
}

