/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.collection.CollectionService;
import com.hazelcast.concurrent.atomiclong.AtomicLongService;
import com.hazelcast.concurrent.countdownlatch.CountDownLatchService;
import com.hazelcast.concurrent.idgen.IdGeneratorService;
import com.hazelcast.concurrent.lock.LockServiceImpl;
import com.hazelcast.concurrent.semaphore.SemaphoreService;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.executor.DistributedExecutorService;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.queue.QueueService;
import com.hazelcast.spi.ConfigurableService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.topic.TopicService;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

@PrivateApi
final class ServiceManager {
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final ConcurrentMap<String, ServiceInfo> services = new ConcurrentHashMap<String, ServiceInfo>(20, 0.75f, 1);

    ServiceManager(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(ServiceManager.class.getName());
    }

    synchronized void start() {
        Map<String, Object> serviceConfigObjects;
        Map<String, Properties> serviceProps;
        Node node = this.nodeEngine.getNode();
        this.logger.log(Level.FINEST, "Registering core services...");
        this.registerService("hz:core:clusterService", node.getClusterService());
        this.registerService("hz:core:partitionService", node.getPartitionService());
        this.registerService("hz:core:proxyService", this.nodeEngine.getProxyService());
        this.registerService("hz:core:txManagerService", this.nodeEngine.getTransactionManagerService());
        this.registerService("hz:core:clientEngine", node.clientEngine);
        ServicesConfig servicesConfig = node.getConfig().getServicesConfig();
        if (servicesConfig != null) {
            if (servicesConfig.isEnableDefaults()) {
                this.logger.log(Level.FINEST, "Registering default services...");
                this.registerService("hz:impl:mapService", new MapService(this.nodeEngine));
                this.registerService("hz:impl:lockService", new LockServiceImpl(this.nodeEngine));
                this.registerService("hz:impl:queueService", new QueueService(this.nodeEngine));
                this.registerService("hz:impl:topicService", new TopicService());
                this.registerService("hz:impl:collectionService", new CollectionService(this.nodeEngine));
                this.registerService("hz:impl:executorService", new DistributedExecutorService());
                this.registerService("hz:impl:atomicLongService", new AtomicLongService());
                this.registerService("hz:impl:countDownLatchService", new CountDownLatchService());
                this.registerService("hz:impl:semaphoreService", new SemaphoreService(this.nodeEngine));
                this.registerService("hz:impl:idGeneratorService", new IdGeneratorService(this.nodeEngine));
            }
            serviceProps = new HashMap();
            serviceConfigObjects = new HashMap();
            Collection<ServiceConfig> serviceConfigs = servicesConfig.getServiceConfigs();
            for (ServiceConfig serviceConfig : serviceConfigs) {
                if (!serviceConfig.isEnabled()) continue;
                Object service = serviceConfig.getServiceImpl();
                if (service == null) {
                    service = this.createServiceObject(serviceConfig.getClassName());
                }
                if (service == null) continue;
                this.registerService(serviceConfig.getName(), service);
                serviceProps.put(serviceConfig.getName(), serviceConfig.getProperties());
                if (serviceConfig.getConfigObject() == null) continue;
                serviceConfigObjects.put(serviceConfig.getName(), serviceConfig.getConfigObject());
            }
        } else {
            serviceProps = Collections.emptyMap();
            serviceConfigObjects = Collections.emptyMap();
        }
        for (ServiceInfo serviceInfo : this.services.values()) {
            Object service = serviceInfo.getService();
            if (serviceInfo.isConfigurableService()) {
                try {
                    this.logger.log(Level.FINEST, "Configuring service -> " + service);
                    Object configObject = serviceConfigObjects.get(serviceInfo.getName());
                    ((ConfigurableService)service).configure(configObject);
                }
                catch (Throwable t) {
                    this.logger.log(Level.SEVERE, "Error while configuring service: " + t.getMessage(), t);
                }
            }
            if (!serviceInfo.isManagedService()) continue;
            try {
                this.logger.log(Level.FINEST, "Initializing service -> " + service);
                Properties props = (Properties)serviceProps.get(serviceInfo.getName());
                ((ManagedService)service).init(this.nodeEngine, props != null ? props : new Properties());
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "Error while initializing service: " + t.getMessage(), t);
            }
        }
    }

    private Object createServiceObject(String className) {
        try {
            Class<?> serviceClass = ClassLoaderUtil.loadClass(this.nodeEngine.getConfigClassLoader(), className);
            try {
                Constructor<?> constructor = serviceClass.getConstructor(NodeEngine.class);
                return constructor.newInstance(this.nodeEngine);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return ClassLoaderUtil.newInstance(serviceClass);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    synchronized void shutdown() {
        this.logger.log(Level.FINEST, "Stopping services...");
        List<ManagedService> managedServices = this.getServices(ManagedService.class);
        Collections.reverse(managedServices);
        this.services.clear();
        for (ManagedService service : managedServices) {
            this.shutdownService(service);
        }
    }

    private void shutdownService(ManagedService service) {
        try {
            this.logger.log(Level.FINEST, "Shutting down service -> " + service);
            service.shutdown();
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Error while shutting down service[" + service + "]: " + t.getMessage(), t);
        }
    }

    private synchronized void registerService(String serviceName, Object service) {
        this.logger.log(Level.FINEST, "Registering service: '" + serviceName + "'");
        ServiceInfo serviceInfo = new ServiceInfo(serviceName, service);
        ServiceInfo currentServiceInfo = this.services.putIfAbsent(serviceName, serviceInfo);
        if (currentServiceInfo != null) {
            this.logger.log(Level.WARNING, "Replacing " + currentServiceInfo + " with " + serviceInfo);
            if (currentServiceInfo.isCoreService()) {
                throw new HazelcastException("Can not replace a CoreService! Name: " + serviceName + ", Service: " + currentServiceInfo.getService());
            }
            if (currentServiceInfo.isManagedService()) {
                this.shutdownService((ManagedService)currentServiceInfo.getService());
            }
            this.services.put(serviceName, serviceInfo);
        }
    }

    ServiceInfo getServiceInfo(String serviceName) {
        return (ServiceInfo)this.services.get(serviceName);
    }

    <S> List<S> getServices(Class<S> serviceClass) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (ServiceInfo serviceInfo : this.services.values()) {
            if (!serviceInfo.isInstanceOf(serviceClass)) continue;
            Object service = serviceInfo.getService();
            if (serviceInfo.isCoreService()) {
                result.addFirst(service);
                continue;
            }
            result.addLast(service);
        }
        return result;
    }

    List<ServiceInfo> getServiceInfos(Class serviceClass) {
        LinkedList<ServiceInfo> result = new LinkedList<ServiceInfo>();
        for (ServiceInfo serviceInfo : this.services.values()) {
            if (!serviceInfo.isInstanceOf(serviceClass)) continue;
            if (serviceInfo.isCoreService()) {
                result.addFirst(serviceInfo);
                continue;
            }
            result.addLast(serviceInfo);
        }
        return result;
    }
}

