/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.config.QueueConfig;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.QueueItem;
import com.hazelcast.queue.QueueService;
import com.hazelcast.queue.SizeOperation;
import com.hazelcast.queue.tx.QueueTransactionLog;
import com.hazelcast.queue.tx.TxnOfferOperation;
import com.hazelcast.queue.tx.TxnPollOperation;
import com.hazelcast.queue.tx.TxnReserveOfferOperation;
import com.hazelcast.queue.tx.TxnReservePollOperation;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.ExceptionUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Future;

public abstract class TransactionalQueueProxySupport
extends AbstractDistributedObject<QueueService>
implements TransactionalObject {
    protected final String name;
    protected final TransactionSupport tx;
    protected final int partitionId;
    private final LinkedList<QueueItem> offeredQueue = new LinkedList();
    private final Set<Long> itemIdSet = new HashSet<Long>();
    protected final QueueConfig config;

    protected TransactionalQueueProxySupport(NodeEngine nodeEngine, QueueService service, String name, TransactionSupport tx) {
        super(nodeEngine, service);
        this.name = name;
        this.tx = tx;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(name);
        this.config = nodeEngine.getConfig().getQueueConfig(name);
    }

    public boolean offerInternal(Data data, long timeout) {
        this.throwExceptionIfNull(data);
        TxnReserveOfferOperation operation = new TxnReserveOfferOperation(this.name, timeout, this.offeredQueue.size());
        try {
            Invocation invocation = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:queueService", (Operation)operation, this.partitionId).build();
            Future f = invocation.invoke();
            Long itemId = (Long)f.get();
            if (itemId != null) {
                if (!this.itemIdSet.add(itemId)) {
                    throw new TransactionException("Duplicate itemId: " + itemId);
                }
                this.offeredQueue.offer(new QueueItem(null, itemId, data));
                this.tx.addTransactionLog(new QueueTransactionLog(itemId, this.name, this.partitionId, new TxnOfferOperation(this.name, itemId, data)));
                return true;
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return false;
    }

    public Data pollInternal(long timeout) {
        QueueItem reservedOffer = this.offeredQueue.peek();
        TxnReservePollOperation operation = new TxnReservePollOperation(this.name, timeout, reservedOffer == null ? -1L : reservedOffer.getItemId());
        try {
            Invocation invocation = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:queueService", (Operation)operation, this.partitionId).build();
            Future f = invocation.invoke();
            QueueItem item = (QueueItem)f.get();
            if (item != null) {
                if (reservedOffer != null && item.getItemId() == reservedOffer.getItemId()) {
                    this.offeredQueue.poll();
                    this.tx.removeTransactionLog(reservedOffer.getItemId());
                    return reservedOffer.getData();
                }
                if (!this.itemIdSet.add(item.getItemId())) {
                    throw new TransactionException("Duplicate itemId: " + item.getItemId());
                }
                this.tx.addTransactionLog(new QueueTransactionLog(item.getItemId(), this.name, this.partitionId, new TxnPollOperation(this.name, item.getItemId())));
                return item.getData();
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return null;
    }

    public int size() {
        SizeOperation operation = new SizeOperation(this.name);
        try {
            Invocation invocation = this.getNodeEngine().getOperationService().createInvocationBuilder("hz:impl:queueService", (Operation)operation, this.partitionId).build();
            Future f = invocation.invoke();
            Integer size = (Integer)f.get();
            return size + this.offeredQueue.size();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Object getId() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:queueService";
    }

    private void throwExceptionIfNull(Object o) {
        if (o == null) {
            throw new NullPointerException("Object is null");
        }
    }
}

