/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.partition.ReplicaSyncResponse;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;

public final class ReplicaSyncRequest
extends Operation
implements PartitionAwareOperation,
MigrationCycleOperation {
    @Override
    public void beforeRun() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionServiceImpl partitionService = (PartitionServiceImpl)nodeEngine.getPartitionService();
        partitionService.incrementReplicaSyncProcessCount();
        ILogger logger = nodeEngine.getLogger(this.getClass());
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        try {
            Collection<ServiceInfo> services = nodeEngine.getServiceInfos(MigrationAwareService.class);
            PartitionReplicationEvent event = new PartitionReplicationEvent(partitionId, replicaIndex);
            LinkedList<Operation> tasks = new LinkedList<Operation>();
            for (ServiceInfo serviceInfo : services) {
                MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
                Operation op = service.prepareReplicationOperation(event);
                if (op == null) continue;
                op.setServiceName(serviceInfo.getName());
                tasks.add(op);
            }
            byte[] data = null;
            if (!tasks.isEmpty()) {
                SerializationService serializationService = nodeEngine.getSerializationService();
                BufferObjectDataOutput out = serializationService.createObjectDataOutput(32768);
                try {
                    out.writeInt(tasks.size());
                    for (Operation task : tasks) {
                        serializationService.writeObject(out, task);
                    }
                    data = IOUtil.compress(out.toByteArray());
                }
                finally {
                    IOUtil.closeResource(out);
                }
            } else {
                Level level = Level.FINEST;
                if (logger.isLoggable(level)) {
                    logger.log(level, "No replica data is found for partition: " + partitionId + ", replica: " + replicaIndex + "\n" + partitionService.getPartition(partitionId));
                }
            }
            long[] replicaVersions = partitionService.getPartitionReplicaVersions(partitionId);
            ReplicaSyncResponse syncResponse = new ReplicaSyncResponse(data, replicaVersions);
            syncResponse.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
            Address target = this.getCallerAddress();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Sending sync response to -> " + target + "; for partition: " + partitionId + ", replica: " + replicaIndex);
            }
            OperationService operationService = nodeEngine.getOperationService();
            operationService.send((Operation)syncResponse, target);
        }
        finally {
            partitionService.decrementReplicaSyncProcessCount();
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicaSyncRequest");
        sb.append("{partition=").append(this.getPartitionId());
        sb.append(", replica=").append(this.getReplicaIndex());
        sb.append('}');
        return sb.toString();
    }
}

