/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.cluster.BindOperation;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.CipherHelper;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.ConnectionMonitor;
import com.hazelcast.nio.DefaultSocketChannelWrapper;
import com.hazelcast.nio.IOSelector;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.InSelectorImpl;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.OutSelectorImpl;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketAcceptor;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.nio.SocketConnector;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.TcpIpConnection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.nio.ssl.SSLSocketChannelWrapper;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class TcpIpConnectionManager
implements ConnectionManager {
    private final ILogger logger;
    final int socketReceiveBufferSize;
    final int socketSendBufferSize;
    private final int socketLingerSeconds;
    private final boolean socketKeepAlive;
    private final boolean socketNoDelay;
    private final ConcurrentMap<Address, Connection> mapConnections = new ConcurrentHashMap<Address, Connection>(100);
    private final ConcurrentMap<Address, ConnectionMonitor> mapMonitors = new ConcurrentHashMap<Address, ConnectionMonitor>(100);
    private final Set<Address> setConnectionInProgress = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<ConnectionListener> setConnectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final Set<TcpIpConnection> setActiveConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger allTextConnections = new AtomicInteger();
    private final AtomicInteger connectionIdGen = new AtomicInteger();
    private volatile boolean live = false;
    final IOService ioService;
    private final ServerSocketChannel serverSocketChannel;
    private final int selectorThreadCount;
    private final IOSelector[] inSelectors;
    private final IOSelector[] outSelectors;
    private final AtomicInteger nextSelectorIndex = new AtomicInteger();
    private final MemberSocketInterceptor memberSocketInterceptor;
    private final SocketChannelWrapperFactory socketChannelWrapperFactory;
    private final int outboundPortCount;
    private final LinkedList<Integer> outboundPorts = new LinkedList();
    private final SerializationContext serializationContext;
    private Thread socketAcceptorThread;
    private final ConstructorFunction<Address, ConnectionMonitor> monitorConstructor = new ConstructorFunction<Address, ConnectionMonitor>(){

        @Override
        public ConnectionMonitor createNew(Address endpoint) {
            return new ConnectionMonitor(TcpIpConnectionManager.this, endpoint);
        }
    };

    public TcpIpConnectionManager(IOService ioService, ServerSocketChannel serverSocketChannel) {
        SSLConfig sslConfig;
        this.ioService = ioService;
        this.serverSocketChannel = serverSocketChannel;
        this.logger = ioService.getLogger(TcpIpConnectionManager.class.getName());
        this.socketReceiveBufferSize = ioService.getSocketReceiveBufferSize() * 1024;
        this.socketSendBufferSize = ioService.getSocketSendBufferSize() * 1024;
        this.socketLingerSeconds = ioService.getSocketLingerSeconds();
        this.socketKeepAlive = ioService.getSocketKeepAlive();
        this.socketNoDelay = ioService.getSocketNoDelay();
        this.selectorThreadCount = ioService.getSelectorThreadCount();
        this.inSelectors = new IOSelector[this.selectorThreadCount];
        this.outSelectors = new IOSelector[this.selectorThreadCount];
        Collection<Integer> ports = ioService.getOutboundPorts();
        int n = this.outboundPortCount = ports == null ? 0 : ports.size();
        if (ports != null) {
            this.outboundPorts.addAll(ports);
        }
        if ((sslConfig = ioService.getSSLConfig()) != null && sslConfig.isEnabled()) {
            this.socketChannelWrapperFactory = new SSLSocketChannelWrapperFactory(sslConfig);
            this.logger.log(Level.INFO, "SSL is enabled");
        } else {
            this.socketChannelWrapperFactory = new DefaultSocketChannelWrapperFactory();
        }
        SocketInterceptorConfig sic = ioService.getSocketInterceptorConfig();
        if (sic != null && sic.isEnabled()) {
            SocketInterceptor implementation = (SocketInterceptor)sic.getImplementation();
            if (implementation == null && sic.getClassName() != null) {
                try {
                    implementation = (SocketInterceptor)Class.forName(sic.getClassName()).newInstance();
                }
                catch (Throwable e) {
                    this.logger.log(Level.SEVERE, "SocketInterceptor class cannot be instantiated!" + sic.getClassName(), e);
                }
            }
            if (implementation != null) {
                if (!(implementation instanceof MemberSocketInterceptor)) {
                    this.logger.log(Level.SEVERE, "SocketInterceptor must be instance of " + MemberSocketInterceptor.class.getName());
                    implementation = null;
                } else {
                    this.logger.log(Level.INFO, "SocketInterceptor is enabled");
                }
            }
            if (implementation != null) {
                this.memberSocketInterceptor = (MemberSocketInterceptor)implementation;
                this.memberSocketInterceptor.init(sic);
            } else {
                this.memberSocketInterceptor = null;
            }
        } else {
            this.memberSocketInterceptor = null;
        }
        this.serializationContext = ioService.getSerializationContext();
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public IOService getIOHandler() {
        return this.ioService;
    }

    public MemberSocketInterceptor getMemberSocketInterceptor() {
        return this.memberSocketInterceptor;
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.setConnectionListeners.add(listener);
    }

    public boolean bind(TcpIpConnection connection, Address remoteEndPoint, Address localEndpoint, boolean replyBack) {
        Connection existingConnection;
        this.log(Level.FINEST, "Binding " + connection + " to " + remoteEndPoint + ", replyBack is " + replyBack);
        Address thisAddress = this.ioService.getThisAddress();
        if (!connection.isClient() && !thisAddress.equals(localEndpoint)) {
            this.log(Level.WARNING, "Wrong bind request from " + remoteEndPoint + "! This node is not requested endpoint: " + localEndpoint);
            connection.close();
            return false;
        }
        connection.setEndPoint(remoteEndPoint);
        if (replyBack) {
            this.sendBindRequest(connection, remoteEndPoint, false);
        }
        if ((existingConnection = (Connection)this.mapConnections.get(remoteEndPoint)) != null) {
            if (existingConnection != connection) {
                this.log(Level.FINEST, existingConnection + " is already bound  to " + remoteEndPoint);
            }
            return false;
        }
        if (!remoteEndPoint.equals(thisAddress)) {
            if (!connection.isClient()) {
                connection.setMonitor(this.getConnectionMonitor(remoteEndPoint, true));
            }
            this.mapConnections.put(remoteEndPoint, connection);
            this.setConnectionInProgress.remove(remoteEndPoint);
            for (ConnectionListener listener : this.setConnectionListeners) {
                listener.connectionAdded(connection);
            }
            return true;
        }
        return false;
    }

    void sendBindRequest(TcpIpConnection connection, Address remoteEndPoint, boolean replyBack) {
        connection.setEndPoint(remoteEndPoint);
        BindOperation bind = new BindOperation(this.ioService.getThisAddress(), remoteEndPoint, replyBack);
        Data bindData = this.ioService.toData(bind);
        Packet packet = new Packet(bindData, this.serializationContext);
        packet.setHeader(0);
        connection.write(packet);
    }

    private int nextSelectorIndex() {
        return Math.abs(this.nextSelectorIndex.getAndIncrement()) % this.selectorThreadCount;
    }

    TcpIpConnection assignSocketChannel(SocketChannelWrapper channel) {
        int index = this.nextSelectorIndex();
        TcpIpConnection connection = new TcpIpConnection(this, this.inSelectors[index], this.outSelectors[index], this.connectionIdGen.incrementAndGet(), channel);
        this.setActiveConnections.add(connection);
        connection.getReadHandler().register();
        this.log(Level.INFO, channel.socket().getLocalPort() + " accepted socket connection from " + channel.socket().getRemoteSocketAddress());
        return connection;
    }

    SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
        return this.socketChannelWrapperFactory.wrapSocketChannel(socketChannel, client);
    }

    void failedConnection(Address address, Throwable t, boolean silent) {
        this.setConnectionInProgress.remove(address);
        this.ioService.onFailedConnection(address);
        if (!silent) {
            this.getConnectionMonitor(address, false).onError(t);
        }
    }

    @Override
    public Connection getConnection(Address address) {
        return (Connection)this.mapConnections.get(address);
    }

    @Override
    public Connection getOrConnect(Address address) {
        return this.getOrConnect(address, false);
    }

    @Override
    public Connection getOrConnect(Address address, boolean silent) {
        Connection connection = (Connection)this.mapConnections.get(address);
        if (connection == null && this.live && this.setConnectionInProgress.add(address)) {
            this.ioService.shouldConnectTo(address);
            this.ioService.executeAsync(new SocketConnector(this, address, silent));
        }
        return connection;
    }

    private ConnectionMonitor getConnectionMonitor(Address endpoint, boolean reset) {
        ConnectionMonitor monitor = ConcurrencyUtil.getOrPutIfAbsent(this.mapMonitors, endpoint, this.monitorConstructor);
        if (reset) {
            monitor.reset();
        }
        return monitor;
    }

    @Override
    public void destroyConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        this.log(Level.FINEST, "Destroying " + connection);
        this.setActiveConnections.remove((TcpIpConnection)connection);
        Address endPoint = connection.getEndPoint();
        if (endPoint != null) {
            this.setConnectionInProgress.remove(endPoint);
            Connection existingConn = (Connection)this.mapConnections.get(endPoint);
            if (existingConn == connection) {
                this.mapConnections.remove(endPoint);
                for (ConnectionListener listener : this.setConnectionListeners) {
                    listener.connectionRemoved(connection);
                }
            }
        }
        if (connection.live()) {
            connection.close();
        }
    }

    protected void initSocket(Socket socket) throws Exception {
        if (this.socketLingerSeconds > 0) {
            socket.setSoLinger(true, this.socketLingerSeconds);
        }
        socket.setKeepAlive(this.socketKeepAlive);
        socket.setTcpNoDelay(this.socketNoDelay);
        socket.setReceiveBufferSize(this.socketReceiveBufferSize);
        socket.setSendBufferSize(this.socketSendBufferSize);
    }

    @Override
    public synchronized void start() {
        if (this.live) {
            return;
        }
        this.live = true;
        this.log(Level.FINEST, "Starting ConnectionManager and IO selectors.");
        for (int i = 0; i < this.inSelectors.length; ++i) {
            this.inSelectors[i] = new InSelectorImpl(this.ioService, i);
            this.outSelectors[i] = new OutSelectorImpl(this.ioService, i);
            this.inSelectors[i].start();
            this.outSelectors[i].start();
        }
        if (this.serverSocketChannel != null) {
            if (this.socketAcceptorThread != null) {
                this.logger.log(Level.WARNING, "SocketAcceptor thread is already live! Shutting down old acceptor...");
                this.shutdownSocketAcceptor();
            }
            SocketAcceptor acceptRunnable = new SocketAcceptor(this.serverSocketChannel, this);
            this.socketAcceptorThread = new Thread(this.ioService.getThreadGroup(), acceptRunnable, this.ioService.getThreadPrefix() + "Acceptor");
            this.socketAcceptorThread.start();
        }
    }

    @Override
    public synchronized void restart() {
        this.stop();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        try {
            if (this.live) {
                this.stop();
                this.setConnectionListeners.clear();
            }
        }
        finally {
            if (this.serverSocketChannel != null) {
                try {
                    this.log(Level.FINEST, "Closing server socket channel: " + this.serverSocketChannel);
                    this.serverSocketChannel.close();
                }
                catch (IOException ignore) {
                    this.logger.log(Level.FINEST, ignore.getMessage(), ignore);
                }
            }
        }
    }

    private void stop() {
        this.live = false;
        this.log(Level.FINEST, "Stopping ConnectionManager");
        this.shutdownSocketAcceptor();
        this.ioService.onShutdown();
        for (Connection connection : this.mapConnections.values()) {
            try {
                this.destroyConnection(connection);
            }
            catch (Throwable ignore) {
                this.logger.log(Level.FINEST, ignore.getMessage(), ignore);
            }
        }
        for (TcpIpConnection tcpIpConnection : this.setActiveConnections) {
            try {
                this.destroyConnection(tcpIpConnection);
            }
            catch (Throwable ignore) {
                this.logger.log(Level.FINEST, ignore.getMessage(), ignore);
            }
        }
        this.shutdownIOSelectors();
        this.setConnectionInProgress.clear();
        this.mapConnections.clear();
        this.mapMonitors.clear();
        this.setActiveConnections.clear();
    }

    private synchronized void shutdownIOSelectors() {
        this.log(Level.FINEST, "Shutting down IO selectors... Total: " + this.selectorThreadCount);
        for (int i = 0; i < this.selectorThreadCount; ++i) {
            IOSelector ioSelector = this.inSelectors[i];
            if (ioSelector != null) {
                ioSelector.shutdown();
            }
            this.inSelectors[i] = null;
            ioSelector = this.outSelectors[i];
            if (ioSelector != null) {
                ioSelector.shutdown();
            }
            this.outSelectors[i] = null;
        }
    }

    private synchronized void shutdownSocketAcceptor() {
        this.log(Level.FINEST, "Shutting down SocketAcceptor thread.");
        this.socketAcceptorThread.interrupt();
        this.socketAcceptorThread = null;
    }

    @Override
    public int getCurrentClientConnections() {
        int count = 0;
        for (TcpIpConnection conn : this.setActiveConnections) {
            if (!conn.live() || !conn.isClient()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getAllTextConnections() {
        return this.allTextConnections.get();
    }

    public void incrementTextConnections() {
        this.allTextConnections.incrementAndGet();
    }

    public boolean isLive() {
        return this.live;
    }

    @Override
    public Map<Address, Connection> getReadonlyConnectionMap() {
        return Collections.unmodifiableMap(this.mapConnections);
    }

    private void log(Level level, String message) {
        this.logger.log(level, message);
        this.ioService.getSystemLogService().logConnection(message);
    }

    boolean useAnyOutboundPort() {
        return this.outboundPortCount == 0;
    }

    int getOutboundPortCount() {
        return this.outboundPortCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int acquireOutboundPort() {
        if (this.useAnyOutboundPort()) {
            return 0;
        }
        LinkedList<Integer> linkedList = this.outboundPorts;
        synchronized (linkedList) {
            Integer port = this.outboundPorts.removeFirst();
            this.outboundPorts.addLast(port);
            return port;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Connections {");
        for (Connection conn : this.mapConnections.values()) {
            sb.append("\n");
            sb.append(conn);
        }
        sb.append("\nlive=");
        sb.append(this.live);
        sb.append("\n}");
        return sb.toString();
    }

    class SSLSocketChannelWrapperFactory
    implements SocketChannelWrapperFactory {
        final SSLContextFactory sslContextFactory;

        SSLSocketChannelWrapperFactory(SSLConfig sslConfig) {
            if (CipherHelper.isSymmetricEncryptionEnabled(TcpIpConnectionManager.this.ioService)) {
                throw new RuntimeException("SSL and SymmetricEncryption cannot be both enabled!");
            }
            SSLContextFactory sslContextFactoryObject = (SSLContextFactory)sslConfig.getFactoryImplementation();
            try {
                String factoryClassName = sslConfig.getFactoryClassName();
                if (sslContextFactoryObject == null && factoryClassName != null) {
                    sslContextFactoryObject = (SSLContextFactory)Class.forName(factoryClassName).newInstance();
                }
                if (sslContextFactoryObject == null) {
                    sslContextFactoryObject = new BasicSSLContextFactory();
                }
                sslContextFactoryObject.init(sslConfig.getProperties());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.sslContextFactory = sslContextFactoryObject;
        }

        @Override
        public SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
            return new SSLSocketChannelWrapper(this.sslContextFactory.getSSLContext(), socketChannel, client);
        }
    }

    class DefaultSocketChannelWrapperFactory
    implements SocketChannelWrapperFactory {
        DefaultSocketChannelWrapperFactory() {
        }

        @Override
        public SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
            return new DefaultSocketChannelWrapper(socketChannel);
        }
    }

    static interface SocketChannelWrapperFactory {
        public SocketChannelWrapper wrapSocketChannel(SocketChannel var1, boolean var2) throws Exception;
    }
}

