/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.CipherHelper;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketWriter;
import com.hazelcast.nio.TcpIpConnection;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.crypto.Cipher;

class SocketPacketWriter
implements SocketWriter<Packet> {
    private final PacketWriter packetWriter;
    final TcpIpConnection connection;
    final IOService ioService;
    final ILogger logger;

    SocketPacketWriter(TcpIpConnection connection) {
        this.connection = connection;
        this.ioService = connection.getConnectionManager().ioService;
        this.logger = this.ioService.getLogger(SocketPacketWriter.class.getName());
        boolean symmetricEncryptionEnabled = CipherHelper.isSymmetricEncryptionEnabled(this.ioService);
        if (symmetricEncryptionEnabled) {
            this.packetWriter = new SymmetricCipherPacketWriter();
            this.logger.log(Level.INFO, "Writer started with SymmetricEncryption");
        } else {
            this.packetWriter = new DefaultPacketWriter();
        }
    }

    @Override
    public boolean write(Packet socketWritable, ByteBuffer socketBuffer) throws Exception {
        return this.packetWriter.writePacket(socketWritable, socketBuffer);
    }

    private class SymmetricCipherPacketWriter
    implements PacketWriter {
        boolean sizeWritten = false;
        ByteBuffer packetBuffer;
        final ByteBuffer cipherBuffer;
        final Cipher cipher;

        SymmetricCipherPacketWriter() {
            this.packetBuffer = ByteBuffer.allocate(SocketPacketWriter.this.ioService.getSocketSendBufferSize() * 1024);
            this.cipherBuffer = ByteBuffer.allocate(SocketPacketWriter.this.ioService.getSocketSendBufferSize() * 1024);
            Cipher c = null;
            try {
                c = CipherHelper.createSymmetricWriterCipher(SocketPacketWriter.this.connection.getConnectionManager().ioService);
            }
            catch (Exception e) {
                SocketPacketWriter.this.logger.log(Level.SEVERE, "Symmetric Cipher for WriteHandler cannot be initialized.", e);
                CipherHelper.handleCipherException(e, SocketPacketWriter.this.connection);
            }
            this.cipher = c;
        }

        @Override
        public boolean writePacket(Packet packet, ByteBuffer socketBB) throws Exception {
            boolean complete;
            if (!this.sizeWritten) {
                if (this.packetBuffer.capacity() < packet.size()) {
                    this.packetBuffer = ByteBuffer.allocate(packet.size());
                }
                if (!packet.writeTo(this.packetBuffer)) {
                    throw new RuntimeException("Packet didn't fit into the buffer");
                }
                this.packetBuffer.flip();
            }
            if (this.cipherBuffer.position() > 0 && socketBB.hasRemaining()) {
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
            }
            if (!this.sizeWritten) {
                if (socketBB.remaining() > 4) {
                    int cipherSize = this.cipher.getOutputSize(packet.size());
                    socketBB.putInt(cipherSize);
                    this.sizeWritten = true;
                } else {
                    return false;
                }
            }
            this.encryptAndWriteToSocket(this.packetBuffer, socketBB);
            boolean bl = complete = !this.packetBuffer.hasRemaining();
            if (complete) {
                if (socketBB.remaining() >= this.cipher.getOutputSize(0)) {
                    this.sizeWritten = false;
                    socketBB.put(this.cipher.doFinal());
                    this.packetBuffer.clear();
                } else {
                    return false;
                }
            }
            return complete;
        }

        private int encryptAndWriteToSocket(ByteBuffer src, ByteBuffer socketBB) throws Exception {
            int remaining = src.remaining();
            if (src.hasRemaining() && this.cipherBuffer.hasRemaining()) {
                int outputSize = this.cipher.getOutputSize(src.remaining());
                if (outputSize <= this.cipherBuffer.remaining()) {
                    this.cipher.update(src, this.cipherBuffer);
                } else {
                    int min = Math.min(src.remaining(), this.cipherBuffer.remaining());
                    int len = min / 2;
                    if (len > 0) {
                        int limitOld = src.limit();
                        src.limit(src.position() + len);
                        this.cipher.update(src, this.cipherBuffer);
                        src.limit(limitOld);
                    } else {
                        return 0;
                    }
                }
                this.cipherBuffer.flip();
                IOUtil.copyToDirectBuffer(this.cipherBuffer, socketBB);
                if (this.cipherBuffer.hasRemaining()) {
                    this.cipherBuffer.compact();
                } else {
                    this.cipherBuffer.clear();
                }
                return remaining - src.remaining();
            }
            return 0;
        }
    }

    private class DefaultPacketWriter
    implements PacketWriter {
        private DefaultPacketWriter() {
        }

        @Override
        public boolean writePacket(Packet packet, ByteBuffer socketBB) {
            return packet.writeTo(socketBB);
        }
    }

    private static interface PacketWriter {
        public boolean writePacket(Packet var1, ByteBuffer var2) throws Exception;
    }
}

