/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.operation.EntryBackupOperation;
import com.hazelcast.map.operation.LockAwareOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class EntryOperation
extends LockAwareOperation
implements BackupAwareOperation {
    EntryProcessor entryProcessor;
    transient Object response;
    transient Map.Entry entry;

    public EntryOperation(String name, Data dataKey, EntryProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    public EntryOperation() {
    }

    @Override
    public void run() {
        Map.Entry<Data, Object> mapEntry = this.recordStore.getMapEntryObject(this.dataKey);
        this.entry = new AbstractMap.SimpleEntry<Object, Object>(this.mapService.toObject(this.dataKey), this.mapService.toObject(mapEntry.getValue()));
        this.response = this.mapService.toData(this.entryProcessor.process(this.entry));
        this.recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(this.dataKey, this.entry.getValue()));
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        this.invalidateNearCaches();
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    public String toString() {
        return "EntryOperation{}";
    }

    @Override
    public Operation getBackupOperation() {
        return new EntryBackupOperation(this.name, this.dataKey, this.entryProcessor.getBackupProcessor());
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }
}

