/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.MapService;
import com.hazelcast.map.PartitionRecordStore;
import com.hazelcast.map.RecordStore;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PartitionContainer {
    private final MapService mapService;
    private final int partitionId;
    private final ConcurrentMap<String, PartitionRecordStore> maps = new ConcurrentHashMap<String, PartitionRecordStore>(1000);
    private final ConstructorFunction<String, PartitionRecordStore> recordStoreConstructor = new ConstructorFunction<String, PartitionRecordStore>(){

        @Override
        public PartitionRecordStore createNew(String name) {
            return new PartitionRecordStore(name, PartitionContainer.this);
        }
    };

    public PartitionContainer(MapService mapService, int partitionId) {
        this.mapService = mapService;
        this.partitionId = partitionId;
    }

    public ConcurrentMap<String, PartitionRecordStore> getMaps() {
        return this.maps;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public MapService getMapService() {
        return this.mapService;
    }

    public RecordStore getRecordStore(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.maps, name, this.recordStoreConstructor);
    }

    void destroyMap(String name) {
        PartitionRecordStore recordStore = (PartitionRecordStore)this.maps.remove(name);
        if (recordStore != null) {
            recordStore.clear();
        }
    }

    void clear() {
        for (PartitionRecordStore store : this.maps.values()) {
            store.clear();
        }
        this.maps.clear();
    }
}

