/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MapStoreWriteProcessor
implements ScheduledEntryProcessor<Data, Object> {
    MapContainer mapContainer;
    MapService mapService;

    public MapStoreWriteProcessor(MapContainer mapContainer, MapService mapService) {
        this.mapContainer = mapContainer;
        this.mapService = mapService;
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (entries.size() == 1) {
            ScheduledEntry<Data, Object> entry = entries.iterator().next();
            this.mapContainer.getStore().store(this.mapService.toObject(entry.getKey()), this.mapService.toObject(entry.getValue()));
            return;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(entries.size());
        for (ScheduledEntry<Data, Object> entry : entries) {
            map.put(this.mapService.toObject(entry.getKey()), this.mapService.toObject(entry.getValue()));
        }
        this.mapContainer.getStore().storeAll((Map)map);
    }
}

