/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor;

import com.hazelcast.executor.ExecutorServiceProxy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class DistributedExecutorService
implements ManagedService,
RemoteService {
    public static final String SERVICE_NAME = "hz:impl:executorService";
    private NodeEngine nodeEngine;
    private ExecutionService executionService;
    private final ConcurrentMap<String, CallableProcessor> submittedTasks = new ConcurrentHashMap<String, CallableProcessor>(100);
    private final Set<String> shutdownExecutors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentHashMap<String, LocalExecutorStatsImpl> statsMap = new ConcurrentHashMap();
    private final ConstructorFunction<String, LocalExecutorStatsImpl> localExecutorStatsConstructorFunction = new ConstructorFunction<String, LocalExecutorStatsImpl>(){

        @Override
        public LocalExecutorStatsImpl createNew(String key) {
            return new LocalExecutorStatsImpl();
        }
    };

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        this.executionService = nodeEngine.getExecutionService();
    }

    @Override
    public void reset() {
        this.shutdownExecutors.clear();
        this.submittedTasks.clear();
        this.statsMap.clear();
    }

    @Override
    public void shutdown() {
        this.reset();
    }

    public void execute(String name, String uuid, Callable callable, ResponseHandler responseHandler) {
        this.startPending(name);
        CallableProcessor processor = new CallableProcessor(name, uuid, callable, responseHandler);
        if (uuid != null) {
            this.submittedTasks.put(uuid, processor);
        }
        this.executionService.execute(name, processor);
    }

    public boolean cancel(String uuid, boolean interrupt) {
        CallableProcessor processor = (CallableProcessor)this.submittedTasks.remove(uuid);
        if (processor != null && processor.cancel(interrupt)) {
            processor.sendResponse(new CancellationException());
            this.getLocalExecutorStats(processor.name).cancelExecution();
            return true;
        }
        return false;
    }

    public void shutdownExecutor(String name) {
        this.executionService.shutdownExecutor(name);
        this.shutdownExecutors.add(name);
    }

    public boolean isShutdown(String name) {
        return this.shutdownExecutors.contains(name);
    }

    @Override
    public ExecutorServiceProxy createDistributedObject(Object objectId) {
        String name = String.valueOf(objectId);
        return new ExecutorServiceProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(Object objectId) {
        String name = String.valueOf(objectId);
        this.shutdownExecutors.remove(name);
        this.executionService.shutdownExecutor(name);
    }

    LocalExecutorStatsImpl getLocalExecutorStats(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localExecutorStatsConstructorFunction);
    }

    private void startExecution(String name, long elapsed) {
        this.getLocalExecutorStats(name).startExecution(elapsed);
    }

    private void finishExecution(String name, long elapsed) {
        this.getLocalExecutorStats(name).finishExecution(elapsed);
    }

    private void startPending(String name) {
        this.getLocalExecutorStats(name).startPending();
    }

    private ILogger getLogger() {
        return this.nodeEngine.getLogger(DistributedExecutorService.class.getName());
    }

    private class CallableProcessor
    extends FutureTask
    implements Runnable {
        final String name;
        final String uuid;
        final ResponseHandler responseHandler;
        final String callableToString;
        final long creationTime;
        final AtomicBoolean responseFlag;

        private CallableProcessor(String name, String uuid, Callable callable, ResponseHandler responseHandler) {
            super(callable);
            this.creationTime = Clock.currentTimeMillis();
            this.responseFlag = new AtomicBoolean(false);
            this.name = name;
            this.uuid = uuid;
            this.callableToString = String.valueOf(callable);
            this.responseHandler = responseHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exception result;
            long start;
            block8: {
                start = Clock.currentTimeMillis();
                DistributedExecutorService.this.startExecution(this.name, start - this.creationTime);
                result = null;
                try {
                    super.run();
                    result = (Exception)this.get();
                    if (this.uuid == null) break block8;
                }
                catch (Exception e) {
                    block9: {
                        try {
                            ILogger logger = DistributedExecutorService.this.getLogger();
                            logger.log(Level.FINEST, "While executing callable: " + this.callableToString, e);
                            result = e;
                            if (this.uuid == null) break block9;
                        }
                        catch (Throwable throwable) {
                            if (this.uuid != null) {
                                DistributedExecutorService.this.submittedTasks.remove(this.uuid);
                            }
                            this.sendResponse(result);
                            if (!this.isCancelled()) {
                                DistributedExecutorService.this.finishExecution(this.name, Clock.currentTimeMillis() - start);
                            }
                            throw throwable;
                        }
                        DistributedExecutorService.this.submittedTasks.remove(this.uuid);
                    }
                    this.sendResponse(result);
                    if (!this.isCancelled()) {
                        DistributedExecutorService.this.finishExecution(this.name, Clock.currentTimeMillis() - start);
                    }
                }
                DistributedExecutorService.this.submittedTasks.remove(this.uuid);
            }
            this.sendResponse(result);
            if (!this.isCancelled()) {
                DistributedExecutorService.this.finishExecution(this.name, Clock.currentTimeMillis() - start);
            }
        }

        private void sendResponse(Object result) {
            if (this.responseFlag.compareAndSet(false, true)) {
                this.responseHandler.sendResponse(result);
            }
        }
    }
}

