/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEngineImpl;
import com.hazelcast.client.ClientPortableHook;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.client.ClientReAuthOperation;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class AuthenticationRequest
extends CallableClientRequest
implements Portable {
    private Credentials credentials;
    private ClientPrincipal principal;
    private boolean reAuth;
    private boolean firstConnection = false;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(Credentials credentials) {
        this.credentials = credentials;
    }

    public AuthenticationRequest(Credentials credentials, ClientPrincipal principal) {
        this.credentials = credentials;
        this.principal = principal;
    }

    public Object call() throws Exception {
        boolean authenticated;
        ClientEngineImpl clientEngine = (ClientEngineImpl)this.getService();
        Connection connection = this.endpoint.getConnection();
        ILogger logger = clientEngine.getLogger(this.getClass());
        clientEngine.sendResponse(this.endpoint, clientEngine.getThisAddress());
        if (this.credentials == null) {
            authenticated = false;
            logger.log(Level.SEVERE, "Could not retrieve Credentials object!");
        } else if (clientEngine.getSecurityContext() != null) {
            this.credentials.setEndpoint(connection.getInetAddress().getHostAddress());
            try {
                SecurityContext securityContext = clientEngine.getSecurityContext();
                LoginContext lc = securityContext.createClientLoginContext(this.credentials);
                lc.login();
                this.endpoint.setLoginContext(lc);
                authenticated = true;
            }
            catch (LoginException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                authenticated = false;
            }
        } else if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)this.credentials;
            GroupConfig groupConfig = clientEngine.getConfig().getGroupConfig();
            String nodeGroupName = groupConfig.getName();
            String nodeGroupPassword = groupConfig.getPassword();
            authenticated = nodeGroupName.equals(usernamePasswordCredentials.getUsername()) && nodeGroupPassword.equals(usernamePasswordCredentials.getPassword());
        } else {
            authenticated = false;
            logger.log(Level.SEVERE, "Hazelcast security is disabled.\nUsernamePasswordCredentials or cluster group-name and group-password should be used for authentication!\nCurrent credentials type is: " + this.credentials.getClass().getName());
        }
        logger.log(authenticated ? Level.INFO : Level.WARNING, "Received auth from " + connection + ", " + (authenticated ? "successfully authenticated" : "authentication failed"));
        if (authenticated) {
            if (this.principal != null) {
                ClusterService clusterService = clientEngine.getClusterService();
                if (this.reAuth) {
                    this.principal = new ClientPrincipal(this.principal.getUuid(), clientEngine.getLocalMember().getUuid());
                    Collection<MemberImpl> members = clientEngine.getClusterService().getMemberList();
                    for (MemberImpl member : members) {
                        if (member.localMember()) continue;
                        clientEngine.sendOperation(new ClientReAuthOperation(this.principal.getUuid(), this.firstConnection), member.getAddress());
                    }
                } else if (clusterService.getMember(this.principal.getOwnerUuid()) == null) {
                    clientEngine.removeEndpoint(connection);
                    return new AuthenticationException("Owner member is not member of this cluster!");
                }
            }
            if (this.principal == null) {
                this.principal = new ClientPrincipal(this.endpoint.getUuid(), clientEngine.getLocalMember().getUuid());
            }
            this.endpoint.authenticated(this.principal, this.firstConnection);
            clientEngine.bind(this.endpoint);
            return this.principal;
        }
        clientEngine.removeEndpoint(connection);
        return new AuthenticationException("Invalid credentials!");
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    public void setReAuth(boolean reAuth) {
        this.reAuth = reAuth;
    }

    public boolean isFirstConnection() {
        return this.firstConnection;
    }

    public void setFirstConnection(boolean firstConnection) {
        this.firstConnection = firstConnection;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writePortable("credentials", (Portable)((Object)this.credentials));
        if (this.principal != null) {
            writer.writePortable("principal", this.principal);
        } else {
            writer.writeNullPortable("principal", ClientPortableHook.ID, 3);
        }
        writer.writeBoolean("reAuth", this.reAuth);
        writer.writeBoolean("firstConnection", this.firstConnection);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.credentials = (Credentials)reader.readPortable("credentials");
        this.principal = (ClientPrincipal)reader.readPortable("principal");
        this.reAuth = reader.readBoolean("reAuth");
        this.firstConnection = reader.readBoolean("firstConnection");
    }
}

