/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.PartitionView;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.WaitSupport;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.RemoteCall;
import com.hazelcast.spi.impl.Response;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import com.hazelcast.spi.impl.TargetInvocationImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.ScheduledTaskRunner;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

abstract class InvocationImpl
implements Invocation,
Callback<Object> {
    private final BlockingQueue<Object> responseQ = new LinkedBlockingQueue<Object>();
    protected final long callTimeout;
    protected final NodeEngineImpl nodeEngine;
    protected final String serviceName;
    protected final Operation op;
    protected final int partitionId;
    protected final int replicaIndex;
    protected final int tryCount;
    protected final long tryPauseMillis;
    protected final Callback<Object> callback;
    protected final ResponseProcessor responseProcessor;
    protected final ILogger logger;
    private volatile int invokeCount = 0;
    private volatile Address target;
    private boolean remote = false;
    private static final Object NULL_RESPONSE = new Object(){

        public String toString() {
            return "Invocation::NULL_RESPONSE";
        }
    };
    private static final Object RETRY_RESPONSE = new Object(){

        public String toString() {
            return "Invocation::RETRY_RESPONSE";
        }
    };
    private static final Object WAIT_RESPONSE = new Object(){

        public String toString() {
            return "Invocation::WAIT_RESPONSE";
        }
    };
    private static final Object TIMEOUT_RESPONSE = new Object(){

        public String toString() {
            return "Invocation::TIMEOUT_RESPONSE";
        }
    };

    InvocationImpl(NodeEngineImpl nodeEngine, String serviceName, Operation op, int partitionId, int replicaIndex, int tryCount, long tryPauseMillis, long callTimeout, Callback<Object> callback) {
        this.nodeEngine = nodeEngine;
        this.serviceName = serviceName;
        this.op = op;
        this.partitionId = partitionId;
        this.replicaIndex = replicaIndex;
        this.tryCount = tryCount;
        this.tryPauseMillis = tryPauseMillis;
        this.callTimeout = this.getCallTimeout(callTimeout);
        this.callback = callback;
        this.responseProcessor = callback == null ? new DefaultResponseProcessor() : new CallbackResponseProcessor();
        this.logger = nodeEngine.getLogger(Invocation.class.getName());
    }

    private long getCallTimeout(long callTimeout) {
        long waitTimeoutMillis;
        if (callTimeout > 0L) {
            return callTimeout;
        }
        long defaultCallTimeout = this.nodeEngine.operationService.getDefaultCallTimeout();
        if (this.op instanceof WaitSupport && (waitTimeoutMillis = ((WaitSupport)((Object)this.op)).getWaitTimeoutMillis()) > 0L && waitTimeoutMillis < Long.MAX_VALUE && defaultCallTimeout > 10000L) {
            return waitTimeoutMillis + 10000L;
        }
        return defaultCallTimeout;
    }

    @Override
    public final Future invoke() {
        if (this.invokeCount > 0) {
            throw new IllegalStateException("An invocation can not be invoked more than once!");
        }
        if (this.op.getCallId() != 0L) {
            throw new IllegalStateException("An operation[" + this.op + "] can not be used for multiple invocations!");
        }
        if (this.nodeEngine.operationService.isOperationThread() && this.op instanceof PartitionAwareOperation && !OperationAccessor.isMigrationOperation(this.op)) {
            throw new IllegalThreadStateException(Thread.currentThread() + " cannot make remote call: " + this.op);
        }
        try {
            OperationAccessor.setCallTimeout(this.op, this.callTimeout);
            OperationAccessor.setCallerAddress(this.op, this.nodeEngine.getThisAddress());
            this.op.setNodeEngine(this.nodeEngine).setServiceName(this.serviceName).setPartitionId(this.partitionId).setReplicaIndex(this.replicaIndex);
            if (this.op.getCallerUuid() == null) {
                this.op.setCallerUuid(this.nodeEngine.getLocalMember().getUuid());
            }
            this.doInvoke();
        }
        catch (Exception e) {
            if (e instanceof RetryableException) {
                this.notify(e);
            }
            throw ExceptionUtil.rethrow(e);
        }
        return new InvocationFuture();
    }

    private void doInvoke() {
        Address invTarget;
        if (!this.nodeEngine.isActive()) {
            this.remote = false;
            throw new HazelcastInstanceNotActiveException();
        }
        this.target = invTarget = this.getTarget();
        ++this.invokeCount;
        Address thisAddress = this.nodeEngine.getThisAddress();
        if (invTarget == null) {
            this.remote = false;
            if (this.nodeEngine.isActive()) {
                this.notify(new WrongTargetException(thisAddress, invTarget, this.partitionId, this.replicaIndex, this.op.getClass().getName(), this.serviceName));
            } else {
                this.notify(new HazelcastInstanceNotActiveException());
            }
        } else {
            MemberImpl member = this.nodeEngine.getClusterService().getMember(invTarget);
            if (!OperationAccessor.isJoinOperation(this.op) && member == null) {
                this.notify(new TargetNotMemberException(invTarget, this.partitionId, this.op.getClass().getName(), this.serviceName));
            } else {
                if (this.op.getPartitionId() != this.partitionId) {
                    this.notify(new IllegalStateException("Partition id of operation: " + this.op.getPartitionId() + " is not equal to the partition id of invocation: " + this.partitionId));
                    return;
                }
                if (this.op.getReplicaIndex() != this.replicaIndex) {
                    this.notify(new IllegalStateException("Replica index of operation: " + this.op.getReplicaIndex() + " is not equal to the replica index of invocation: " + this.replicaIndex));
                    return;
                }
                OperationServiceImpl operationService = this.nodeEngine.operationService;
                OperationAccessor.setInvocationTime(this.op, this.nodeEngine.getClusterTime());
                if (thisAddress.equals(invTarget)) {
                    this.remote = false;
                    long prevCallId = this.op.getCallId();
                    if (prevCallId != 0L) {
                        operationService.deregisterRemoteCall(prevCallId);
                    }
                    if (this.op instanceof BackupAwareOperation) {
                        long callId = operationService.newCallId();
                        this.registerBackups((BackupAwareOperation)((Object)this.op), callId);
                        OperationAccessor.setCallId(this.op, callId);
                    }
                    ResponseHandlerFactory.setLocalResponseHandler(this.op, this);
                    if (this.op instanceof PartitionAwareOperation) {
                        operationService.executeOperation(this.op);
                    } else {
                        operationService.runOperation(this.op);
                    }
                } else {
                    this.remote = true;
                    RemoteCall call = member != null ? new RemoteCall(member, (Callback<Object>)this) : new RemoteCall(invTarget, (Callback<Object>)this);
                    long callId = operationService.registerRemoteCall(call);
                    if (this.op instanceof BackupAwareOperation) {
                        this.registerBackups((BackupAwareOperation)((Object)this.op), callId);
                    }
                    OperationAccessor.setCallId(this.op, callId);
                    boolean sent = operationService.send(this.op, invTarget);
                    if (!sent) {
                        this.notify(new RetryableIOException("Packet not sent to -> " + invTarget));
                    }
                }
            }
        }
    }

    private void registerBackups(BackupAwareOperation op, long callId) {
        long oldCallId = ((Operation)((Object)op)).getCallId();
        OperationServiceImpl operationService = this.nodeEngine.operationService;
        if (oldCallId != 0L) {
            operationService.deregisterBackupCall(oldCallId);
        }
        operationService.registerBackupCall(callId);
    }

    @Override
    public void notify(Object obj) {
        Object response;
        if (obj == null) {
            response = NULL_RESPONSE;
        } else if (obj instanceof Throwable) {
            Throwable error = (Throwable)obj;
            ExceptionAction action = this.onException(error);
            int localInvokeCount = this.invokeCount;
            if (action == ExceptionAction.RETRY_INVOCATION && localInvokeCount < this.tryCount) {
                response = RETRY_RESPONSE;
                if (localInvokeCount > 99 && localInvokeCount % 10 == 0) {
                    this.logger.log(Level.WARNING, "Retrying invocation: " + this.toString() + ", Reason: " + error);
                }
            } else {
                response = action == ExceptionAction.CONTINUE_WAIT ? WAIT_RESPONSE : obj;
            }
        } else {
            response = obj;
        }
        this.responseProcessor.process(response);
    }

    abstract ExceptionAction onException(Throwable var1);

    private Future resetAndReInvoke() {
        this.responseQ.clear();
        this.invokeCount = 0;
        this.doInvoke();
        return new InvocationFuture();
    }

    private boolean isOperationExecuting(Address target) {
        Boolean executing = Boolean.FALSE;
        try {
            TargetInvocationImpl inv = new TargetInvocationImpl(this.nodeEngine, this.serviceName, new IsStillExecuting(this.op.getCallId()), target, 0, 0L, 5000L, null);
            Future f = inv.invoke();
            this.logger.log(Level.WARNING, "Asking if operation execution has been started: " + this.toString());
            executing = (Boolean)this.nodeEngine.toObject(f.get(5000L, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "While asking 'is-executing': " + this.toString(), e);
        }
        this.logger.log(Level.WARNING, "'is-executing': " + executing + " -> " + this.toString());
        return executing;
    }

    private static long decrementTimeout(long timeout, long diff) {
        if (timeout != Long.MAX_VALUE) {
            timeout -= diff;
        }
        return timeout;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    PartitionView getPartition() {
        return this.nodeEngine.getPartitionService().getPartitionView(this.partitionId);
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InvocationImpl");
        sb.append("{ serviceName='").append(this.serviceName).append('\'');
        sb.append(", op=").append(this.op);
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", replicaIndex=").append(this.replicaIndex);
        sb.append(", tryCount=").append(this.tryCount);
        sb.append(", tryPauseMillis=").append(this.tryPauseMillis);
        sb.append(", invokeCount=").append(this.invokeCount);
        sb.append(", callTimeout=").append(this.callTimeout);
        sb.append(", target=").append(this.target);
        sb.append('}');
        return sb.toString();
    }

    public static class IsStillExecuting
    extends AbstractOperation {
        private long operationCallId;

        IsStillExecuting() {
        }

        private IsStillExecuting(long operationCallId) {
            this.operationCallId = operationCallId;
        }

        @Override
        public void run() throws Exception {
            NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            OperationServiceImpl operationService = nodeEngine.operationService;
            boolean executing = operationService.isOperationExecuting(this.getCallerAddress(), this.operationCallId);
            this.getResponseHandler().sendResponse(executing);
        }

        @Override
        public boolean returnsResponse() {
            return false;
        }

        @Override
        protected void readInternal(ObjectDataInput in) throws IOException {
            super.readInternal(in);
            this.operationCallId = in.readLong();
        }

        @Override
        protected void writeInternal(ObjectDataOutput out) throws IOException {
            super.writeInternal(out);
            out.writeLong(this.operationCallId);
        }
    }

    private class InvocationFuture
    implements Future {
        volatile boolean done = false;

        private InvocationFuture() {
        }

        public Object get() throws InterruptedException, ExecutionException {
            try {
                return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                InvocationImpl.this.logger.log(Level.FINEST, e.getMessage(), e);
                return null;
            }
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Object response = this.resolveResponse(this.waitForResponse(timeout, unit));
            this.done = true;
            if (response instanceof Response) {
                if (InvocationImpl.this.op instanceof BackupAwareOperation) {
                    Object obj = this.waitForBackupsAndGetResponse((Response)response);
                    if (obj == RETRY_RESPONSE) {
                        Future f = InvocationImpl.this.resetAndReInvoke();
                        return f.get(timeout, unit);
                    }
                    return obj;
                }
                return ((Response)response).response;
            }
            return response;
        }

        private Object waitForResponse(long time, TimeUnit unit) {
            long timeout = unit.toMillis(time);
            if (timeout < 0L) {
                timeout = 0L;
            }
            long maxCallTimeout = InvocationImpl.this.callTimeout * 2L > 0L ? InvocationImpl.this.callTimeout * 2L : Long.MAX_VALUE;
            boolean longPolling = timeout > maxCallTimeout;
            int pollCount = 0;
            InterruptedException interrupted = null;
            while (timeout >= 0L) {
                Object obj;
                long lastPollTime;
                Object response;
                long pollTimeout = Math.min(maxCallTimeout, timeout);
                long start = Clock.currentTimeMillis();
                try {
                    response = InvocationImpl.this.responseQ.poll(pollTimeout, TimeUnit.MILLISECONDS);
                    lastPollTime = Clock.currentTimeMillis() - start;
                    timeout = InvocationImpl.decrementTimeout(timeout, lastPollTime);
                }
                catch (InterruptedException e) {
                    InvocationImpl.this.logger.log(Level.FINEST, Thread.currentThread().getName() + " is interrupted while waiting " + "response for operation " + InvocationImpl.this.op);
                    interrupted = e;
                    if (InvocationImpl.this.nodeEngine.isActive()) continue;
                    return e;
                }
                ++pollCount;
                if (response == RETRY_RESPONSE) {
                    if (interrupted != null) {
                        return interrupted;
                    }
                    if (timeout > 0L) {
                        if (InvocationImpl.this.invokeCount > 5) {
                            long sleepTime = InvocationImpl.this.tryPauseMillis;
                            try {
                                Thread.sleep(sleepTime);
                                timeout = InvocationImpl.decrementTimeout(timeout, sleepTime);
                            }
                            catch (InterruptedException e) {
                                return e;
                            }
                        }
                        InvocationImpl.this.doInvoke();
                        continue;
                    }
                    return TIMEOUT_RESPONSE;
                }
                if (response == WAIT_RESPONSE) continue;
                if (response != null) {
                    return response;
                }
                if (!longPolling) continue;
                Address target = InvocationImpl.this.getTarget();
                if (InvocationImpl.this.nodeEngine.getThisAddress().equals(target)) continue;
                InvocationImpl.this.logger.log(Level.WARNING, "No response for " + lastPollTime + " ms. " + this.toString());
                boolean executing = InvocationImpl.this.isOperationExecuting(target);
                if (executing || (obj = InvocationImpl.this.responseQ.peek()) != null) continue;
                return new OperationTimeoutException("No response for " + pollTimeout * (long)pollCount + " ms. Aborting invocation! " + this.toString());
            }
            return TIMEOUT_RESPONSE;
        }

        private Object waitForBackupsAndGetResponse(Response response) {
            if (InvocationImpl.this.op instanceof BackupAwareOperation) {
                try {
                    boolean ok = InvocationImpl.this.nodeEngine.operationService.waitForBackups(response.callId, response.backupCount, 5L, TimeUnit.SECONDS);
                    if (!ok) {
                        if (InvocationImpl.this.logger.isLoggable(Level.FINEST)) {
                            InvocationImpl.this.logger.log(Level.FINEST, "Backup response cannot be received -> " + InvocationImpl.this.toString());
                        }
                        if (InvocationImpl.this.nodeEngine.getClusterService().getMember(InvocationImpl.this.target) == null) {
                            return RETRY_RESPONSE;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return response.response;
        }

        private Object resolveResponse(Object response) throws ExecutionException, InterruptedException, TimeoutException {
            if (response instanceof Throwable) {
                if (InvocationImpl.this.remote) {
                    ExceptionUtil.fixRemoteStackTrace((Throwable)response, Thread.currentThread().getStackTrace());
                }
                if (response instanceof ExecutionException) {
                    throw (ExecutionException)response;
                }
                if (response instanceof TimeoutException) {
                    throw (TimeoutException)response;
                }
                if (response instanceof Error) {
                    throw (Error)response;
                }
                if (response instanceof InterruptedException) {
                    throw (InterruptedException)response;
                }
                throw new ExecutionException((Throwable)response);
            }
            if (response == NULL_RESPONSE) {
                return null;
            }
            if (response == TIMEOUT_RESPONSE) {
                throw new TimeoutException();
            }
            return response;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.done = true;
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("InvocationFuture{");
            sb.append("invocation=").append(InvocationImpl.this.toString());
            sb.append(", done=").append(this.done);
            sb.append('}');
            return sb.toString();
        }
    }

    private class CallbackResponseProcessor
    implements ResponseProcessor {
        private CallbackResponseProcessor() {
        }

        @Override
        public void process(Object response) {
            if (response == RETRY_RESPONSE) {
                InvocationImpl.this.responseQ.offer(WAIT_RESPONSE);
                ExecutionService ex = InvocationImpl.this.nodeEngine.getExecutionService();
                ex.schedule(new ScheduledTaskRunner(ex.getExecutor("hz:async-inv"), new ScheduledInv()), InvocationImpl.this.tryPauseMillis, TimeUnit.MILLISECONDS);
            } else if (response == WAIT_RESPONSE) {
                InvocationImpl.this.responseQ.offer(WAIT_RESPONSE);
            } else {
                InvocationImpl.this.responseQ.offer(response);
                Callback<Object> callbackLocal = InvocationImpl.this.callback;
                if (callbackLocal != null) {
                    try {
                        Object realResponse;
                        if (response instanceof Response) {
                            Response responseObj = (Response)response;
                            realResponse = responseObj.response;
                        } else {
                            realResponse = response == NULL_RESPONSE ? null : response;
                        }
                        callbackLocal.notify(realResponse);
                    }
                    catch (Throwable e) {
                        InvocationImpl.this.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }

        class ScheduledInv
        implements Runnable {
            ScheduledInv() {
            }

            @Override
            public void run() {
                InvocationImpl.this.doInvoke();
            }
        }
    }

    private class DefaultResponseProcessor
    implements ResponseProcessor {
        private DefaultResponseProcessor() {
        }

        @Override
        public void process(Object response) {
            InvocationImpl.this.responseQ.offer(response);
        }
    }

    private static interface ResponseProcessor {
        public void process(Object var1);
    }
}

