/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;

public abstract class AbstractDistributedObject<S extends RemoteService>
implements DistributedObject {
    private volatile NodeEngine nodeEngine;
    private volatile S service;

    protected AbstractDistributedObject(NodeEngine nodeEngine, S service) {
        this.nodeEngine = nodeEngine;
        this.service = service;
    }

    @Override
    public final void destroy() {
        NodeEngine engine = this.getNodeEngine();
        engine.getProxyService().destroyDistributedObject(this.getServiceName(), this.getId());
    }

    public final NodeEngine getNodeEngine() {
        NodeEngine engine = this.nodeEngine;
        this.lifecycleCheck(engine);
        return engine;
    }

    private void lifecycleCheck(NodeEngine engine) {
        if (engine == null || !engine.isActive()) {
            throw this.throwNotActiveException();
        }
    }

    protected RuntimeException throwNotActiveException() {
        throw new HazelcastInstanceNotActiveException();
    }

    public final S getService() {
        S s = this.service;
        if (s == null) {
            throw new HazelcastInstanceNotActiveException();
        }
        return s;
    }

    public abstract String getServiceName();

    final void invalidate() {
        this.nodeEngine = null;
        this.service = null;
    }
}

