/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue;

import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.queue.QueueItem;
import com.hazelcast.queue.QueueStoreWrapper;
import com.hazelcast.queue.QueueWaitNotifyKey;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class QueueContainer
implements DataSerializable {
    private LinkedList<QueueItem> itemQueue = null;
    private HashMap<Long, QueueItem> backupMap = null;
    private final Map<Long, QueueItem> txMap = new HashMap<Long, QueueItem>();
    private final HashMap<Long, Data> dataMap = new HashMap();
    private int partitionId;
    private QueueConfig config;
    private QueueStoreWrapper store;
    private NodeEngine nodeEngine;
    private ILogger logger;
    private long idGenerator = 0L;
    private final QueueWaitNotifyKey pollWaitNotifyKey;
    private final QueueWaitNotifyKey offerWaitNotifyKey;
    private volatile long minAge;
    private volatile long maxAge;
    private volatile long totalAge;
    private volatile long totalAgedCount;

    public QueueContainer(String name) {
        this.pollWaitNotifyKey = new QueueWaitNotifyKey((Object)name, "poll");
        this.offerWaitNotifyKey = new QueueWaitNotifyKey((Object)name, "offer");
    }

    public QueueContainer(String name, int partitionId, QueueConfig config, NodeEngine nodeEngine, boolean fromBackup) throws Exception {
        this(name);
        Set<Long> keys;
        this.partitionId = partitionId;
        this.setConfig(config, nodeEngine);
        if (!fromBackup && this.store.isEnabled() && (keys = this.store.loadAllKeys()) != null) {
            for (Long key : keys) {
                QueueItem item = new QueueItem(this, key, null);
                this.getItemQueue().offer(item);
                this.nextId();
            }
        }
    }

    public boolean txnEnsureReserve(long itemId) {
        if (this.txMap.get(itemId) == null) {
            throw new TransactionException("No reserve for itemId: " + itemId);
        }
        return true;
    }

    public QueueItem txnPollReserve(long reservedOfferId) {
        QueueItem item = this.getItemQueue().poll();
        if (item == null) {
            item = this.txMap.remove(reservedOfferId);
            return item;
        }
        if (this.store.isEnabled() && item.getData() == null) {
            try {
                this.load(item);
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        this.txMap.put(item.getItemId(), item);
        return new QueueItem(null, item.getItemId(), item.getData());
    }

    public boolean txnPollBackupReserve(long itemId) {
        QueueItem item = this.getBackupMap().remove(itemId);
        if (item == null) {
            throw new TransactionException("Backup reserve failed: " + itemId);
        }
        this.txMap.put(itemId, item);
        return true;
    }

    public Data txnCommitPoll(long itemId) {
        QueueItem item = this.txMap.remove(itemId);
        if (item == null) {
            this.logger.log(Level.WARNING, "txnCommitPoll operation-> No txn item for itemId: " + itemId);
            return null;
        }
        if (this.store.isEnabled()) {
            try {
                this.store.delete(item.getItemId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return item.getData();
    }

    public boolean txnRollbackPoll(long itemId, boolean backup) {
        QueueItem item = this.txMap.remove(itemId);
        if (item == null) {
            this.logger.log(Level.WARNING, "No txn item for itemId: " + itemId);
            return false;
        }
        if (!backup) {
            this.getItemQueue().offerFirst(item);
        }
        return true;
    }

    public long txnOfferReserve() {
        QueueItem item = new QueueItem(this, this.nextId(), null);
        this.txMap.put(item.getItemId(), item);
        return item.getItemId();
    }

    public void txnOfferBackupReserve(long itemId) {
        QueueItem item = new QueueItem(this, itemId, null);
        QueueItem o = this.txMap.put(itemId, item);
        if (o != null) {
            this.logger.log(Level.SEVERE, "txnOfferBackupReserve operation-> Item exists already at txMap for itemId: " + itemId);
        }
    }

    public boolean txnCommitOffer(long itemId, Data data, boolean backup) {
        QueueItem item = this.txMap.remove(itemId);
        if (item == null && !backup) {
            throw new TransactionException("No reserve :" + itemId);
        }
        if (item == null) {
            item = new QueueItem(this, itemId, data);
        }
        item.setData(data);
        if (!backup) {
            this.getItemQueue().offer(item);
        } else {
            this.getBackupMap().put(itemId, item);
        }
        if (this.store.isEnabled()) {
            try {
                this.store.store((Long)item.getItemId(), data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean txnRollbackOffer(long itemId) {
        QueueItem item = this.txMap.remove(itemId);
        if (item == null) {
            this.logger.log(Level.WARNING, "txnRollbackOffer operation-> No txn item for itemId: " + itemId);
            return false;
        }
        return true;
    }

    public long offer(Data data) {
        QueueItem item = new QueueItem(this, this.nextId(), null);
        if (this.store.isEnabled()) {
            try {
                this.store.store((Long)item.getItemId(), data);
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        if (!this.store.isEnabled() || this.store.getMemoryLimit() > this.getItemQueue().size()) {
            item.setData(data);
        }
        this.getItemQueue().offer(item);
        return item.getItemId();
    }

    public void offerBackup(Data data, long itemId) {
        QueueItem item = new QueueItem(this, itemId, null);
        if (!this.store.isEnabled() || this.store.getMemoryLimit() > this.getItemQueue().size()) {
            item.setData(data);
        }
        this.getBackupMap().put(itemId, item);
    }

    public Map<Long, Data> addAll(Collection<Data> dataList) {
        HashMap<Long, Data> map = new HashMap<Long, Data>(dataList.size());
        for (Data data : dataList) {
            QueueItem item = new QueueItem(this, this.nextId(), null);
            if (!this.store.isEnabled() || this.store.getMemoryLimit() > this.getItemQueue().size()) {
                item.setData(data);
            }
            this.getItemQueue().offer(item);
            map.put(item.getItemId(), data);
        }
        if (this.store.isEnabled()) {
            try {
                this.store.storeAll((Map<Long, Data>)map);
            }
            catch (Exception e) {
                for (int i = 0; i < dataList.size(); ++i) {
                    this.getItemQueue().poll();
                }
                throw new HazelcastException(e);
            }
        }
        return map;
    }

    public void addAllBackup(Map<Long, Data> dataMap) {
        for (Map.Entry<Long, Data> entry : dataMap.entrySet()) {
            QueueItem item = new QueueItem(this, entry.getKey(), null);
            if (!this.store.isEnabled() || this.store.getMemoryLimit() > this.getItemQueue().size()) {
                item.setData(entry.getValue());
            }
            this.getBackupMap().put(item.getItemId(), item);
        }
    }

    public QueueItem peek() {
        QueueItem item = this.getItemQueue().peek();
        if (item == null) {
            return null;
        }
        if (this.store.isEnabled() && item.getData() == null) {
            try {
                this.load(item);
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        return item;
    }

    public QueueItem poll() {
        QueueItem item = this.peek();
        if (item == null) {
            return null;
        }
        if (this.store.isEnabled()) {
            try {
                this.store.delete(item.getItemId());
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        this.getItemQueue().poll();
        this.age(item, Clock.currentTimeMillis());
        return item;
    }

    public void pollBackup(long itemId) {
        QueueItem item = this.getBackupMap().remove(itemId);
        if (item != null) {
            this.age(item, Clock.currentTimeMillis());
        }
    }

    public Map<Long, Data> drain(int maxSize) {
        if (maxSize < 0 || maxSize > this.getItemQueue().size()) {
            maxSize = this.getItemQueue().size();
        }
        LinkedHashMap<Long, Data> map = new LinkedHashMap<Long, Data>(maxSize);
        Iterator iter = this.getItemQueue().iterator();
        for (int i = 0; i < maxSize; ++i) {
            QueueItem item = (QueueItem)iter.next();
            if (this.store.isEnabled() && item.getData() == null) {
                try {
                    this.load(item);
                }
                catch (Exception e) {
                    throw new HazelcastException(e);
                }
            }
            map.put(item.getItemId(), item.getData());
        }
        if (this.store.isEnabled()) {
            try {
                this.store.deleteAll(map.keySet());
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        long current = Clock.currentTimeMillis();
        for (int i = 0; i < maxSize; ++i) {
            QueueItem item = this.getItemQueue().poll();
            this.age(item, current);
        }
        return map;
    }

    public void drainFromBackup(Set<Long> itemIdSet) {
        for (Long itemId : itemIdSet) {
            this.pollBackup(itemId);
        }
        this.dataMap.clear();
    }

    public int size() {
        return Math.min(this.config.getMaxSize(), this.getItemQueue().size());
    }

    public int backupSize() {
        return this.getBackupMap().size();
    }

    public Map<Long, Data> clear() {
        long current = Clock.currentTimeMillis();
        LinkedHashMap<Long, Data> map = new LinkedHashMap<Long, Data>(this.getBackupMap().size());
        for (QueueItem item : this.getBackupMap().values()) {
            map.put(item.getItemId(), item.getData());
            this.age(item, current);
        }
        if (this.store.isEnabled()) {
            try {
                this.store.deleteAll(map.keySet());
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        this.getItemQueue().clear();
        this.dataMap.clear();
        return map;
    }

    public void clearBackup(Set<Long> itemIdSet) {
        this.drainFromBackup(itemIdSet);
    }

    public long remove(Data data) {
        Iterator iter = this.getItemQueue().iterator();
        while (iter.hasNext()) {
            QueueItem item = (QueueItem)iter.next();
            if (!data.equals(item.getData())) continue;
            if (this.store.isEnabled()) {
                try {
                    this.store.delete(item.getItemId());
                }
                catch (Exception e) {
                    throw new HazelcastException(e);
                }
            }
            iter.remove();
            this.age(item, Clock.currentTimeMillis());
            return item.getItemId();
        }
        return -1L;
    }

    public void removeBackup(long itemId) {
        this.getBackupMap().remove(itemId);
    }

    public boolean contains(Collection<Data> dataSet) {
        for (Data data : dataSet) {
            boolean contains = false;
            for (QueueItem item : this.getItemQueue()) {
                if (item.getData() == null || !item.getData().equals(data)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public List<Data> getAsDataList() {
        ArrayList<Data> dataList = new ArrayList<Data>(this.getItemQueue().size());
        for (QueueItem item : this.getItemQueue()) {
            if (this.store.isEnabled() && item.getData() == null) {
                try {
                    this.load(item);
                }
                catch (Exception e) {
                    throw new HazelcastException(e);
                }
            }
            dataList.add(item.getData());
        }
        return dataList;
    }

    public Map<Long, Data> compareAndRemove(Collection<Data> dataList, boolean retain) {
        LinkedHashMap<Long, Data> map = new LinkedHashMap<Long, Data>();
        for (QueueItem item : this.getItemQueue()) {
            if (item.getData() == null && this.store.isEnabled()) {
                try {
                    this.load(item);
                }
                catch (Exception e) {
                    throw new HazelcastException(e);
                }
            }
            boolean contains = dataList.contains(item.getData());
            if ((!retain || contains) && (retain || !contains)) continue;
            map.put(item.getItemId(), item.getData());
        }
        if (map.size() > 0) {
            if (this.store.isEnabled()) {
                try {
                    this.store.deleteAll(map.keySet());
                }
                catch (Exception e) {
                    throw new HazelcastException(e);
                }
            }
            Iterator iter = this.getItemQueue().iterator();
            while (iter.hasNext()) {
                QueueItem item;
                item = (QueueItem)iter.next();
                if (!map.containsKey(item.getItemId())) continue;
                iter.remove();
                this.age(item, Clock.currentTimeMillis());
            }
        }
        return map;
    }

    public void compareAndRemoveBackup(Set<Long> itemIdSet) {
        this.drainFromBackup(itemIdSet);
    }

    private void load(QueueItem item) throws Exception {
        int bulkLoad = this.store.getBulkLoad();
        bulkLoad = Math.min(this.getItemQueue().size(), bulkLoad);
        if (bulkLoad == 1) {
            item.setData(this.store.load(item.getItemId()));
        } else if (bulkLoad > 1) {
            ListIterator iter = this.getItemQueue().listIterator();
            HashSet<Long> keySet = new HashSet<Long>(bulkLoad);
            for (int i = 0; i < bulkLoad; ++i) {
                keySet.add(((QueueItem)iter.next()).getItemId());
            }
            Map<Long, Data> values = this.store.loadAll(keySet);
            this.dataMap.putAll(values);
            item.setData(this.getDataFromMap(item.getItemId()));
        }
    }

    public boolean hasEnoughCapacity() {
        return this.hasEnoughCapacity(1);
    }

    public boolean hasEnoughCapacity(int delta) {
        return this.getItemQueue().size() + delta <= this.config.getMaxSize();
    }

    LinkedList<QueueItem> getItemQueue() {
        if (this.itemQueue == null) {
            this.itemQueue = new LinkedList();
            if (this.backupMap != null && !this.backupMap.isEmpty()) {
                ArrayList<QueueItem> values = new ArrayList<QueueItem>(this.backupMap.values());
                Collections.sort(values);
                this.itemQueue.addAll(values);
                this.backupMap.clear();
                this.backupMap = null;
            }
        }
        return this.itemQueue;
    }

    Map<Long, QueueItem> getBackupMap() {
        if (this.backupMap == null) {
            this.backupMap = new HashMap();
            if (this.itemQueue != null) {
                for (QueueItem item : this.itemQueue) {
                    this.backupMap.put(item.getItemId(), item);
                }
                this.itemQueue.clear();
                this.itemQueue = null;
            }
        }
        return this.backupMap;
    }

    public Data getDataFromMap(long itemId) {
        return this.dataMap.remove(itemId);
    }

    public void setConfig(QueueConfig config, NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(QueueContainer.class);
        this.store = new QueueStoreWrapper(nodeEngine.getSerializationService());
        this.config = new QueueConfig(config);
        QueueStoreConfig storeConfig = config.getQueueStoreConfig();
        this.store.setConfig(storeConfig);
    }

    long nextId() {
        return this.idGenerator++;
    }

    void setId(long itemId) {
        this.idGenerator = Math.max(itemId + 1L, this.idGenerator);
    }

    public QueueWaitNotifyKey getPollWaitNotifyKey() {
        return this.pollWaitNotifyKey;
    }

    public QueueWaitNotifyKey getOfferWaitNotifyKey() {
        return this.offerWaitNotifyKey;
    }

    public QueueConfig getConfig() {
        return this.config;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    private void age(QueueItem item, long currentTime) {
        long elapsed = currentTime - item.getCreationTime();
        if (elapsed <= 0L) {
            return;
        }
        ++this.totalAgedCount;
        this.totalAge += elapsed;
        if (this.minAge == 0L) {
            this.minAge = elapsed;
            this.maxAge = elapsed;
        } else {
            this.minAge = Math.min(this.minAge, elapsed);
            this.maxAge = Math.max(this.maxAge, elapsed);
        }
    }

    public void setStats(LocalQueueStatsImpl stats) {
        stats.setMinAge(this.minAge);
        this.minAge = 0L;
        stats.setMaxAge(this.maxAge);
        this.maxAge = 0L;
        long totalAgeVal = this.totalAge;
        this.totalAge = 0L;
        long totalAgedCountVal = this.totalAgedCount;
        this.totalAgedCount = 0L;
        totalAgedCountVal = totalAgedCountVal == 0L ? 1L : totalAgedCountVal;
        stats.setAveAge(totalAgeVal / totalAgedCountVal);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.partitionId);
        out.writeInt(this.getItemQueue().size());
        for (QueueItem item : this.getItemQueue()) {
            item.writeData(out);
        }
        out.writeInt(this.txMap.size());
        for (QueueItem item : this.txMap.values()) {
            item.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.partitionId = in.readInt();
        int size = in.readInt();
        for (int j = 0; j < size; ++j) {
            QueueItem item = new QueueItem(this, -1L, null);
            item.readData(in);
            this.getItemQueue().offer(item);
            this.setId(item.getItemId());
        }
        int txSize = in.readInt();
        for (int j = 0; j < txSize; ++j) {
            QueueItem item = new QueueItem(this, -1L, null);
            item.readData(in);
            this.txMap.put(item.getItemId(), item);
            this.setId(item.getItemId());
        }
    }

    public void destroy() {
        if (this.itemQueue != null) {
            this.itemQueue.clear();
        }
        if (this.backupMap != null) {
            this.backupMap.clear();
        }
        this.txMap.clear();
        this.dataMap.clear();
    }
}

