/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public enum MigrationStatus {
    STARTED(0),
    COMPLETED(1),
    FAILED(-1);

    private final byte code;

    private MigrationStatus(int code) {
        this.code = (byte)code;
    }

    public static void writeTo(MigrationStatus status, DataOutput out) throws IOException {
        out.writeByte(status.code);
    }

    public static MigrationStatus readFrom(DataInput in) throws IOException {
        byte code = in.readByte();
        switch (code) {
            case 0: {
                return STARTED;
            }
            case 1: {
                return COMPLETED;
            }
            case -1: {
                return FAILED;
            }
        }
        return null;
    }
}

