/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.BaseMigrationOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.MigrationOperation;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class MigrationRequestOperation
extends BaseMigrationOperation {
    public MigrationRequestOperation() {
    }

    public MigrationRequestOperation(MigrationInfo migrationInfo) {
        super(migrationInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Address masterAddress = nodeEngine.getMasterAddress();
        if (!masterAddress.equals(this.migrationInfo.getMaster())) {
            throw new RetryableHazelcastException("Migration initiator is not master node! => " + this.toString());
        }
        if (!masterAddress.equals(this.getCallerAddress())) {
            throw new RetryableHazelcastException("Caller is not master node! => " + this.toString());
        }
        Address from = this.migrationInfo.getSource();
        Address to = this.migrationInfo.getDestination();
        if (to.equals(from)) {
            this.getLogger().log(Level.WARNING, "To and from addresses are the same! => " + this.toString());
            this.success = false;
            return;
        }
        if (from == null) {
            this.getLogger().log(Level.FINEST, "From address is null => " + this.toString());
        }
        if (this.migrationInfo.startProcessing()) {
            try {
                MemberImpl target = nodeEngine.getClusterService().getMember(to);
                if (target == null) {
                    throw new RetryableHazelcastException("Destination of migration could not be found! => " + this.toString());
                }
                PartitionServiceImpl partitionService = (PartitionServiceImpl)this.getService();
                partitionService.addActiveMigration(this.migrationInfo);
                long[] replicaVersions = partitionService.getPartitionReplicaVersions(this.migrationInfo.getPartitionId());
                long timeout = nodeEngine.getGroupProperties().PARTITION_MIGRATION_TIMEOUT.getLong();
                Collection<Operation> tasks = this.prepareMigrationTasks();
                if (tasks.size() > 0) {
                    SerializationService serializationService = nodeEngine.getSerializationService();
                    BufferObjectDataOutput out = serializationService.createObjectDataOutput(32768);
                    try {
                        out.writeInt(tasks.size());
                        for (Operation task : tasks) {
                            serializationService.writeObject(out, task);
                        }
                        byte[] data = IOUtil.compress(out.toByteArray());
                        MigrationOperation migrationOperation = new MigrationOperation(this.migrationInfo, replicaVersions, data, tasks.size());
                        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)migrationOperation, to).setTryPauseMillis(1000L).setReplicaIndex(this.getReplicaIndex()).build();
                        Future future = inv.invoke();
                        this.success = (Boolean)nodeEngine.toObject(future.get(timeout, TimeUnit.SECONDS));
                    }
                    finally {
                        IOUtil.closeResource(out);
                    }
                }
                this.success = true;
            }
            catch (Throwable e) {
                if (e instanceof ExecutionException) {
                    e = e.getCause() != null ? e.getCause() : e;
                }
                Level level = e instanceof MemberLeftException || e instanceof InterruptedException || !this.getNodeEngine().isActive() ? Level.INFO : Level.WARNING;
                this.getLogger().log(level, e.getMessage(), e);
                this.success = false;
            }
            finally {
                this.migrationInfo.doneProcessing();
            }
        } else {
            this.getLogger().log(Level.WARNING, "Migration is cancelled -> " + this.migrationInfo);
            this.success = false;
        }
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    private Collection<Operation> prepareMigrationTasks() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionReplicationEvent replicationEvent = new PartitionReplicationEvent(this.migrationInfo.getPartitionId(), 0);
        PartitionMigrationEvent migrationEvent = new PartitionMigrationEvent(MigrationEndpoint.SOURCE, this.migrationInfo.getPartitionId());
        LinkedList<Operation> tasks = new LinkedList<Operation>();
        for (ServiceInfo serviceInfo : nodeEngine.getServiceInfos(MigrationAwareService.class)) {
            MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
            Operation op = service.prepareReplicationOperation(replicationEvent);
            if (op == null) continue;
            op.setServiceName(serviceInfo.getName());
            service.beforeMigration(migrationEvent);
            tasks.add(op);
        }
        return tasks;
    }
}

