/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.BaseMigrationOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public final class MigrationOperation
extends BaseMigrationOperation {
    private static final ResponseHandler ERROR_RESPONSE_HANDLER = new ErrorResponseHandler();
    private long[] replicaVersions;
    private transient Collection<Operation> tasks;
    private byte[] zippedTaskData;
    private int taskCount;

    public MigrationOperation() {
    }

    public MigrationOperation(MigrationInfo migrationInfo, long[] replicaVersions, byte[] taskData, int taskCount) {
        super(migrationInfo);
        this.replicaVersions = replicaVersions;
        this.taskCount = taskCount;
        this.zippedTaskData = taskData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        block9: {
            block10: {
                NodeEngine nodeEngine = this.getNodeEngine();
                if (!nodeEngine.getMasterAddress().equals(this.migrationInfo.getMaster())) {
                    throw new RetryableHazelcastException("Migration initiator is not master node! => " + this.toString());
                }
                SerializationService serializationService = nodeEngine.getSerializationService();
                BufferObjectDataInput in = null;
                if (!this.migrationInfo.startProcessing()) break block10;
                try {
                    byte[] taskData = IOUtil.decompress(this.zippedTaskData);
                    in = serializationService.createObjectDataInput(taskData);
                    int size = in.readInt();
                    this.tasks = new ArrayList<Operation>(size);
                    for (int i = 0; i < size; ++i) {
                        Operation task = (Operation)serializationService.readObject(in);
                        this.tasks.add(task);
                    }
                    if (this.taskCount != this.tasks.size()) {
                        this.getLogger().log(Level.SEVERE, "Migration task count mismatch! => expected-count: " + size + ", actual-count: " + this.tasks.size() + "\nfrom: " + this.migrationInfo.getSource() + ", partition: " + this.getPartitionId() + ", replica: " + this.getReplicaIndex());
                    }
                    this.success = this.runMigrationTasks();
                    if (this.success) {
                        PartitionServiceImpl partitionService = (PartitionServiceImpl)this.getService();
                        partitionService.setPartitionReplicaVersions(this.migrationInfo.getPartitionId(), this.replicaVersions);
                    }
                    this.migrationInfo.doneProcessing();
                }
                catch (Throwable e) {
                    try {
                        Level level = Level.WARNING;
                        if (e instanceof IllegalStateException) {
                            level = Level.FINEST;
                        }
                        this.getLogger().log(level, e.getMessage(), e);
                        this.success = false;
                        this.migrationInfo.doneProcessing();
                    }
                    catch (Throwable throwable) {
                        this.migrationInfo.doneProcessing();
                        IOUtil.closeResource(in);
                        throw throwable;
                    }
                    IOUtil.closeResource(in);
                    break block9;
                }
                IOUtil.closeResource(in);
                break block9;
            }
            this.getLogger().log(Level.WARNING, "Migration is cancelled -> " + this.migrationInfo);
            this.success = false;
        }
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    private boolean runMigrationTasks() {
        boolean error = false;
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionServiceImpl partitionService = (PartitionServiceImpl)this.getService();
        partitionService.addActiveMigration(this.migrationInfo);
        for (Operation op : this.tasks) {
            try {
                op.setNodeEngine(nodeEngine).setPartitionId(this.getPartitionId()).setReplicaIndex(this.getReplicaIndex());
                op.setResponseHandler(ERROR_RESPONSE_HANDLER);
                OperationAccessor.setCallerAddress(op, this.migrationInfo.getSource());
                MigrationAwareService service = (MigrationAwareService)op.getService();
                service.beforeMigration(new PartitionMigrationEvent(MigrationEndpoint.DESTINATION, this.migrationInfo.getPartitionId()));
                op.beforeRun();
                op.run();
                op.afterRun();
            }
            catch (Throwable e) {
                error = true;
                this.getLogger().log(Level.SEVERE, "While executing " + op, e);
                break;
            }
        }
        return !error;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.taskCount);
        out.writeInt(this.zippedTaskData.length);
        out.write(this.zippedTaskData);
        out.writeLongArray(this.replicaVersions);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskCount = in.readInt();
        int size = in.readInt();
        this.zippedTaskData = new byte[size];
        in.readFully(this.zippedTaskData);
        this.replicaVersions = in.readLongArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{partitionId=").append(this.getPartitionId());
        sb.append(", migration=").append(this.migrationInfo);
        sb.append(", taskCount=").append(this.taskCount);
        sb.append('}');
        return sb.toString();
    }

    private static class ErrorResponseHandler
    implements ResponseHandler {
        private ErrorResponseHandler() {
        }

        @Override
        public void sendResponse(Object obj) {
            throw new HazelcastException("Migration operations can not send response!");
        }
    }
}

