/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.SystemLogService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionMonitor;
import com.hazelcast.nio.IOSelector;
import com.hazelcast.nio.ReadHandler;
import com.hazelcast.nio.SocketChannelWrapper;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.TcpIpConnectionManager;
import com.hazelcast.nio.WriteHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.logging.Level;

public final class TcpIpConnection
implements Connection {
    private final SocketChannelWrapper socketChannel;
    private final ReadHandler readHandler;
    private final WriteHandler writeHandler;
    private final TcpIpConnectionManager connectionManager;
    private volatile boolean live = true;
    private volatile Type type = Type.NONE;
    private Address endPoint = null;
    private final ILogger logger;
    private final SystemLogService systemLogService;
    private final int connectionId;
    private ConnectionMonitor monitor;

    public TcpIpConnection(TcpIpConnectionManager connectionManager, IOSelector in, IOSelector out, int connectionId, SocketChannelWrapper socketChannel) {
        this.connectionId = connectionId;
        this.logger = connectionManager.ioService.getLogger(TcpIpConnection.class.getName());
        this.systemLogService = connectionManager.ioService.getSystemLogService();
        this.connectionManager = connectionManager;
        this.socketChannel = socketChannel;
        this.readHandler = new ReadHandler(this, in);
        this.writeHandler = new WriteHandler(this, out);
    }

    public SystemLogService getSystemLogService() {
        return this.systemLogService;
    }

    public Type getType() {
        return this.type;
    }

    public TcpIpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public boolean write(SocketWritable packet) {
        if (!this.live) {
            this.logger.log(Level.FINEST, "Connection is closed, won't write packet -> " + packet);
            return false;
        }
        this.writeHandler.enqueueSocketWritable(packet);
        return true;
    }

    @Override
    public boolean isClient() {
        return this.type != null && this.type != Type.NONE && this.type.isClient();
    }

    public void setType(Type type) {
        if (this.type == Type.NONE) {
            this.type = type;
        }
    }

    public SocketChannelWrapper getSocketChannelWrapper() {
        return this.socketChannel;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socketChannel.socket().getInetAddress();
    }

    @Override
    public int getPort() {
        return this.socketChannel.socket().getPort();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress();
    }

    public ReadHandler getReadHandler() {
        return this.readHandler;
    }

    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    @Override
    public boolean live() {
        return this.live;
    }

    @Override
    public long lastWriteTime() {
        return this.writeHandler.getLastHandle();
    }

    @Override
    public long lastReadTime() {
        return this.readHandler.getLastHandle();
    }

    @Override
    public Address getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Address endPoint) {
        this.endPoint = endPoint;
    }

    public void setMonitor(ConnectionMonitor monitor) {
        this.monitor = monitor;
    }

    public ConnectionMonitor getMonitor() {
        return this.monitor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TcpIpConnection)) {
            return false;
        }
        TcpIpConnection that = (TcpIpConnection)o;
        return this.connectionId == that.getConnectionId();
    }

    public int hashCode() {
        return this.connectionId;
    }

    public void close0() throws IOException {
        if (!this.live) {
            return;
        }
        this.live = false;
        if (this.socketChannel != null && this.socketChannel.isOpen()) {
            this.socketChannel.close();
        }
        this.readHandler.shutdown();
        this.writeHandler.shutdown();
    }

    @Override
    public void close() {
        this.close(null);
    }

    public void close(Throwable t) {
        try {
            this.close0();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        Address connAddress = this.endPoint == null ? this.socketChannel.socket().getRemoteSocketAddress() : this.endPoint;
        String message = "Connection [" + connAddress + "] lost. Reason: ";
        message = t != null ? message + t.getClass().getName() + "[" + t.getMessage() + "]" : message + "Explicit close";
        this.logger.log(Level.INFO, message);
        this.systemLogService.logConnection(message);
        this.connectionManager.destroyConnection(this);
        this.connectionManager.ioService.onDisconnect(this.endPoint);
        if (t != null && this.monitor != null) {
            this.monitor.onError(t);
        }
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String toString() {
        Socket socket = this.socketChannel.socket();
        SocketAddress remoteSocketAddress = socket != null ? socket.getRemoteSocketAddress() : null;
        return "Connection [" + remoteSocketAddress + " -> " + this.endPoint + "] live=" + this.live + ", client=" + this.isClient() + ", type=" + (Object)((Object)this.type);
    }

    public static enum Type {
        NONE(false, false),
        MEMBER(true, true),
        BINARY_CLIENT(false, true),
        PROTOCOL_CLIENT(false, true),
        REST_CLIENT(false, false),
        MEMCACHE_CLIENT(false, false);

        final boolean member;
        final boolean binary;

        private Type(boolean member, boolean binary) {
            this.member = member;
            this.binary = binary;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public boolean isClient() {
            return !this.member;
        }
    }
}

