/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SocketReadable;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataAdapter;
import com.hazelcast.nio.serialization.SerializationContext;
import java.nio.ByteBuffer;

public final class Packet
extends DataAdapter
implements SocketWritable,
SocketReadable {
    public static final byte PACKET_VERSION = 1;
    private static final int stHeader = stBit++;
    private static final int stPartition = stBit++;
    public static final int HEADER_OP = 0;
    public static final int HEADER_RESPONSE = 1;
    public static final int HEADER_EVENT = 2;
    public static final int HEADER_WAN_REPLICATION = 3;
    private short header;
    private int partitionId;
    private transient Connection conn;

    public Packet(SerializationContext context) {
        super(context);
    }

    public Packet(Data value, SerializationContext context) {
        this(value, -1, context);
    }

    public Packet(Data value, int partitionId, SerializationContext context) {
        super(value, context);
        this.partitionId = partitionId;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public void setHeader(int bit) {
        this.header = (short)(this.header | 1 << bit);
    }

    public boolean isHeaderSet(int bit) {
        return (this.header & 1 << bit) != 0;
    }

    public short getHeader() {
        return this.header;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public final boolean writeTo(ByteBuffer destination) {
        if (!this.isStatusSet(stHeader)) {
            if (destination.remaining() < 2) {
                return false;
            }
            destination.putShort(this.header);
            this.setStatus(stHeader);
        }
        if (!this.isStatusSet(stPartition)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.partitionId);
            this.setStatus(stPartition);
        }
        return super.writeTo(destination);
    }

    @Override
    public final boolean readFrom(ByteBuffer source) {
        if (!this.isStatusSet(stHeader)) {
            if (source.remaining() < 2) {
                return false;
            }
            this.header = source.getShort();
            this.setStatus(stHeader);
        }
        if (!this.isStatusSet(stPartition)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.partitionId = source.getInt();
            this.setStatus(stPartition);
        }
        return super.readFrom(source);
    }

    public int size() {
        return (this.data != null ? this.data.totalSize() : 0) + 6;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Packet{");
        sb.append("header=").append(this.header);
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", conn=").append(this.conn);
        sb.append('}');
        return sb.toString();
    }
}

