/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.AbstractRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

public class CachedDataRecord
extends AbstractRecord<Data> {
    private volatile Data value;
    private volatile Object cachedValue;

    public CachedDataRecord(Data keyData, Data value, boolean statisticsEnabled) {
        super(keyData, statisticsEnabled);
        this.value = value;
    }

    @Override
    public Data getValue() {
        return this.value;
    }

    @Override
    public Data setValue(Data o) {
        this.cachedValue = null;
        Data old = null;
        this.value = o;
        return old;
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    @Override
    public long getCost() {
        return this.key.totalSize() + this.value.totalSize();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        this.value.writeData(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.value = new Data();
        this.value.readData(in);
    }
}

