/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.PutAllBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class PutAllOperation
extends AbstractMapOperation
implements PartitionAwareOperation,
BackupAwareOperation {
    private MapEntrySet entrySet;
    private transient MapEntrySet backupEntrySet;

    public PutAllOperation(String name, MapEntrySet entrySet) {
        super(name);
        this.entrySet = entrySet;
    }

    public PutAllOperation() {
    }

    @Override
    public void run() {
        this.backupEntrySet = new MapEntrySet();
        int partitionId = this.getPartitionId();
        RecordStore recordStore = this.mapService.getRecordStore(partitionId, this.name);
        Set<Map.Entry<Data, Data>> entries = this.entrySet.getEntrySet();
        PartitionService partitionService = this.getNodeEngine().getPartitionService();
        for (Map.Entry<Data, Data> entry : entries) {
            Data dataKey = entry.getKey();
            Data dataValue = entry.getValue();
            if (partitionId != partitionService.getPartitionId(dataKey)) continue;
            Data dataOldValue = this.mapService.toData(recordStore.put(dataKey, dataValue, -1L));
            this.mapService.interceptAfterPut(this.name, dataValue);
            int eventType = dataOldValue == null ? EntryEvent.TYPE_ADDED : EntryEvent.TYPE_UPDATED;
            this.mapService.publishEvent(this.getCallerAddress(), this.name, eventType, dataKey, dataOldValue, dataValue);
            this.invalidateNearCaches(dataKey);
            if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
                SimpleEntryView<Data, Data> entryView = new SimpleEntryView<Data, Data>(dataKey, this.mapService.toData(dataValue), recordStore.getRecords().get(dataKey));
                this.mapService.publishWanReplicationUpdate(this.name, entryView);
            }
            this.backupEntrySet.add(entry);
        }
    }

    protected final void invalidateNearCaches(Data key) {
        if (this.mapContainer.isNearCacheEnabled() && this.mapContainer.getMapConfig().getNearCacheConfig().isInvalidateOnChange()) {
            this.mapService.invalidateAllNearCaches(this.name, key);
        }
    }

    @Override
    public Object getResponse() {
        return this.entrySet;
    }

    public String toString() {
        return "PutAllOperation{}";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entrySet);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entrySet = (MapEntrySet)in.readObject();
    }

    @Override
    public boolean shouldBackup() {
        return !this.backupEntrySet.getEntrySet().isEmpty();
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PutAllBackupOperation(this.name, this.backupEntrySet);
    }
}

