/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.AbstractMapOperation;
import com.hazelcast.map.operation.PartitionWideEntryBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class PartitionWideEntryOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    EntryProcessor entryProcessor;
    MapEntrySet response;

    public PartitionWideEntryOperation(String name, EntryProcessor entryProcessor) {
        super(name);
        this.entryProcessor = entryProcessor;
    }

    public PartitionWideEntryOperation() {
    }

    @Override
    public void run() {
        this.response = new MapEntrySet();
        RecordStore recordStore = this.mapService.getRecordStore(this.getPartitionId(), this.name);
        Map<Data, Record> records = recordStore.getRecords();
        for (Map.Entry<Data, Record> recordEntry : records.entrySet()) {
            Data dataKey = recordEntry.getKey();
            Record record = recordEntry.getValue();
            AbstractMap.SimpleEntry<Object, Object> entry = new AbstractMap.SimpleEntry<Object, Object>(this.mapService.toObject(record.getKey()), this.mapService.toObject(record.getValue()));
            Object result = this.entryProcessor.process(entry);
            if (result != null) {
                this.response.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(dataKey, this.mapService.toData(result)));
            }
            recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(dataKey, entry.getValue()));
        }
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    public String toString() {
        return "PartitionWideEntryOperation{}";
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount() + this.mapContainer.getBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PartitionWideEntryBackupOperation(this.name, this.entryProcessor.getBackupProcessor());
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }
}

