/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.operation.LockAwareOperation;
import com.hazelcast.map.operation.RemoveBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class EvictOperation
extends LockAwareOperation
implements BackupAwareOperation {
    boolean evicted = false;
    boolean asyncBackup = false;

    public EvictOperation(String name, Data dataKey, boolean asyncBackup) {
        super(name, dataKey);
        this.asyncBackup = asyncBackup;
    }

    public EvictOperation() {
    }

    @Override
    public void run() {
        this.dataValue = this.mapService.toData(this.recordStore.evict(this.dataKey));
        this.evicted = this.dataValue != null;
    }

    @Override
    public Object getResponse() {
        return this.evicted;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(false);
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveBackupOperation(this.name, this.dataKey);
    }

    @Override
    public int getAsyncBackupCount() {
        if (this.asyncBackup) {
            return this.mapService.getMapContainer(this.name).getTotalBackupCount();
        }
        return this.mapService.getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        if (this.asyncBackup) {
            return 0;
        }
        return this.mapService.getMapContainer(this.name).getBackupCount();
    }

    @Override
    public boolean shouldBackup() {
        return this.evicted;
    }

    @Override
    public void afterRun() {
        this.mapService.interceptAfterRemove(this.name, this.dataValue);
        int eventType = EntryEvent.TYPE_EVICTED;
        this.mapService.publishEvent(this.getCallerAddress(), this.name, eventType, this.dataKey, this.dataValue, null);
        this.invalidateNearCaches();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.asyncBackup);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.asyncBackup = in.readBoolean();
    }

    public String toString() {
        return "EvictOperation{" + this.name + "}";
    }
}

