/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.InvocationClientRequest;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.map.QueryResult;
import com.hazelcast.map.operation.QueryOperation;
import com.hazelcast.map.operation.QueryPartitionOperation;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryDataResultStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;

abstract class AbstractMapQueryRequest
extends InvocationClientRequest
implements Portable,
RetryableRequest {
    private String name;
    private IterationType iterationType;

    public AbstractMapQueryRequest() {
    }

    public AbstractMapQueryRequest(String name, IterationType iterationType) {
        this.name = name;
        this.iterationType = iterationType;
    }

    @Override
    protected final void invoke() {
        Collection<MemberImpl> members = this.getClientEngine().getClusterService().getMemberList();
        int partitionCount = this.getClientEngine().getPartitionService().getPartitionCount();
        HashSet<Integer> plist = new HashSet<Integer>(partitionCount);
        ClientEndpoint endpoint = this.getEndpoint();
        QueryDataResultStream result = new QueryDataResultStream(this.iterationType, true);
        try {
            ArrayList<Future> flist = new ArrayList<Future>();
            Predicate predicate = this.getPredicate();
            for (MemberImpl member : members) {
                Invocation invocation = this.createInvocationBuilder("hz:impl:mapService", (Operation)new QueryOperation(this.name, predicate), member.getAddress()).build();
                Future future = invocation.invoke();
                flist.add(future);
            }
            for (Future future : flist) {
                List<Integer> partitionIds;
                QueryResult queryResult = (QueryResult)future.get();
                if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null) continue;
                plist.addAll(partitionIds);
                result.addAll(queryResult.getResult());
            }
            if (plist.size() != partitionCount) {
                ArrayList<Integer> missingList = new ArrayList<Integer>();
                for (int i = 0; i < partitionCount; ++i) {
                    if (plist.contains(i)) continue;
                    missingList.add(i);
                }
                ArrayList<Future> futures = new ArrayList<Future>(missingList.size());
                for (Integer pid : missingList) {
                    QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.name, predicate);
                    queryPartitionOperation.setPartitionId(pid);
                    try {
                        Future f = this.createInvocationBuilder("hz:impl:mapService", (Operation)queryPartitionOperation, pid).build().invoke();
                        futures.add(f);
                    }
                    catch (Throwable t) {
                        throw ExceptionUtil.rethrow(t);
                    }
                }
                for (Future future : futures) {
                    QueryResult queryResult = (QueryResult)future.get();
                    result.addAll(queryResult.getResult());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw ExceptionUtil.rethrow(t);
        }
        finally {
            result.end();
        }
        this.getClientEngine().sendResponse(endpoint, result);
    }

    protected abstract Predicate getPredicate();

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public final int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("t", this.iterationType.toString());
        this.writePortableInner(writer);
    }

    protected abstract void writePortableInner(PortableWriter var1) throws IOException;

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.iterationType = IterationType.valueOf(reader.readUTF("t"));
        this.readPortableInner(reader);
    }

    protected abstract void readPortableInner(PortableReader var1) throws IOException;
}

