/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.record.CachedDataRecord;
import com.hazelcast.map.record.DataRecord;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryableEntrySet
extends AbstractSet<QueryableEntry> {
    private final List<Map<Data, Record>> recordMapList;
    private final SerializationService serializationService;

    public QueryableEntrySet(SerializationService serializationService, List<Map<Data, Record>> recordMapList) {
        this.recordMapList = recordMapList;
        this.serializationService = serializationService;
    }

    @Override
    public Iterator<QueryableEntry> iterator() {
        return new RecordIterator();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    class RecordIterator
    implements Iterator<QueryableEntry> {
        final Iterator<Map<Data, Record>> iter;
        Iterator<Record> innerIterator;
        Record currentEntry = null;

        RecordIterator() {
            this.iter = QueryableEntrySet.this.recordMapList.iterator();
            if (this.iter.hasNext()) {
                this.innerIterator = this.iter.next().values().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.innerIterator == null) {
                return false;
            }
            if (this.innerIterator.hasNext()) {
                this.currentEntry = this.innerIterator.next();
                return true;
            }
            if (this.iter.hasNext()) {
                this.innerIterator = this.iter.next().values().iterator();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public QueryableEntry next() {
            if (this.currentEntry == null) {
                return null;
            }
            Record record = this.currentEntry;
            Data key = record.getKey();
            Object value = null;
            if (record instanceof CachedDataRecord) {
                CachedDataRecord cachedDataRecord = (CachedDataRecord)record;
                value = cachedDataRecord.getCachedValue();
                if (value == null) {
                    value = QueryableEntrySet.this.serializationService.toObject(cachedDataRecord.getValue());
                    cachedDataRecord.setCachedValue(value);
                }
            } else {
                value = record instanceof DataRecord ? QueryableEntrySet.this.serializationService.toObject(((DataRecord)record).getValue()) : record.getValue();
            }
            return new QueryEntry(QueryableEntrySet.this.serializationService, key, key, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

