/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.ascii.rest.HttpCommand;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.management.ConsoleCommandHandler;
import com.hazelcast.management.ManagementCenterIdentifier;
import com.hazelcast.management.operation.ManagementCenterConfigOperation;
import com.hazelcast.management.request.ClusterPropsRequest;
import com.hazelcast.management.request.ConsoleCommandRequest;
import com.hazelcast.management.request.ConsoleRequest;
import com.hazelcast.management.request.EvictLocalMapRequest;
import com.hazelcast.management.request.ExecuteScriptRequest;
import com.hazelcast.management.request.GetLogLevelRequest;
import com.hazelcast.management.request.GetLogsRequest;
import com.hazelcast.management.request.GetMapEntryRequest;
import com.hazelcast.management.request.GetMemberSystemPropertiesRequest;
import com.hazelcast.management.request.MapConfigRequest;
import com.hazelcast.management.request.MemberConfigRequest;
import com.hazelcast.management.request.RunGcRequest;
import com.hazelcast.management.request.RuntimeStateRequest;
import com.hazelcast.management.request.SetLogLevelRequest;
import com.hazelcast.management.request.ShutdownMemberRequest;
import com.hazelcast.management.request.ThreadDumpRequest;
import com.hazelcast.management.request.VersionMismatchLogRequest;
import com.hazelcast.monitor.TimedMemberState;
import com.hazelcast.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.monitor.impl.LocalQueueStatsImpl;
import com.hazelcast.monitor.impl.LocalTopicStatsImpl;
import com.hazelcast.monitor.impl.MemberStateImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.ObjectDataInputStream;
import com.hazelcast.nio.serialization.ObjectDataOutputStream;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.Operation;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class ManagementCenterService
implements LifecycleListener,
MembershipListener {
    private final HazelcastInstanceImpl instance;
    private final TaskPoller taskPoller;
    private final StateSender stateSender;
    private final ILogger logger;
    private final ConsoleCommandHandler commandHandler;
    private final int maxVisibleInstanceCount;
    private final int updateIntervalMs;
    private final ManagementCenterConfig managementCenterConfig;
    private final SerializationService serializationService;
    private final ManagementCenterIdentifier identifier;
    private AtomicBoolean running = new AtomicBoolean(false);
    private volatile String webServerUrl;
    private volatile boolean urlChanged = false;
    private boolean versionMismatch = false;

    public ManagementCenterService(HazelcastInstanceImpl instance) {
        this.instance = instance;
        this.logger = this.instance.node.getLogger(ManagementCenterService.class.getName());
        this.managementCenterConfig = this.instance.node.config.getManagementCenterConfig();
        if (this.managementCenterConfig == null) {
            throw new IllegalStateException("ManagementCenterConfig should not be null!");
        }
        this.instance.getLifecycleService().addLifecycleListener(this);
        this.instance.getCluster().addMembershipListener(this);
        this.maxVisibleInstanceCount = this.instance.node.groupProperties.MC_MAX_INSTANCE_COUNT.getInteger();
        this.commandHandler = new ConsoleCommandHandler(this.instance);
        String tmpWebServerUrl = this.managementCenterConfig.getUrl();
        this.webServerUrl = tmpWebServerUrl != null ? (!tmpWebServerUrl.endsWith("/") ? tmpWebServerUrl + '/' : tmpWebServerUrl) : null;
        this.updateIntervalMs = this.managementCenterConfig.getUpdateInterval() > 0 ? this.managementCenterConfig.getUpdateInterval() * 1000 : 5000;
        this.taskPoller = new TaskPoller();
        this.stateSender = new StateSender();
        this.serializationService = instance.node.getSerializationService();
        Address address = instance.node.address;
        this.identifier = new ManagementCenterIdentifier(instance.node.initializer.getVersion(), instance.getConfig().getGroupConfig().getName(), address.getHost() + ":" + address.getPort());
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            if (this.webServerUrl != null) {
                this.taskPoller.start();
                this.stateSender.start();
                this.logger.log(Level.INFO, "Hazelcast will connect to Management Center on address: " + this.webServerUrl);
            } else {
                this.logger.log(Level.WARNING, "Hazelcast Management Center web-server URL is null!");
            }
        }
    }

    public void shutdown() {
        if (this.running.compareAndSet(true, false)) {
            this.logger.log(Level.INFO, "Shutting down Hazelcast Management Center");
            try {
                this.interruptThread(this.stateSender);
                this.interruptThread(this.taskPoller);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void stateChanged(LifecycleEvent event) {
        if (event.getState() == LifecycleEvent.LifecycleState.STARTED && this.managementCenterConfig.isEnabled()) {
            try {
                this.start();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "ManagementCenterService could not be started!", e);
            }
        }
    }

    public byte[] changeWebServerUrlOverCluster(String groupName, String groupPass, String newUrl) {
        try {
            GroupConfig groupConfig = this.instance.getConfig().getGroupConfig();
            if (!groupConfig.getName().equals(groupName) || !groupConfig.getPassword().equals(groupPass)) {
                return HttpCommand.RES_403;
            }
            ManagementCenterConfigOperation operation = new ManagementCenterConfigOperation(newUrl);
            this.sendToAllMembers(operation);
        }
        catch (Throwable throwable) {
            this.logger.log(Level.WARNING, "New web server url cannot be assigned.", throwable);
            return HttpCommand.RES_500;
        }
        return HttpCommand.RES_204;
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        try {
            Member member = membershipEvent.getMember();
            if (member != null && this.instance.node.isMaster() && this.urlChanged) {
                ManagementCenterConfigOperation operation = new ManagementCenterConfigOperation(this.webServerUrl);
                this.call(((MemberImpl)member).getAddress(), operation);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Web server url cannot be send to the newly joined member", e);
        }
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
    }

    public void changeWebServerUrl(String newUrl) {
        if (newUrl == null) {
            return;
        }
        String string = this.webServerUrl = newUrl.endsWith("/") ? newUrl : newUrl + "/";
        if (!this.running.get()) {
            this.start();
        }
        this.urlChanged = true;
        this.logger.log(Level.INFO, "Web server URL has been changed. Hazelcast will connect to Management Center on address: " + this.webServerUrl);
    }

    private void interruptThread(Thread t) {
        if (t != null) {
            t.interrupt();
        }
    }

    public void setVersionMismatch(boolean mismatch) {
        this.versionMismatch = mismatch;
    }

    private void createMemberState(MemberStateImpl memberState) {
        Node node = this.instance.node;
        memberState.setAddress(node.getThisAddress());
        PartitionService partitionService = this.instance.getPartitionService();
        Set<Partition> partitions = partitionService.getPartitions();
        memberState.clearPartitions();
        for (Partition partition : partitions) {
            if (partition.getOwner() == null || !partition.getOwner().localMember()) continue;
            memberState.addPartition(partition.getPartitionId());
        }
        ArrayList<DistributedObject> proxyObjects = new ArrayList<DistributedObject>(this.instance.getDistributedObjects());
        this.createRuntimeProps(memberState);
        this.createMemState(memberState, proxyObjects);
    }

    private void createRuntimeProps(MemberStateImpl memberState) {
        Runtime runtime = Runtime.getRuntime();
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        ClassLoadingMXBean clMxBean = ManagementFactory.getClassLoadingMXBean();
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemory = memoryMxBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemory = memoryMxBean.getNonHeapMemoryUsage();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("runtime.availableProcessors", Integer.valueOf(runtime.availableProcessors()).longValue());
        map.put("date.startTime", runtimeMxBean.getStartTime());
        map.put("seconds.upTime", runtimeMxBean.getUptime());
        map.put("memory.maxMemory", runtime.maxMemory());
        map.put("memory.freeMemory", runtime.freeMemory());
        map.put("memory.totalMemory", runtime.totalMemory());
        map.put("memory.heapMemoryMax", heapMemory.getMax());
        map.put("memory.heapMemoryUsed", heapMemory.getUsed());
        map.put("memory.nonHeapMemoryMax", nonHeapMemory.getMax());
        map.put("memory.nonHeapMemoryUsed", nonHeapMemory.getUsed());
        map.put("runtime.totalLoadedClassCount", clMxBean.getTotalLoadedClassCount());
        map.put("runtime.loadedClassCount", Integer.valueOf(clMxBean.getLoadedClassCount()).longValue());
        map.put("runtime.unloadedClassCount", clMxBean.getUnloadedClassCount());
        map.put("runtime.totalStartedThreadCount", threadMxBean.getTotalStartedThreadCount());
        map.put("runtime.threadCount", Integer.valueOf(threadMxBean.getThreadCount()).longValue());
        map.put("runtime.peakThreadCount", Integer.valueOf(threadMxBean.getPeakThreadCount()).longValue());
        map.put("runtime.daemonThreadCount", Integer.valueOf(threadMxBean.getDaemonThreadCount()).longValue());
        memberState.setRuntimeProps(map);
    }

    private void createMemState(MemberStateImpl memberState, Collection<DistributedObject> distributedObjects) {
        int count = 0;
        Config config = this.getHazelcastInstance().getConfig();
        for (DistributedObject distributedObject : distributedObjects) {
            IExecutorService executorService;
            if (count >= this.maxVisibleInstanceCount) continue;
            if (distributedObject instanceof IMap) {
                IMap map = (IMap)distributedObject;
                if (!config.getMapConfig(map.getName()).isStatisticsEnabled()) continue;
                memberState.putLocalMapStats(map.getName(), (LocalMapStatsImpl)map.getLocalMapStats());
                ++count;
                continue;
            }
            if (distributedObject instanceof IQueue) {
                IQueue queue = (IQueue)distributedObject;
                if (!config.getQueueConfig(queue.getName()).isStatisticsEnabled()) continue;
                memberState.putLocalQueueStats(queue.getName(), (LocalQueueStatsImpl)queue.getLocalQueueStats());
                ++count;
                continue;
            }
            if (distributedObject instanceof ITopic) {
                ITopic topic = (ITopic)distributedObject;
                if (!config.getTopicConfig(topic.getName()).isStatisticsEnabled()) continue;
                memberState.putLocalTopicStats(topic.getName(), (LocalTopicStatsImpl)topic.getLocalTopicStats());
                ++count;
                continue;
            }
            if (distributedObject instanceof MultiMap) {
                MultiMap multiMap = (MultiMap)distributedObject;
                if (!config.getMultiMapConfig(multiMap.getName()).isStatisticsEnabled()) continue;
                memberState.putLocalMultiMapStats(multiMap.getName(), (LocalMultiMapStatsImpl)multiMap.getLocalMultiMapStats());
                ++count;
                continue;
            }
            if (!(distributedObject instanceof IExecutorService) || !config.getExecutorConfig((executorService = (IExecutorService)distributedObject).getName()).isStatisticsEnabled()) continue;
            memberState.putLocalExecutorStats(executorService.getName(), (LocalExecutorStatsImpl)executorService.getLocalExecutorStats());
            ++count;
        }
    }

    private Set<String> getLongInstanceNames() {
        HashSet<String> setLongInstanceNames = new HashSet<String>(this.maxVisibleInstanceCount);
        ArrayList<DistributedObject> proxyObjects = new ArrayList<DistributedObject>(this.instance.getDistributedObjects());
        this.collectInstanceNames(setLongInstanceNames, proxyObjects);
        return setLongInstanceNames;
    }

    private void collectInstanceNames(Set<String> setLongInstanceNames, Collection<DistributedObject> distributedObjects) {
        int count = 0;
        Config config = this.getHazelcastInstance().getConfig();
        for (DistributedObject distributedObject : distributedObjects) {
            IExecutorService executorService;
            if (count >= this.maxVisibleInstanceCount) continue;
            if (distributedObject instanceof MultiMap) {
                MultiMap multiMap = (MultiMap)distributedObject;
                if (!config.getMultiMapConfig(multiMap.getName()).isStatisticsEnabled()) continue;
                setLongInstanceNames.add("m:" + multiMap.getName());
                ++count;
                continue;
            }
            if (distributedObject instanceof IMap) {
                IMap map = (IMap)distributedObject;
                if (!config.getMapConfig(map.getName()).isStatisticsEnabled()) continue;
                setLongInstanceNames.add("c:" + map.getName());
                ++count;
                continue;
            }
            if (distributedObject instanceof IQueue) {
                IQueue queue = (IQueue)distributedObject;
                if (!config.getQueueConfig(queue.getName()).isStatisticsEnabled()) continue;
                setLongInstanceNames.add("q:" + queue.getName());
                ++count;
                continue;
            }
            if (distributedObject instanceof ITopic) {
                ITopic topic = (ITopic)distributedObject;
                if (!config.getTopicConfig(topic.getName()).isStatisticsEnabled()) continue;
                setLongInstanceNames.add("t:" + topic.getName());
                ++count;
                continue;
            }
            if (!(distributedObject instanceof IExecutorService) || !config.getExecutorConfig((executorService = (IExecutorService)distributedObject).getName()).isStatisticsEnabled()) continue;
            setLongInstanceNames.add("e:" + executorService.getName());
            ++count;
        }
    }

    public Object call(Address address, Operation operation) {
        Invocation invocation = this.instance.node.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", operation, address).build();
        Future future = invocation.invoke();
        try {
            return future.get();
        }
        catch (Throwable t) {
            StringWriter s = new StringWriter();
            t.printStackTrace(new PrintWriter(s));
            return s.toString();
        }
    }

    public void send(Address address, Operation operation) {
        Invocation invocation = this.instance.node.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", operation, address).build();
        invocation.invoke();
    }

    public Collection callOnAddresses(Set<Address> addresses, Operation operation) {
        ArrayList<Object> list = new ArrayList<Object>(addresses.size());
        for (Address address : addresses) {
            list.add(this.call(address, operation));
        }
        return list;
    }

    public Collection callOnAllMembers(Operation operation) {
        Collection<MemberImpl> members = this.instance.node.clusterService.getMemberList();
        ArrayList<Object> list = new ArrayList<Object>(members.size());
        for (MemberImpl member : members) {
            list.add(this.call(member.getAddress(), operation));
        }
        return list;
    }

    public void sendToAllMembers(Operation operation) {
        Collection<MemberImpl> members = this.instance.node.clusterService.getMemberList();
        for (MemberImpl member : members) {
            this.send(member.getAddress(), operation);
        }
    }

    private TimedMemberState getTimedMemberState() {
        if (this.running.get()) {
            MemberStateImpl memberState = new MemberStateImpl();
            this.createMemberState(memberState);
            GroupConfig groupConfig = this.instance.getConfig().getGroupConfig();
            TimedMemberState timedMemberState = new TimedMemberState();
            timedMemberState.setMaster(this.instance.node.isMaster());
            if (timedMemberState.getMaster().booleanValue()) {
                timedMemberState.setMemberList(new ArrayList<String>());
                Set<Member> memberSet = this.instance.getCluster().getMembers();
                for (Member member : memberSet) {
                    MemberImpl memberImpl = (MemberImpl)member;
                    Address address = memberImpl.getAddress();
                    timedMemberState.getMemberList().add(address.getHost() + ":" + address.getPort());
                }
            }
            timedMemberState.setMemberState(memberState);
            timedMemberState.setClusterName(groupConfig.getName());
            timedMemberState.setInstanceNames(this.getLongInstanceNames());
            return timedMemberState;
        }
        return null;
    }

    public HazelcastInstanceImpl getHazelcastInstance() {
        return this.instance;
    }

    public ConsoleCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    class TaskPoller
    extends Thread {
        final ConsoleRequest[] consoleRequests;

        TaskPoller() {
            super(((ManagementCenterService)ManagementCenterService.this).instance.node.threadGroup, ((ManagementCenterService)ManagementCenterService.this).instance.node.getThreadNamePrefix("MC.Task.Poller"));
            this.consoleRequests = new ConsoleRequest[20];
            this.register(new RuntimeStateRequest());
            this.register(new ThreadDumpRequest());
            this.register(new ExecuteScriptRequest());
            this.register(new EvictLocalMapRequest());
            this.register(new ConsoleCommandRequest());
            this.register(new MapConfigRequest());
            this.register(new MemberConfigRequest());
            this.register(new ClusterPropsRequest());
            this.register(new SetLogLevelRequest());
            this.register(new GetLogLevelRequest());
            this.register(new GetLogsRequest());
            this.register(new RunGcRequest());
            this.register(new GetMemberSystemPropertiesRequest());
            this.register(new GetMapEntryRequest());
            this.register(new VersionMismatchLogRequest());
            this.register(new ShutdownMemberRequest());
        }

        public void register(ConsoleRequest consoleRequest) {
            this.consoleRequests[consoleRequest.getType()] = consoleRequest;
        }

        public void sendResponse(int taskId, ConsoleRequest request) {
            try {
                URL url = new URL(ManagementCenterService.this.webServerUrl + "putResponse.do");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(2000);
                OutputStream outputStream = connection.getOutputStream();
                ManagementCenterService.this.identifier.write(outputStream);
                ObjectDataOutputStream out = ManagementCenterService.this.serializationService.createObjectDataOutputStream(outputStream);
                out.writeInt(taskId);
                out.writeInt(request.getType());
                request.writeResponse(ManagementCenterService.this, out);
                connection.getInputStream();
            }
            catch (Exception e) {
                ManagementCenterService.this.logger.log(Level.FINEST, e.getMessage(), e);
            }
        }

        @Override
        public void run() {
            if (ManagementCenterService.this.webServerUrl == null) {
                ManagementCenterService.this.logger.log(Level.WARNING, "Web server url is null!");
                return;
            }
            try {
                Random rand = new Random();
                Address address = ((MemberImpl)((ManagementCenterService)ManagementCenterService.this).instance.node.getClusterService().getLocalMember()).getAddress();
                GroupConfig groupConfig = ManagementCenterService.this.instance.getConfig().getGroupConfig();
                while (ManagementCenterService.this.running.get()) {
                    if (ManagementCenterService.this.versionMismatch) {
                        Thread.sleep(60000L);
                        ManagementCenterService.this.versionMismatch = false;
                    }
                    try {
                        ConsoleRequest request;
                        URL url = new URL(ManagementCenterService.this.webServerUrl + "getTask.do?member=" + address.getHost() + ":" + address.getPort() + "&cluster=" + groupConfig.getName());
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestProperty("Connection", "keep-alive");
                        InputStream inputStream = connection.getInputStream();
                        ObjectDataInputStream input = ManagementCenterService.this.serializationService.createObjectDataInputStream(inputStream);
                        int taskId = input.readInt();
                        int requestType = input.readInt();
                        if (taskId > 0 && requestType < this.consoleRequests.length && (request = this.consoleRequests[requestType]) != null) {
                            request.readData(input);
                            this.sendResponse(taskId, request);
                        }
                    }
                    catch (Exception e) {
                        ManagementCenterService.this.logger.log(Level.FINEST, e.getMessage(), e);
                    }
                    Thread.sleep(700 + rand.nextInt(300));
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof OutOfMemoryError) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)throwable);
                }
                ManagementCenterService.this.logger.log(Level.FINEST, "Problem on management center while polling task.", throwable);
            }
        }
    }

    class StateSender
    extends Thread {
        StateSender() {
            super(ManagementCenterService.this.instance.getThreadGroup(), ((ManagementCenterService)ManagementCenterService.this).instance.node.getThreadNamePrefix("MC.State.Sender"));
        }

        @Override
        public void run() {
            if (ManagementCenterService.this.webServerUrl == null) {
                ManagementCenterService.this.logger.log(Level.WARNING, "Web server url is null!");
                return;
            }
            try {
                while (ManagementCenterService.this.running.get()) {
                    if (ManagementCenterService.this.versionMismatch) {
                        Thread.sleep(60000L);
                        ManagementCenterService.this.versionMismatch = false;
                    }
                    try {
                        URL url = new URL(ManagementCenterService.this.webServerUrl + "collector.do");
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setDoOutput(true);
                        connection.setRequestMethod("POST");
                        connection.setConnectTimeout(1000);
                        connection.setReadTimeout(1000);
                        OutputStream outputStream = connection.getOutputStream();
                        ManagementCenterService.this.identifier.write(outputStream);
                        ObjectDataOutputStream out = ManagementCenterService.this.serializationService.createObjectDataOutputStream(outputStream);
                        TimedMemberState ts = ManagementCenterService.this.getTimedMemberState();
                        ts.writeData(out);
                        out.flush();
                        connection.getInputStream();
                    }
                    catch (Exception e) {
                        ManagementCenterService.this.logger.log(Level.FINEST, e.getMessage(), e);
                    }
                    Thread.sleep(ManagementCenterService.this.updateIntervalMs);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof OutOfMemoryError) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)throwable);
                }
                ManagementCenterService.this.logger.log(Level.FINEST, "Web Management Center will be closed due to exception.", throwable);
                ManagementCenterService.this.shutdown();
            }
        }
    }
}

