/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.DefaultNodeInitializer;
import com.hazelcast.instance.NodeInitializer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.ServiceLoader;
import java.util.logging.Level;

public final class NodeInitializerFactory {
    private static final ILogger logger = Logger.getLogger(NodeInitializerFactory.class.getName());
    private static final String FACTORY_ID = "com.hazelcast.NodeInitializer";

    public static NodeInitializer create(ClassLoader classLoader) {
        NodeInitializer initializer = null;
        try {
            initializer = ServiceLoader.load(NodeInitializer.class, FACTORY_ID, classLoader);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "NodeInitializer could not be instantiated! => " + e.getClass().getName() + ": " + e.getMessage());
        }
        return initializer != null ? initializer : NodeInitializerFactory.createDefault();
    }

    public static NodeInitializer createDefault() {
        return new DefaultNodeInitializer();
    }
}

