/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.ascii.TextCommandService;
import com.hazelcast.ascii.TextCommandServiceImpl;
import com.hazelcast.client.ClientEngineImpl;
import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.cluster.ConfigCheck;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.Joiner;
import com.hazelcast.cluster.MulticastJoiner;
import com.hazelcast.cluster.MulticastService;
import com.hazelcast.cluster.NodeMulticastListener;
import com.hazelcast.cluster.TcpIpJoiner;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.instance.NodeInitializer;
import com.hazelcast.instance.NodeInitializerFactory;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.logging.SystemLogService;
import com.hazelcast.management.ManagementCenterService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.SerializationServiceBuilder;
import com.hazelcast.nio.serialization.SerializationServiceImpl;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ProxyServiceImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.VersionCheck;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.Collections;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class Node {
    private final ILogger logger;
    private final AtomicBoolean joined;
    private volatile boolean active;
    private volatile boolean completelyShutdown;
    private final Set<Address> failedConnections;
    private final NodeShutdownHookThread shutdownHookThread;
    private final SerializationServiceImpl serializationService;
    public final NodeEngineImpl nodeEngine;
    public final ClientEngineImpl clientEngine;
    public final PartitionServiceImpl partitionService;
    public final ClusterServiceImpl clusterService;
    public final MulticastService multicastService;
    public final ConnectionManager connectionManager;
    public final TextCommandServiceImpl textCommandService;
    public final Config config;
    public final GroupProperties groupProperties;
    public final Address address;
    public final MemberImpl localMember;
    private volatile Address masterAddress;
    public final HazelcastInstanceImpl hazelcastInstance;
    private final int buildNumber;
    public final LoggingServiceImpl loggingService;
    private final SystemLogService systemLogService;
    private final Joiner joiner;
    public final NodeInitializer initializer;
    private ManagementCenterService managementCenterService;
    public final SecurityContext securityContext;
    public final ThreadGroup threadGroup;
    private final ClassLoader configClassLoader;

    public Node(HazelcastInstanceImpl hazelcastInstance, Config config, NodeContext nodeContext) {
        MulticastService mcService;
        block14: {
            SerializationService ss;
            this.joined = new AtomicBoolean(false);
            this.active = false;
            this.completelyShutdown = false;
            this.failedConnections = Collections.newSetFromMap(new ConcurrentHashMap());
            this.shutdownHookThread = new NodeShutdownHookThread("hz.ShutdownThread");
            this.masterAddress = null;
            this.hazelcastInstance = hazelcastInstance;
            this.threadGroup = hazelcastInstance.threadGroup;
            this.config = config;
            this.configClassLoader = config.getClassLoader();
            this.groupProperties = new GroupProperties(config);
            try {
                ss = new SerializationServiceBuilder().setClassLoader(this.configClassLoader).setConfig(config.getSerializationConfig()).setManagedContext(hazelcastInstance.managedContext).build();
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
            this.serializationService = (SerializationServiceImpl)ss;
            this.systemLogService = new SystemLogService(this);
            AddressPicker addressPicker = nodeContext.createAddressPicker(this);
            try {
                addressPicker.pickAddress();
            }
            catch (Throwable e) {
                throw ExceptionUtil.rethrow(e);
            }
            ServerSocketChannel serverSocketChannel = addressPicker.getServerSocketChannel();
            this.address = addressPicker.getPublicAddress();
            this.localMember = new MemberImpl(this.address, true, UuidUtil.createMemberUuid(this.address));
            String loggingType = this.groupProperties.LOGGING_TYPE.getString();
            this.loggingService = new LoggingServiceImpl(this.systemLogService, config.getGroupConfig().getName(), loggingType, this.localMember);
            this.logger = this.loggingService.getLogger(Node.class.getName());
            this.initializer = NodeInitializerFactory.create(this.configClassLoader);
            try {
                this.initializer.beforeInitialize(this);
            }
            catch (Throwable e) {
                try {
                    serverSocketChannel.close();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                throw ExceptionUtil.rethrow(e);
            }
            this.securityContext = config.getSecurityConfig().isEnabled() ? this.initializer.getSecurityContext() : null;
            this.nodeEngine = new NodeEngineImpl(this);
            this.clientEngine = new ClientEngineImpl(this);
            this.connectionManager = nodeContext.createConnectionManager(this, serverSocketChannel);
            this.partitionService = new PartitionServiceImpl(this);
            this.clusterService = new ClusterServiceImpl(this);
            this.textCommandService = new TextCommandServiceImpl(this);
            this.initializer.printNodeInfo(this);
            this.buildNumber = this.initializer.getBuildNumber();
            VersionCheck.check(this, this.initializer.getBuild(), this.initializer.getVersion());
            JoinConfig join = config.getNetworkConfig().getJoin();
            mcService = null;
            try {
                if (!join.getMulticastConfig().isEnabled()) break block14;
                MulticastConfig multicastConfig = join.getMulticastConfig();
                MulticastSocket multicastSocket = new MulticastSocket(null);
                multicastSocket.setReuseAddress(true);
                multicastSocket.bind(new InetSocketAddress(multicastConfig.getMulticastPort()));
                multicastSocket.setTimeToLive(multicastConfig.getMulticastTimeToLive());
                try {
                    Address bindAddress = addressPicker.getBindAddress();
                    if (!bindAddress.getInetAddress().isLoopbackAddress()) {
                        multicastSocket.setInterface(bindAddress.getInetAddress());
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                }
                multicastSocket.setReceiveBufferSize(65536);
                multicastSocket.setSendBufferSize(65536);
                String multicastGroup = System.getProperty("hazelcast.multicast.group");
                if (multicastGroup == null) {
                    multicastGroup = multicastConfig.getMulticastGroup();
                }
                multicastConfig.setMulticastGroup(multicastGroup);
                multicastSocket.joinGroup(InetAddress.getByName(multicastGroup));
                multicastSocket.setSoTimeout(1000);
                mcService = new MulticastService(this, multicastSocket);
                mcService.addMulticastListener(new NodeMulticastListener(this));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.multicastService = mcService;
        this.initializeListeners(config);
        this.joiner = nodeContext.createJoiner(this);
    }

    private void initializeListeners(Config config) {
        for (ListenerConfig listenerCfg : config.getListenerConfigs()) {
            EventListener listener = listenerCfg.getImplementation();
            if (listener == null) {
                try {
                    listener = ClassLoaderUtil.newInstance(this.configClassLoader, listenerCfg.getClassName());
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(this.hazelcastInstance);
            }
            if (listener instanceof DistributedObjectListener) {
                ProxyServiceImpl proxyService = (ProxyServiceImpl)this.nodeEngine.getProxyService();
                proxyService.addProxyListener((DistributedObjectListener)listener);
                continue;
            }
            if (listener instanceof MembershipListener) {
                this.clusterService.addMembershipListener((MembershipListener)listener);
                continue;
            }
            if (listener instanceof MigrationListener) {
                this.partitionService.addMigrationListener((MigrationListener)listener);
                continue;
            }
            if (listener instanceof LifecycleListener) {
                this.hazelcastInstance.lifecycleService.addLifecycleListener((LifecycleListener)listener);
                continue;
            }
            if (listener == null) continue;
            String error = "Unknown listener type: " + listener.getClass();
            IllegalArgumentException t = new IllegalArgumentException(error);
            this.logger.log(Level.WARNING, error, t);
        }
    }

    public ManagementCenterService getManagementCenterService() {
        return this.managementCenterService;
    }

    public SystemLogService getSystemLogService() {
        return this.systemLogService;
    }

    public void failedConnection(Address address) {
        this.logger.log(Level.FINEST, this.getThisAddress() + " failed connecting to " + address);
        this.failedConnections.add(address);
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClusterServiceImpl getClusterService() {
        return this.clusterService;
    }

    public PartitionServiceImpl getPartitionService() {
        return this.partitionService;
    }

    public Address getMasterAddress() {
        return this.masterAddress;
    }

    public Address getThisAddress() {
        return this.address;
    }

    public MemberImpl getLocalMember() {
        return this.localMember;
    }

    public String getName() {
        return this.hazelcastInstance.getName();
    }

    public String getThreadNamePrefix(String name) {
        return "hz." + this.getName() + "." + name;
    }

    public String getThreadPoolNamePrefix(String poolName) {
        return this.getThreadNamePrefix(poolName) + ".thread-";
    }

    public boolean joined() {
        return this.joined.get();
    }

    public boolean isMaster() {
        return this.address != null && this.address.equals(this.masterAddress);
    }

    public void setMasterAddress(Address master) {
        if (master != null) {
            this.logger.log(Level.FINEST, "** setting master address to " + master);
        }
        this.masterAddress = master;
    }

    public void start() {
        this.logger.log(Level.FINEST, "We are asked to start and completelyShutdown is " + String.valueOf(this.completelyShutdown));
        if (this.completelyShutdown) {
            return;
        }
        this.nodeEngine.start();
        this.connectionManager.start();
        if (this.config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled()) {
            Thread multicastServiceThread = new Thread(this.hazelcastInstance.threadGroup, this.multicastService, this.getThreadNamePrefix("MulticastThread"));
            multicastServiceThread.start();
        }
        this.setActive(true);
        if (!this.completelyShutdown) {
            this.logger.log(Level.FINEST, "Adding ShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
        }
        this.logger.log(Level.FINEST, "finished starting threads, calling join");
        this.join();
        int clusterSize = this.clusterService.getSize();
        if (this.config.getNetworkConfig().isPortAutoIncrement() && this.address.getPort() >= this.config.getNetworkConfig().getPort() + clusterSize) {
            StringBuilder sb = new StringBuilder("Config seed port is ");
            sb.append(this.config.getNetworkConfig().getPort());
            sb.append(" and cluster size is ");
            sb.append(clusterSize);
            sb.append(". Some of the ports seem occupied!");
            this.logger.log(Level.WARNING, sb.toString());
        }
        try {
            this.managementCenterService = new ManagementCenterService(this.hazelcastInstance);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "ManagementCenterService could not be constructed!", e);
        }
        this.initializer.afterInitialize(this);
    }

    public void shutdown(final boolean force, boolean now) {
        if (now) {
            this.doShutdown(force);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Node.this.doShutdown(force);
                }
            }).start();
        }
    }

    private void doShutdown(boolean force) {
        int maxWaitSeconds;
        long start = Clock.currentTimeMillis();
        this.logger.log(Level.FINEST, "** we are being asked to shutdown when active = " + String.valueOf(this.active));
        if (!force && this.isActive() && !this.partitionService.prepareToSafeShutdown(maxWaitSeconds = this.groupProperties.GRACEFUL_SHUTDOWN_MAX_WAIT.getInteger(), TimeUnit.SECONDS)) {
            this.logger.log(Level.WARNING, "Graceful shutdown could not be completed in " + maxWaitSeconds + " seconds!");
        }
        if (this.isActive()) {
            if (!force) {
                this.clusterService.sendShutdownMessage();
            }
            this.joined.set(false);
            this.setActive(false);
            this.setMasterAddress(null);
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            if (this.managementCenterService != null) {
                this.managementCenterService.shutdown();
            }
            this.logger.log(Level.FINEST, "Shutting down client command service");
            this.clientEngine.shutdown();
            this.logger.log(Level.FINEST, "Shutting down node engine");
            this.nodeEngine.shutdown();
            if (this.multicastService != null) {
                this.logger.log(Level.FINEST, "Shutting down multicast service");
                this.multicastService.stop();
            }
            this.logger.log(Level.FINEST, "Shutting down connection manager");
            this.connectionManager.shutdown();
            this.textCommandService.stop();
            this.masterAddress = null;
            if (this.securityContext != null) {
                this.securityContext.destroy();
            }
            this.initializer.destroy();
            this.serializationService.destroy();
            int numThreads = this.threadGroup.activeCount();
            Thread[] threads = new Thread[numThreads * 2];
            numThreads = this.threadGroup.enumerate(threads, false);
            for (int i = 0; i < numThreads; ++i) {
                Thread thread = threads[i];
                if (!thread.isAlive()) continue;
                this.logger.log(Level.FINEST, "Shutting down thread " + thread.getName());
                thread.interrupt();
            }
            this.failedConnections.clear();
            this.systemLogService.shutdown();
            this.logger.log(Level.INFO, "Hazelcast Shutdown is completed in " + (Clock.currentTimeMillis() - start) + " ms.");
        }
    }

    public void onRestart() {
        this.joined.set(false);
        this.joiner.reset();
        String uuid = UuidUtil.createMemberUuid(this.address);
        this.logger.log(Level.FINEST, "Generated new UUID for local member: " + uuid);
        this.localMember.setUuid(uuid);
    }

    public ILogger getLogger(String name) {
        return this.loggingService.getLogger(name);
    }

    public ILogger getLogger(Class clazz) {
        return this.loggingService.getLogger(clazz);
    }

    public GroupProperties getGroupProperties() {
        return this.groupProperties;
    }

    public TextCommandService getTextCommandService() {
        return this.textCommandService;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void inactivate() {
        this.joined.set(false);
        this.setActive(false);
    }

    public Set<Address> getFailedConnections() {
        return this.failedConnections;
    }

    public ClassLoader getConfigClassLoader() {
        return this.configClassLoader;
    }

    public void setJoined() {
        this.joined.set(true);
        this.systemLogService.logJoin("setJoined() master: " + this.masterAddress);
    }

    public JoinRequest createJoinRequest() {
        return this.createJoinRequest(false);
    }

    public JoinRequest createJoinRequest(boolean withCredentials) {
        Credentials credentials = withCredentials && this.securityContext != null ? this.securityContext.getCredentialsFactory().newCredentials() : null;
        return new JoinRequest(1, this.buildNumber, this.address, this.localMember.getUuid(), this.createConfigCheck(), credentials, this.clusterService.getSize(), 0);
    }

    public ConfigCheck createConfigCheck() {
        ConfigCheck configCheck = new ConfigCheck();
        GroupConfig groupConfig = this.config.getGroupConfig();
        PartitionGroupConfig partitionGroupConfig = this.config.getPartitionGroupConfig();
        boolean partitionGroupEnabled = partitionGroupConfig != null && partitionGroupConfig.isEnabled();
        configCheck.setGroupName(groupConfig.getName()).setGroupPassword(groupConfig.getPassword()).setJoinerType(this.joiner != null ? this.joiner.getType() : "").setPartitionGroupEnabled(partitionGroupEnabled).setMemberGroupType(partitionGroupEnabled ? partitionGroupConfig.getGroupType() : null);
        return configCheck;
    }

    public void rejoin() {
        this.systemLogService.logJoin("Rejoining!");
        this.masterAddress = null;
        this.joined.set(false);
        this.clusterService.reset();
        this.failedConnections.clear();
        this.join();
    }

    public void join() {
        long joinStartTime = this.joiner != null ? this.joiner.getStartTime() : Clock.currentTimeMillis();
        long maxJoinMillis = this.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000;
        try {
            if (this.joiner == null) {
                this.logger.log(Level.WARNING, "No join method is enabled! Starting standalone.");
                this.setAsMaster();
            } else {
                this.joiner.join(this.joined);
            }
        }
        catch (Exception e) {
            if (Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
                this.logger.log(Level.WARNING, "Trying to rejoin: " + e.getMessage());
                this.rejoin();
            }
            this.logger.log(Level.SEVERE, "Could not join cluster, shutting down!", e);
            this.shutdown(false, true);
        }
    }

    public Joiner getJoiner() {
        return this.joiner;
    }

    Joiner createJoiner() {
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        if (join.getMulticastConfig().isEnabled() && this.multicastService != null) {
            this.systemLogService.logJoin("Creating MulticastJoiner");
            return new MulticastJoiner(this);
        }
        if (join.getTcpIpConfig().isEnabled()) {
            this.systemLogService.logJoin("Creating TcpIpJoiner");
            return new TcpIpJoiner(this);
        }
        if (join.getAwsConfig().isEnabled()) {
            try {
                Class<?> clazz = Class.forName("com.hazelcast.impl.cluster.TcpIpJoinerOverAWS");
                Constructor<?> constructor = clazz.getConstructor(Node.class);
                this.systemLogService.logJoin("Creating AWSJoiner");
                return (Joiner)constructor.newInstance(this);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage());
                return null;
            }
        }
        return null;
    }

    public void setAsMaster() {
        this.logger.log(Level.FINEST, "This node is being set as the master");
        this.systemLogService.logJoin("No master node found! Setting this node as the master.");
        this.masterAddress = this.address;
        this.setJoined();
    }

    public Config getConfig() {
        return this.config;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return "Node[" + this.getName() + "]";
    }

    public class NodeShutdownHookThread
    extends Thread {
        NodeShutdownHookThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                if (Node.this.isActive() && !Node.this.completelyShutdown) {
                    Node.this.completelyShutdown = true;
                    if (Node.this.groupProperties.SHUTDOWNHOOK_ENABLED.getBoolean()) {
                        Node.this.shutdown(true, true);
                    }
                } else {
                    Node.this.logger.log(Level.FINEST, "shutdown hook - we are not --> active and not completely down so we are not calling shutdown");
                }
            }
            catch (Exception e) {
                Node.this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

