/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor;

import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.executor.DistributedExecutorService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.concurrent.Callable;

abstract class BaseCallableTaskOperation
extends Operation {
    protected String name;
    protected String uuid;
    protected Callable callable;

    public BaseCallableTaskOperation() {
    }

    public BaseCallableTaskOperation(String name, String uuid, Callable callable) {
        this.name = name;
        this.uuid = uuid;
        this.callable = callable;
    }

    @Override
    public final void beforeRun() throws Exception {
        if (this.callable instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)this.callable)).setHazelcastInstance(this.getNodeEngine().getHazelcastInstance());
        }
    }

    @Override
    public final void run() throws Exception {
        DistributedExecutorService service = (DistributedExecutorService)this.getService();
        service.execute(this.name, this.uuid, this.callable, this.getResponseHandler());
    }

    @Override
    public final void afterRun() throws Exception {
    }

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public final Object getResponse() {
        return null;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.uuid);
        out.writeObject(this.callable);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.uuid = in.readUTF();
        this.callable = (Callable)in.readObject();
    }
}

