/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class MembershipEvent
implements DataSerializable {
    private static final long serialVersionUID = -2010865371829087371L;
    public static final int MEMBER_ADDED = 1;
    public static final int MEMBER_REMOVED = 3;
    private Member member;
    private int eventType;

    public MembershipEvent() {
    }

    public MembershipEvent(Member member, int eventType) {
        this.member = member;
        this.eventType = eventType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.member.writeData(out);
        out.writeInt(this.eventType);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.member = new MemberImpl();
        this.member.readData(in);
        this.eventType = in.readInt();
    }

    public String toString() {
        return "MembershipEvent {" + this.member + "} " + (this.eventType == 1 ? "added" : "removed");
    }
}

