/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.PutOperation;
import com.hazelcast.collection.operations.client.CollectionKeyBasedRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class PutRequest
extends CollectionKeyBasedRequest {
    Data value;
    int index = -1;
    int threadId = -1;

    public PutRequest() {
    }

    public PutRequest(CollectionProxyId proxyId, Data key, Data value, int index, int threadId) {
        super(proxyId, key);
        this.value = value;
        this.index = index;
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new PutOperation(this.proxyId, this.key, this.threadId, this.value, this.index);
    }

    @Override
    public int getClassId() {
        return 13;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("i", this.index);
        writer.writeInt("t", this.threadId);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.value.writeData(out);
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.index = reader.readInt("i");
        this.threadId = reader.readInt("t");
        ObjectDataInput in = reader.getRawDataInput();
        this.value = new Data();
        this.value.readData(in);
        super.readPortable(reader);
    }
}

