/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.multimap.tx.TransactionalMultiMapProxySupport;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.Transaction;
import java.util.ArrayList;
import java.util.Collection;

public class TransactionalMultiMapProxy<K, V>
extends TransactionalMultiMapProxySupport
implements TransactionalMultiMap<K, V> {
    public TransactionalMultiMapProxy(NodeEngine nodeEngine, CollectionService service, CollectionProxyId proxyId, Transaction tx) {
        super(nodeEngine, service, proxyId, tx, nodeEngine.getConfig().getMultiMapConfig(proxyId.getName()));
    }

    @Override
    public boolean put(K key, V value) throws TransactionException {
        Data dataKey = this.getNodeEngine().toData(key);
        Data dataValue = this.getNodeEngine().toData(value);
        return this.putInternal(dataKey, dataValue);
    }

    @Override
    public Collection<V> get(K key) {
        Data dataKey = this.getNodeEngine().toData(key);
        Collection<CollectionRecord> coll = this.getInternal(dataKey);
        ArrayList collection = new ArrayList(coll.size());
        for (CollectionRecord record : coll) {
            collection.add(this.getNodeEngine().toObject(record.getObject()));
        }
        return collection;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Data dataKey = this.getNodeEngine().toData(key);
        Data dataValue = this.getNodeEngine().toData(value);
        return this.removeInternal(dataKey, dataValue);
    }

    @Override
    public Collection<V> remove(Object key) {
        Data dataKey = this.getNodeEngine().toData(key);
        Collection<CollectionRecord> coll = this.removeAllInternal(dataKey);
        ArrayList result = new ArrayList(coll.size());
        for (CollectionRecord record : coll) {
            result.add(this.getNodeEngine().toObject(record.getObject()));
        }
        return result;
    }

    @Override
    public int valueCount(K key) {
        Data dataKey = this.getNodeEngine().toData(key);
        return this.valueCountInternal(dataKey);
    }
}

