/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.client.GetPartitionsRequest;
import com.hazelcast.partition.client.PartitionsResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public final class ClientPartitionServiceImpl
implements ClientPartitionService {
    private final HazelcastClient client;
    private volatile int partitionCount;
    private ConcurrentHashMap<Integer, Address> partitions;

    public ClientPartitionServiceImpl(HazelcastClient client) {
        this.client = client;
    }

    public void start() {
        this.getInitialPartitions();
        this.client.getClientExecutionService().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Address master;
                ClientClusterService clusterService = ClientPartitionServiceImpl.this.client.getClientClusterService();
                PartitionsResponse response = ClientPartitionServiceImpl.this.getPartitionsFrom((ClientClusterServiceImpl)clusterService, master = clusterService.getMasterAddress());
                if (response != null) {
                    ClientPartitionServiceImpl.this.processPartitionResponse(response);
                }
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public void refreshPartitions() {
        this.client.getClientExecutionService().execute(new Runnable(){

            @Override
            public void run() {
                Address master;
                ClientClusterService clusterService = ClientPartitionServiceImpl.this.client.getClientClusterService();
                PartitionsResponse response = ClientPartitionServiceImpl.this.getPartitionsFrom((ClientClusterServiceImpl)clusterService, master = clusterService.getMasterAddress());
                if (response != null) {
                    ClientPartitionServiceImpl.this.processPartitionResponse(response);
                }
            }
        });
    }

    private void getInitialPartitions() {
        ClientClusterService clusterService = this.client.getClientClusterService();
        Collection<MemberImpl> memberList = clusterService.getMemberList();
        for (MemberImpl member : memberList) {
            Address target = member.getAddress();
            PartitionsResponse response = this.getPartitionsFrom((ClientClusterServiceImpl)clusterService, target);
            if (response == null) continue;
            this.processPartitionResponse(response);
            return;
        }
        throw new IllegalStateException("Cannot get initial partitions!");
    }

    private PartitionsResponse getPartitionsFrom(ClientClusterServiceImpl clusterService, Address address) {
        try {
            return (PartitionsResponse)clusterService.sendAndReceive(address, (Object)new GetPartitionsRequest());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void processPartitionResponse(PartitionsResponse response) {
        Address[] members = response.getMembers();
        int[] ownerIndexes = response.getOwnerIndexes();
        if (this.partitionCount == 0) {
            this.partitions = new ConcurrentHashMap(271, 0.75f, 1);
            this.partitionCount = ownerIndexes.length;
        }
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            int ownerIndex = ownerIndexes[partitionId];
            if (ownerIndex <= -1) continue;
            this.partitions.put(partitionId, members[ownerIndex]);
        }
    }

    public void stop() {
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        return this.partitions.get(partitionId);
    }

    @Override
    public int getPartitionId(Data key) {
        int pc = this.partitionCount;
        int hash = key.getPartitionHash();
        return hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % pc;
    }

    @Override
    public int getPartitionId(Object key) {
        Data data = this.client.getSerializationService().toData(key);
        return this.getPartitionId(data);
    }

    @Override
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    private class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Address owner = ClientPartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            if (owner != null) {
                return ClientPartitionServiceImpl.this.client.getClientClusterService().getMember(owner);
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PartitionImpl{");
            sb.append("partitionId=").append(this.partitionId);
            sb.append('}');
            return sb.toString();
        }
    }
}

