/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationRequest;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.client.GenericError;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.Connection;
import com.hazelcast.client.exception.AuthenticationException;
import com.hazelcast.client.exception.ClientException;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ResponseHandler;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.spi.impl.ResponseStreamImpl;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.cluster.client.AddMembershipListenerRequest;
import com.hazelcast.cluster.client.ClientMembershipEvent;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ClientClusterServiceImpl
implements ClientClusterService {
    private static int RETRY_COUNT = 20;
    private static int RETRY_WAIT_TIME = 250;
    private final HazelcastClient client;
    private final ClusterListenerThread clusterThread;
    private final AtomicReference<Map<Address, MemberImpl>> membersRef = new AtomicReference();
    private final ConcurrentMap<String, MembershipListener> listeners = new ConcurrentHashMap<String, MembershipListener>();
    private final boolean redoOperation;
    private final Credentials credentials;
    private volatile ClientPrincipal principal;

    public ClientClusterServiceImpl(HazelcastClient client) {
        this.client = client;
        this.clusterThread = new ClusterListenerThread(client.getThreadGroup(), client.getName() + ".cluster-listener");
        ClientConfig clientConfig = this.getClientConfig();
        this.redoOperation = clientConfig.isRedoOperation();
        this.credentials = clientConfig.getCredentials();
        Collection<EventListener> listenersList = client.getClientConfig().getListeners();
        if (listenersList != null && !listenersList.isEmpty()) {
            for (EventListener listener : listenersList) {
                if (!(listener instanceof MembershipListener)) continue;
                this.addMembershipListener((MembershipListener)listener);
            }
        }
    }

    @Override
    public MemberImpl getMember(Address address) {
        Map<Address, MemberImpl> members = this.membersRef.get();
        return members != null ? members.get(address) : null;
    }

    @Override
    public MemberImpl getMember(String uuid) {
        Collection<MemberImpl> memberList = this.getMemberList();
        for (MemberImpl member : memberList) {
            if (!uuid.equals(member.getUuid())) continue;
            return member;
        }
        return null;
    }

    @Override
    public Collection<MemberImpl> getMemberList() {
        Map<Address, MemberImpl> members = this.membersRef.get();
        return members != null ? members.values() : Collections.emptySet();
    }

    @Override
    public Address getMasterAddress() {
        Collection<MemberImpl> memberList = this.getMemberList();
        return !memberList.isEmpty() ? memberList.iterator().next().getAddress() : null;
    }

    @Override
    public int getSize() {
        return this.getMemberList().size();
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T sendAndReceive(Object obj) throws IOException {
        Connection conn = this.getRandomConnection();
        try {
            T t = this.sendAndReceive(conn, obj);
            return t;
        }
        finally {
            conn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T sendAndReceive(Address address, Object obj) throws IOException {
        Connection conn = this.getConnection(address);
        try {
            T t = this.sendAndReceive(conn, obj);
            return t;
        }
        finally {
            conn.release();
        }
    }

    private <T> T sendAndReceive(Connection conn, Object obj) throws IOException {
        try {
            SerializationService serializationService = this.getSerializationService();
            Data request = serializationService.toData(obj);
            conn.write(request);
            Data response = conn.read();
            return (T)serializationService.toObject(response);
        }
        catch (IOException e) {
            ((ClientPartitionServiceImpl)this.client.getClientPartitionService()).refreshPartitions();
            if (this.redoOperation || obj instanceof RetryableRequest) {
                return this.sendAndReceive(obj);
            }
            throw new HazelcastException(e);
        }
    }

    public <T> T sendAndReceiveFixedConnection(Connection conn, Object obj) throws IOException {
        SerializationService serializationService = this.getSerializationService();
        Data request = serializationService.toData(obj);
        conn.write(request);
        Data response = conn.read();
        return (T)serializationService.toObject(response);
    }

    private SerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    private ClientConnectionManager getConnectionManager() {
        return this.client.getConnectionManager();
    }

    private Connection getRandomConnection() throws IOException {
        return this.getConnection(null);
    }

    private Connection getConnection(Address address) throws IOException {
        if (!this.client.getLifecycleService().isRunning()) {
            throw new HazelcastInstanceNotActiveException();
        }
        Connection connection = null;
        int retryCount = RETRY_COUNT;
        while (connection == null && retryCount > 0) {
            connection = address != null ? this.client.getConnectionManager().getConnection(address) : this.client.getConnectionManager().getRandomConnection();
            if (connection == null) {
                --retryCount;
                try {
                    Thread.sleep(RETRY_WAIT_TIME);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            address = null;
        }
        if (connection == null) {
            throw new HazelcastException("Unable to connect!!!");
        }
        return connection;
    }

    void sendAndHandle(Address address, Object obj, ResponseHandler handler) throws IOException {
        Connection conn = this.getConnection(address);
        this.sendAndHandle(conn, obj, handler);
    }

    void sendAndHandle(Object obj, ResponseHandler handler) throws IOException {
        Connection conn = this.getRandomConnection();
        this.sendAndHandle(conn, obj, handler);
    }

    private void sendAndHandle(Connection conn, Object obj, ResponseHandler handler) throws IOException {
        ResponseStreamImpl stream;
        try {
            SerializationService serializationService = this.getSerializationService();
            Data request = serializationService.toData(obj);
            conn.write(request);
            stream = new ResponseStreamImpl(serializationService, conn);
        }
        catch (IOException e) {
            ((ClientPartitionServiceImpl)this.client.getClientPartitionService()).refreshPartitions();
            if (this.redoOperation || obj instanceof RetryableRequest) {
                this.sendAndHandle(obj, handler);
                return;
            }
            throw new HazelcastException(e);
        }
        try {
            handler.handle(stream);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        finally {
            stream.end();
        }
    }

    public Authenticator getAuthenticator() {
        return new ClusterAuthenticator();
    }

    public String addMembershipListener(MembershipListener listener) {
        String id = UUID.randomUUID().toString();
        this.listeners.put(id, listener);
        return id;
    }

    public boolean removeMembershipListener(String registrationId) {
        return this.listeners.remove(registrationId) != null;
    }

    public void start() {
        Future<Connection> f = this.client.getClientExecutionService().submit(new InitialConnectionCall());
        try {
            Connection connection = f.get(30L, TimeUnit.SECONDS);
            this.clusterThread.setInitialConn(connection);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        this.clusterThread.start();
        while (this.membersRef.get() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new ClientException(e);
            }
        }
    }

    public void stop() {
        this.clusterThread.shutdown();
    }

    private Connection connectToOne(Collection<InetSocketAddress> socketAddresses) throws Exception {
        int connectionAttemptLimit = this.getClientConfig().getConnectionAttemptLimit();
        ManagerAuthenticator authenticator = new ManagerAuthenticator();
        int attempt = 0;
        while (true) {
            long nextTry = Clock.currentTimeMillis() + (long)this.getClientConfig().getConnectionAttemptPeriod();
            for (InetSocketAddress isa : socketAddresses) {
                try {
                    Address address = new Address(isa);
                    return this.getConnectionManager().firstConnection(address, authenticator);
                }
                catch (IOException ignored) {
                }
            }
            if (attempt++ >= connectionAttemptLimit) break;
            long remainingTime = nextTry - Clock.currentTimeMillis();
            System.err.println(String.format("Unable to get alive cluster connection, try in %d ms later, attempt %d of %d.", Math.max(0L, remainingTime), attempt, connectionAttemptLimit));
            if (remainingTime <= 0L) continue;
            try {
                Thread.sleep(remainingTime);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new IllegalStateException("Unable to connect to any address in the config!");
    }

    private Collection<InetSocketAddress> getConfigAddresses() {
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        for (String address : this.getClientConfig().getAddressList()) {
            socketAddresses.addAll(AddressHelper.getSocketAddresses(address));
        }
        Collections.shuffle(socketAddresses);
        return socketAddresses;
    }

    private ClientConfig getClientConfig() {
        return this.client.getClientConfig();
    }

    private Object authenticate(Connection connection, Credentials credentials, ClientPrincipal principal, boolean reAuth, boolean firstConnection) throws IOException {
        AuthenticationRequest auth = new AuthenticationRequest(credentials, principal);
        auth.setReAuth(reAuth);
        auth.setFirstConnection(firstConnection);
        SerializationService serializationService = this.getSerializationService();
        connection.write(serializationService.toData(auth));
        Data addressData = connection.read();
        Address address = (Address)serializationService.toObject(addressData);
        connection.setEndpoint(address);
        Data data = connection.read();
        Object response = serializationService.toObject(data);
        if (response instanceof GenericError) {
            throw new AuthenticationException(((GenericError)response).getMessage());
        }
        return response;
    }

    private class ClusterAuthenticator
    implements Authenticator {
        private ClusterAuthenticator() {
        }

        @Override
        public void auth(Connection connection) throws AuthenticationException, IOException {
            ClientClusterServiceImpl.this.authenticate(connection, ClientClusterServiceImpl.this.credentials, ClientClusterServiceImpl.this.principal, false, false);
        }
    }

    private class ManagerAuthenticator
    implements Authenticator {
        private ManagerAuthenticator() {
        }

        @Override
        public void auth(Connection connection) throws AuthenticationException, IOException {
            Object response = ClientClusterServiceImpl.this.authenticate(connection, ClientClusterServiceImpl.this.credentials, ClientClusterServiceImpl.this.principal, true, true);
            ClientClusterServiceImpl.this.principal = (ClientPrincipal)response;
        }
    }

    private class ClusterListenerThread
    extends Thread {
        private volatile Connection conn;
        private final List<MemberImpl> members;

        private ClusterListenerThread(ThreadGroup group, String name) {
            super(group, name);
            this.members = new LinkedList<MemberImpl>();
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (this.conn == null) {
                        try {
                            this.conn = this.pickConnection();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ClientClusterServiceImpl.this.client.getLifecycleService().shutdown();
                            return;
                        }
                    }
                    this.loadInitialMemberList();
                    this.listenMembershipEvents();
                }
                catch (Exception e) {
                    if (ClientClusterServiceImpl.this.client.getLifecycleService().isRunning()) {
                        e.printStackTrace();
                    }
                    IOUtil.closeResource(this.conn);
                    this.conn = null;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        private Connection pickConnection() throws Exception {
            HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
            if (!this.members.isEmpty()) {
                addresses.addAll(this.getClusterAddresses());
            }
            addresses.addAll(ClientClusterServiceImpl.this.getConfigAddresses());
            return ClientClusterServiceImpl.this.connectToOne(addresses);
        }

        private void loadInitialMemberList() throws IOException {
            SerializableCollection coll = (SerializableCollection)ClientClusterServiceImpl.this.sendAndReceive(this.conn, new AddMembershipListenerRequest());
            SerializationService serializationService = ClientClusterServiceImpl.this.getSerializationService();
            Map<String, MemberImpl> prevMembers = Collections.emptyMap();
            if (!this.members.isEmpty()) {
                prevMembers = new HashMap(this.members.size());
                for (MemberImpl member : this.members) {
                    prevMembers.put(member.getUuid(), member);
                }
                this.members.clear();
            }
            for (Data d : coll.getCollection()) {
                this.members.add((MemberImpl)serializationService.toObject(d));
            }
            this.updateMembersRef();
            LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
            for (MemberImpl member : this.members) {
                MemberImpl former = (MemberImpl)prevMembers.remove(member.getUuid());
                if (former != null) continue;
                events.add(new MembershipEvent(member, 1));
            }
            for (MemberImpl member : prevMembers.values()) {
                events.add(new MembershipEvent(member, 3));
            }
            for (MembershipEvent event : events) {
                this.fireMembershipEvent(event);
            }
        }

        private void listenMembershipEvents() throws IOException {
            SerializationService serializationService = ClientClusterServiceImpl.this.getSerializationService();
            while (!Thread.currentThread().isInterrupted()) {
                Data eventData = this.conn.read();
                ClientMembershipEvent event = (ClientMembershipEvent)serializationService.toObject(eventData);
                MemberImpl member = (MemberImpl)event.getMember();
                if (event.getEventType() == 1) {
                    this.members.add(member);
                } else {
                    this.members.remove(member);
                    ClientClusterServiceImpl.this.getConnectionManager().removeConnectionPool(member.getAddress());
                }
                this.updateMembersRef();
                this.fireMembershipEvent(event);
            }
        }

        private void fireMembershipEvent(final MembershipEvent event) {
            ClientClusterServiceImpl.this.client.getClientExecutionService().execute(new Runnable(){

                @Override
                public void run() {
                    for (MembershipListener listener : ClientClusterServiceImpl.this.listeners.values()) {
                        if (event.getEventType() == 1) {
                            listener.memberAdded(event);
                            continue;
                        }
                        listener.memberRemoved(event);
                    }
                }
            });
        }

        private void updateMembersRef() {
            LinkedHashMap<Address, MemberImpl> map = new LinkedHashMap<Address, MemberImpl>(this.members.size());
            for (MemberImpl member : this.members) {
                map.put(member.getAddress(), member);
            }
            ClientClusterServiceImpl.this.membersRef.set(Collections.unmodifiableMap(map));
        }

        private Collection<InetSocketAddress> getClusterAddresses() {
            LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
            for (MemberImpl member : this.members) {
                socketAddresses.add(member.getInetSocketAddress());
            }
            Collections.shuffle(socketAddresses);
            return socketAddresses;
        }

        void setInitialConn(Connection conn) {
            this.conn = conn;
        }

        void shutdown() {
            this.interrupt();
            Connection c = this.conn;
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class InitialConnectionCall
    implements Callable<Connection> {
        private InitialConnectionCall() {
        }

        @Override
        public Connection call() throws Exception {
            return ClientClusterServiceImpl.this.connectToOne(ClientClusterServiceImpl.this.getConfigAddresses());
        }
    }
}

