/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientType;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.TcpIpConnection;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import java.net.SocketAddress;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class ClientEndpoint
implements Client {
    private final Connection conn;
    private String uuid;
    private LoginContext loginContext = null;
    private ClientPrincipal principal;
    private TransactionContext transactionContext;
    private boolean firstConnection = false;
    private volatile boolean authenticated = false;

    ClientEndpoint(Connection conn, String uuid) {
        this.conn = conn;
        this.uuid = uuid;
    }

    Connection getConnection() {
        return this.conn;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public boolean live() {
        return this.conn.live();
    }

    void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    Subject getSubject() {
        return this.loginContext != null ? this.loginContext.getSubject() : null;
    }

    public boolean isFirstConnection() {
        return this.firstConnection;
    }

    void authenticated(ClientPrincipal principal, boolean firstConnection) {
        this.principal = principal;
        this.uuid = principal.getUuid();
        this.firstConnection = firstConnection;
        this.authenticated = true;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    @Override
    public SocketAddress getSocketAddress() {
        if (this.conn instanceof TcpIpConnection) {
            ((TcpIpConnection)this.conn).getSocketChannelWrapper().socket().getRemoteSocketAddress();
        }
        return null;
    }

    @Override
    public ClientType getClientType() {
        return ClientType.Native;
    }

    public TransactionContext getTransactionContext() {
        if (this.transactionContext == null) {
            throw new TransactionException("No transaction context!!!");
        }
        return this.transactionContext;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    void destroy() throws LoginException {
        TransactionContext context;
        LoginContext lc = this.loginContext;
        if (lc != null) {
            lc.logout();
        }
        if ((context = this.transactionContext) != null) {
            try {
                context.rollbackTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.transactionContext = null;
        }
        this.authenticated = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientEndpoint{");
        sb.append("conn=").append(this.conn);
        sb.append(", uuid='").append(this.uuid).append('\'');
        sb.append(", firstConnection=").append(this.firstConnection);
        sb.append(", authenticated=").append(this.authenticated);
        sb.append('}');
        return sb.toString();
    }
}

