/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRecordEntry
implements DataSerializable,
MapEntry {
    private long cost = 0L;
    private long expirationTime = 0L;
    private long lastAccessTime = 0L;
    private long lastUpdateTime = 0L;
    private long creationTime = 0L;
    private long version = 0L;
    private int hits = 0;
    private boolean valid = true;
    private boolean dirty = false;
    private String name = null;
    private Data keyData = null;
    private Data valueData = null;
    private Long[] indexes;
    private byte[] indexTypes;
    private Object key = null;
    private Object value = null;
    private long lastStoredTime;
    private Address lockAddress = null;
    private int lockThreadId = -1;
    private long remainingIdle = Long.MAX_VALUE;
    Map<Address, Boolean> mapListeners = null;

    public DataRecordEntry() {
    }

    public DataRecordEntry(Record record) {
        this(record, record.getValueData(), false);
    }

    public DataRecordEntry(Record record, boolean includeListeners) {
        this(record, record.getValueData(), includeListeners);
    }

    public DataRecordEntry(Record record, Data value, boolean includeListeners) {
        Map<Address, Boolean> existing;
        this.cost = record.getCost();
        this.remainingIdle = record.getRemainingIdle();
        this.expirationTime = record.getExpirationTime();
        this.lastAccessTime = record.getLastAccessTime();
        this.lastUpdateTime = record.getLastUpdateTime();
        this.creationTime = record.getCreationTime();
        this.lastStoredTime = record.getLastStoredTime();
        this.version = record.getVersion();
        this.hits = record.getHits();
        this.valid = record.isValid();
        this.dirty = record.isDirty();
        this.name = record.getName();
        this.keyData = record.getKeyData();
        this.valueData = value;
        this.indexes = record.getIndexes();
        this.indexTypes = record.getIndexTypes();
        DistributedLock lock = record.getLock();
        if (lock != null && lock.getLockCount() > 0) {
            this.lockAddress = lock.getLockAddress();
            this.lockThreadId = lock.getLockThreadId();
        }
        if (includeListeners && (existing = record.getListeners()) != null) {
            this.mapListeners = Collections.unmodifiableMap(existing);
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        long now = Clock.currentTimeMillis();
        out.writeBoolean(this.valid);
        out.writeBoolean(this.dirty);
        out.writeLong(this.cost);
        out.writeLong(this.remainingIdle);
        out.writeLong(this.expirationTime - now);
        out.writeLong(this.lastAccessTime - now);
        out.writeLong(this.lastUpdateTime - now);
        out.writeLong(this.creationTime - now);
        out.writeLong(this.lastStoredTime - now);
        out.writeLong(this.version);
        out.writeInt(this.hits);
        out.writeUTF(this.name);
        this.keyData.writeData(out);
        boolean valueNull = this.valueData == null;
        out.writeBoolean(valueNull);
        if (!valueNull) {
            this.valueData.writeData(out);
        }
        int indexCount = (byte)(this.indexes == null ? 0 : (byte)this.indexes.length);
        out.write(indexCount);
        for (int i = 0; i < indexCount; i = (int)((byte)(i + 1))) {
            out.writeLong(this.indexes[i]);
            out.write(this.indexTypes[i]);
        }
        out.writeInt(this.lockThreadId);
        boolean hasLockAddress = this.lockAddress != null;
        out.writeBoolean(hasLockAddress);
        if (hasLockAddress) {
            this.lockAddress.writeData(out);
        }
        int listenerCount = this.mapListeners == null ? 0 : this.mapListeners.size();
        out.writeInt(listenerCount);
        if (this.mapListeners != null) {
            for (Map.Entry<Address, Boolean> listenerEntry : this.mapListeners.entrySet()) {
                listenerEntry.getKey().writeData(out);
                out.writeBoolean(listenerEntry.getValue());
            }
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        int listenerCount;
        byte indexCount;
        long now = Clock.currentTimeMillis();
        this.valid = in.readBoolean();
        this.dirty = in.readBoolean();
        this.cost = in.readLong();
        this.remainingIdle = in.readLong();
        this.expirationTime = in.readLong() + now;
        this.lastAccessTime = in.readLong() + now;
        this.lastUpdateTime = in.readLong() + now;
        this.creationTime = in.readLong() + now;
        this.lastStoredTime = in.readLong() + now;
        this.version = in.readLong();
        this.hits = in.readInt();
        this.name = in.readUTF();
        this.keyData = new Data();
        this.keyData.readData(in);
        boolean valueNull = in.readBoolean();
        if (!valueNull) {
            this.valueData = new Data();
            this.valueData.readData(in);
        }
        if ((indexCount = in.readByte()) > 0) {
            this.indexes = new Long[indexCount];
            this.indexTypes = new byte[indexCount];
            for (byte i = 0; i < indexCount; i = (byte)(i + 1)) {
                this.indexes[i] = in.readLong();
                this.indexTypes[i] = in.readByte();
            }
        }
        this.lockThreadId = in.readInt();
        boolean hasLockAddress = in.readBoolean();
        if (hasLockAddress) {
            this.lockAddress = new Address();
            this.lockAddress.readData(in);
        }
        if ((listenerCount = in.readInt()) > 0) {
            this.mapListeners = new HashMap<Address, Boolean>(listenerCount);
            for (int i = 0; i < listenerCount; ++i) {
                Address addressListener = new Address();
                addressListener.readData(in);
                this.mapListeners.put(addressListener, in.readBoolean());
            }
        }
    }

    public long getRemainingIdle() {
        return this.remainingIdle;
    }

    @Override
    public Object setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public Object getKey() {
        if (this.key == null) {
            this.key = IOUtil.toObject(this.keyData);
        }
        return this.key;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getLastStoredTime() {
        return this.lastStoredTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean hasValue() {
        return this.valueData != null || this.value != null;
    }

    @Override
    public Object getValue() {
        if (this.value == null) {
            this.value = IOUtil.toObject(this.valueData);
        }
        return this.value;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public Data getKeyData() {
        return this.keyData;
    }

    public Data getValueData() {
        return this.valueData;
    }

    public Long[] getIndexes() {
        return this.indexes;
    }

    public byte[] getIndexTypes() {
        return this.indexTypes;
    }

    public Address getLockAddress() {
        return this.lockAddress;
    }

    public int getLockThreadId() {
        return this.lockThreadId;
    }

    public Map<Address, Boolean> getListeners() {
        return this.mapListeners;
    }
}

