/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.executor;

import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.logging.ILogger;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ParallelExecutorService {
    private final ExecutorService executorService;
    private final List<ParallelExecutor> lsParallelExecutors = new CopyOnWriteArrayList<ParallelExecutor>();
    private final ILogger logger;

    public ParallelExecutorService(ILogger logger, ExecutorService executorService) {
        this.executorService = executorService;
        this.logger = logger;
    }

    public void shutdown() {
        for (ParallelExecutor parallelExecutor : this.lsParallelExecutors) {
            parallelExecutor.shutdown();
        }
        this.lsParallelExecutors.clear();
    }

    public ParallelExecutor newBlockingParallelExecutor(int concurrencyLevel, int capacity) {
        return this.newBlockingParallelExecutor(concurrencyLevel, capacity, Integer.MAX_VALUE);
    }

    public ParallelExecutor newBlockingParallelExecutor(int concurrencyLevel, int capacity, int timeoutMs) {
        ParallelExecutorImpl p = new ParallelExecutorImpl(concurrencyLevel, capacity, timeoutMs);
        this.lsParallelExecutors.add(p);
        return p;
    }

    public ParallelExecutor newParallelExecutor(int concurrencyLevel) {
        return this.newParallelExecutor(concurrencyLevel, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public ParallelExecutor newParallelExecutor(int concurrencyLevel, int capacity, int timeoutMs) {
        ParallelExecutor parallelExecutor = concurrencyLevel > 0 && concurrencyLevel < Integer.MAX_VALUE ? new ParallelExecutorImpl(concurrencyLevel, capacity, timeoutMs) : new FullyParallelExecutorImpl();
        this.lsParallelExecutors.add(parallelExecutor);
        return parallelExecutor;
    }

    private class ParallelExecutorImpl
    implements ParallelExecutor {
        private final ExecutionSegment[] executionSegments;
        private final AtomicInteger offerIndex = new AtomicInteger();
        private final AtomicInteger activeCount = new AtomicInteger();
        private final int timeoutMs;

        private ParallelExecutorImpl(int concurrencyLevel, int segmentCapacity, int timeoutMs) {
            this.timeoutMs = timeoutMs;
            this.executionSegments = new ExecutionSegment[concurrencyLevel];
            for (int i = 0; i < concurrencyLevel; ++i) {
                this.executionSegments[i] = new ExecutionSegment(segmentCapacity);
            }
        }

        public void execute(Runnable command) {
            int hash = this.offerIndex.incrementAndGet();
            this.execute(command, hash);
        }

        public void execute(Runnable command, int hash) {
            if (command == null) {
                throw new NullPointerException("Runnable is not allowed to be null");
            }
            int index = hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % this.executionSegments.length;
            ExecutionSegment segment = this.executionSegments[index];
            segment.offer(command);
        }

        public void shutdown() {
            for (ExecutionSegment executionSegment : this.executionSegments) {
                executionSegment.shutdown();
            }
        }

        public int getPoolSize() {
            int size = 0;
            for (ExecutionSegment executionSegment : this.executionSegments) {
                size += executionSegment.getPoolSize();
            }
            return size;
        }

        public int getActiveCount() {
            return this.activeCount.get();
        }

        private class ExecutionSegment
        implements Runnable {
            private final BlockingQueue<Runnable> q;
            private final AtomicBoolean active = new AtomicBoolean(false);

            private ExecutionSegment(int capacity) {
                this.q = new LinkedBlockingQueue<Runnable>(capacity);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void offer(Runnable command) {
                long timeoutMs = ParallelExecutorImpl.this.timeoutMs;
                boolean interrupted = false;
                try {
                    while (true) {
                        long startMs = System.currentTimeMillis();
                        try {
                            if (this.q.offer(command, timeoutMs, TimeUnit.MILLISECONDS)) {
                                break;
                            }
                            throw new OperationTimeoutException("Timeout: Could not place task:" + command);
                        }
                        catch (InterruptedException ie) {
                            long durationMs = System.currentTimeMillis() - startMs;
                            timeoutMs -= durationMs;
                            interrupted = true;
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.active.get()) {
                    return;
                }
                if (this.active.compareAndSet(false, true)) {
                    ParallelExecutorService.this.executorService.execute(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block10: {
                    ParallelExecutorImpl.this.activeCount.incrementAndGet();
                    block5: while (true) {
                        while (true) {
                            Runnable command;
                            if ((command = (Runnable)this.q.poll()) == null) {
                                boolean finished;
                                this.active.set(false);
                                if (this.q.peek() == null) {
                                    finished = true;
                                } else {
                                    boolean bl = finished = !this.active.compareAndSet(false, true);
                                }
                                if (!finished) continue;
                                break block10;
                            }
                            try {
                                command.run();
                                continue block5;
                            }
                            catch (Throwable e) {
                                if (!ParallelExecutorService.this.logger.isLoggable(Level.FINEST)) continue;
                                ParallelExecutorService.this.logger.log(Level.FINEST, e.getMessage(), e);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        ParallelExecutorImpl.this.activeCount.decrementAndGet();
                    }
                }
            }

            private void shutdown() {
                Runnable r = (Runnable)this.q.poll();
                while (r != null) {
                    r = (Runnable)this.q.poll();
                }
            }

            private int getPoolSize() {
                return this.active.get() ? 1 : 0;
            }
        }
    }

    class FullyParallelExecutorImpl
    implements ParallelExecutor {
        FullyParallelExecutorImpl() {
        }

        public void execute(Runnable command) {
            ParallelExecutorService.this.executorService.execute(command);
        }

        public void execute(Runnable command, int hash) {
            ParallelExecutorService.this.executorService.execute(command);
        }

        public void shutdown() {
        }

        public int getPoolSize() {
            return 0;
        }

        public int getActiveCount() {
            return 0;
        }
    }
}

