/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.hibernate.access.AbstractAccessDelegate;
import com.hazelcast.hibernate.region.HazelcastRegion;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteAccessDelegate<T extends HazelcastRegion>
extends AbstractAccessDelegate<T> {
    public ReadWriteAccessDelegate(T hazelcastRegion, Properties props) {
        super(hazelcastRegion, props);
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return this.put(key, value, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        try {
            boolean bl = this.update(key, value, currentVersion, previousVersion, lock);
            return bl;
        }
        finally {
            this.unlockItem(key, lock);
        }
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.put(key, value, version);
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return this.cache.tryLock(key, version);
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.cache.unlock(key, lock);
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
    }
}

