/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.base.CallStateAware;
import com.hazelcast.impl.base.SystemLog;
import com.hazelcast.impl.base.SystemObjectLog;
import com.hazelcast.nio.Address;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;

public class CallState
implements CallStateAware {
    private volatile long callId;
    private final Address caller;
    private final int callerThreadId;
    private final StateQueue<SystemLog> logQ = new StateQueue(100);

    public CallState(long callId, Address caller, int callerThreadId) {
        this.callId = callId;
        this.caller = caller;
        this.callerThreadId = callerThreadId;
    }

    public CallState getCallState() {
        return this;
    }

    public void reset(long callId) {
        this.callId = callId;
        this.logQ.clear();
    }

    void log(SystemLog log) {
        log.setType(SystemLog.Type.CALL);
        this.logQ.offer(log);
    }

    void logObject(Object obj) {
        this.log(new SystemObjectLog(obj));
    }

    public Address getCaller() {
        return this.caller;
    }

    public int getCallerThreadId() {
        return this.callerThreadId;
    }

    public long getCallId() {
        return this.callId;
    }

    public Object[] getLogs() {
        return this.logQ.copy();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CallState [");
        sb.append(this.callId);
        sb.append("] {");
        sb.append("\n\tcaller: " + this.caller);
        sb.append("\n\tthreadId: " + this.callerThreadId);
        sb.append("\n");
        for (Object log : this.getLogs()) {
            SystemLog systemLog = (SystemLog)log;
            sb.append('\t');
            sb.append(systemLog.getType().toString());
            sb.append(" - ");
            sb.append(new Date(systemLog.getDate()).toString());
            sb.append(" - ");
            sb.append(systemLog.toString());
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StateQueue<E> {
        private final ReentrantLock lock = new ReentrantLock();
        private final int maxSize;
        private final E[] objects;
        int size = 0;

        public StateQueue(int maxSize) {
            this.maxSize = maxSize;
            this.objects = new Object[maxSize];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(E obj) {
            ReentrantLock lock;
            block3: {
                lock = this.lock;
                lock.lock();
                try {
                    if (this.size < this.maxSize) break block3;
                    boolean bl = false;
                    Object var5_5 = null;
                    lock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    lock.unlock();
                    throw throwable;
                }
            }
            this.objects[this.size] = obj;
            ++this.size;
            boolean bl = true;
            Object var5_6 = null;
            lock.unlock();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.size = 0;
                Object var3_2 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] copy() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                Object[] copy = new Object[this.size];
                System.arraycopy(this.objects, 0, copy, 0, this.size);
                Object[] objectArray = copy;
                Object var5_4 = null;
                lock.unlock();
                return objectArray;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }
}

