/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncClientCall<V>
implements Future<V> {
    protected static final Object NULL = new Object();
    protected Object result = null;
    protected final Call remoteCall;
    protected boolean cancelled = false;

    public AsyncClientCall(Call remoteCall) {
        this.remoteCall = remoteCall;
    }

    public void setResult(Object obj) {
        this.result = obj == null ? NULL : obj;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.cancelled || this.result != null;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object response;
        if (this.isDone()) {
            return this.getResult();
        }
        try {
            response = this.remoteCall.getResponse(timeout, unit);
        }
        catch (RuntimeException e) {
            response = e.getCause();
        }
        this.processResult(response);
        return this.getResult();
    }

    void processResult(Object result) throws InterruptedException, ExecutionException, TimeoutException {
        if (result == null) {
            throw new TimeoutException();
        }
        if (result instanceof Throwable) {
            if (result instanceof InterruptedException) {
                throw (InterruptedException)result;
            }
            if (result instanceof ExecutionException) {
                throw (ExecutionException)result;
            }
            if (result instanceof TimeoutException) {
                throw (TimeoutException)result;
            }
            throw new ExecutionException((Throwable)result);
        }
        if (result instanceof Packet) {
            this.setResult(ProxyHelper.getValue((Packet)result));
        } else {
            this.setResult(result);
        }
    }

    private V getResult() throws ExecutionException {
        if (this.result == NULL) {
            return null;
        }
        if (this.result instanceof Throwable) {
            throw new ExecutionException((Throwable)this.result);
        }
        return (V)this.result;
    }
}

