/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEntry;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.region.HazelcastRegion;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.CacheException;

abstract class AbstractHazelcastRegion
implements HazelcastRegion {
    private final HazelcastInstance instance;
    private final IMap cache;
    private final String regionName;
    private final int timeout;
    protected final Properties props;

    protected AbstractHazelcastRegion(HazelcastInstance instance, String regionName, Properties props) {
        this.instance = instance;
        this.cache = instance.getMap(regionName);
        this.regionName = regionName;
        this.timeout = HazelcastTimestamper.getTimeout(instance, regionName);
        this.props = props;
    }

    public final IMap getCache() {
        return this.cache;
    }

    public final void clearCache() {
        this.cache.destroy();
        this.instance.getMap(this.regionName);
    }

    public void destroy() throws CacheException {
    }

    public long getElementCountInMemory() {
        return this.getCache().size();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public String getName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        long size = 0L;
        for (Object key : this.getCache().keySet()) {
            MapEntry entry = this.getCache().getMapEntry(key);
            if (entry == null) continue;
            size += entry.getCost();
        }
        return size;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public Map toMap() {
        return this.getCache();
    }

    public boolean contains(Object key) {
        return this.getCache().containsKey(key);
    }

    public final HazelcastInstance getInstance() {
        return this.instance;
    }
}

