/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.context;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.spring.context.SpringAware;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringManagedContext
implements ManagedContext,
ApplicationContextAware {
    private final AtomicInteger idGen = new AtomicInteger();
    private AutowireCapableBeanFactory beanFactory;

    public void initialize(Object obj) {
        Class<?> clazz;
        if (obj != null && (clazz = obj.getClass()).isAnnotationPresent(SpringAware.class)) {
            String name = clazz.getName() + "#" + this.idGen.incrementAndGet();
            this.beanFactory.autowireBean(obj);
            this.beanFactory.initializeBean(obj, name);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext.getAutowireCapableBeanFactory();
    }
}

