/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.cluster.RemotelyProcessable;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.MultiTask;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.AtomicNumberProxy;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClientDistributedTask;
import com.hazelcast.impl.ClientEndpoint;
import com.hazelcast.impl.ClientRequestHandler;
import com.hazelcast.impl.ClientServiceException;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.CountDownLatchProxy;
import com.hazelcast.impl.DataAwareItemEvent;
import com.hazelcast.impl.DataMessage;
import com.hazelcast.impl.Entries;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.ListProxyImpl;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MultiMapProxy;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.SetProxy;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.util.DistributedTimeoutException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class ClientHandlerService
implements ConnectionListener {
    private final Node node;
    private final Map<Connection, ClientEndpoint> mapClientEndpoints = new ConcurrentHashMap<Connection, ClientEndpoint>();
    private final ClientOperationHandler[] clientOperationHandlers = new ClientOperationHandler[500];
    private final ClientOperationHandler unknownOperationHandler = new UnknownClientOperationHandler();
    private final ILogger logger;
    private final int THREAD_COUNT;
    final Worker[] workers;
    private final FactoryImpl factory;
    boolean firstCall = true;

    public ClientHandlerService(Node node) {
        this.node = node;
        this.logger = node.getLogger(this.getClass().getName());
        node.getClusterImpl().addMembershipListener(new ClientServiceMembershipListener());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_PUT.getValue(), new MapPutHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_PUT.getValue(), new MapPutHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK.getValue(), new MapPutAndUnlockHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_PUT_ALL.getValue(), new MapPutAllHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_PUT_MULTI.getValue(), new MapPutMultiHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT.getValue(), new MapPutIfAbsentHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_PUT_TRANSIENT.getValue(), new MapPutTransientHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_SET.getValue(), new MapSetHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_TRY_PUT.getValue(), new MapTryPutHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_GET.getValue(), new MapGetHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_GET_ALL.getValue(), new MapGetAllHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_REMOVE.getValue(), new MapRemoveHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_TRY_REMOVE.getValue(), new MapTryRemoveHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME.getValue(), new MapRemoveIfSameHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI.getValue(), new MapRemoveMultiHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_EVICT.getValue(), new MapEvictHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_FLUSH.getValue(), new MapFlushHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL.getValue(), new MapReplaceIfNotNullHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME.getValue(), new MapReplaceIfSameHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_SIZE.getValue(), new MapSizeHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY.getValue(), new GetMapEntryHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET.getValue(), new MapTryLockAndGetHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_LOCK.getValue(), new MapLockHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_UNLOCK.getValue(), new MapUnlockHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_FORCE_UNLOCK.getValue(), new MapForceUnlockHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_LOCK_MAP.getValue(), new MapLockMapHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP.getValue(), new MapUnlockMapHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_CONTAINS_KEY.getValue(), new MapContainsHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE.getValue(), new MapContainsValueHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_ADD_TO_LIST.getValue(), new ListAddHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_ADD_TO_SET.getValue(), new SetAddHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_REMOVE_ITEM.getValue(), new MapItemRemoveHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS.getValue(), new MapIterateKeysHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES.getValue(), new MapIterateEntriesHandler());
        this.registerHandler(ClusterOperation.CONCURRENT_MAP_VALUE_COUNT.getValue(), new MapValueCountHandler());
        this.registerHandler(ClusterOperation.TOPIC_PUBLISH.getValue(), new TopicPublishHandler());
        this.registerHandler(ClusterOperation.BLOCKING_QUEUE_OFFER.getValue(), new QueueOfferHandler());
        this.registerHandler(ClusterOperation.BLOCKING_QUEUE_POLL.getValue(), new QueuePollHandler());
        this.registerHandler(ClusterOperation.BLOCKING_QUEUE_REMOVE.getValue(), new QueueRemoveHandler());
        this.registerHandler(ClusterOperation.BLOCKING_QUEUE_PEEK.getValue(), new QueuePeekHandler());
        this.registerHandler(ClusterOperation.BLOCKING_QUEUE_SIZE.getValue(), new QueueSizeHandler());
        this.registerHandler(ClusterOperation.BLOCKING_QUEUE_REMAINING_CAPACITY.getValue(), new QueueRemainingCapacityHandler());
        this.registerHandler(ClusterOperation.BLOCKING_QUEUE_ENTRIES.getValue(), new QueueEntriesHandler());
        this.registerHandler(ClusterOperation.TRANSACTION_BEGIN.getValue(), new TransactionBeginHandler());
        this.registerHandler(ClusterOperation.TRANSACTION_COMMIT.getValue(), new TransactionCommitHandler());
        this.registerHandler(ClusterOperation.TRANSACTION_ROLLBACK.getValue(), new TransactionRollbackHandler());
        this.registerHandler(ClusterOperation.ADD_LISTENER.getValue(), new AddListenerHandler());
        this.registerHandler(ClusterOperation.REMOVE_LISTENER.getValue(), new RemoveListenerHandler());
        this.registerHandler(ClusterOperation.REMOTELY_PROCESS.getValue(), new RemotelyProcessHandler());
        this.registerHandler(ClusterOperation.DESTROY.getValue(), new DestroyHandler());
        this.registerHandler(ClusterOperation.GET_ID.getValue(), new GetIdHandler());
        this.registerHandler(ClusterOperation.ADD_INDEX.getValue(), new AddIndexHandler());
        this.registerHandler(ClusterOperation.NEW_ID.getValue(), new NewIdHandler());
        this.registerHandler(ClusterOperation.EXECUTE.getValue(), new ExecutorServiceHandler());
        this.registerHandler(ClusterOperation.CANCEL_EXECUTION.getValue(), new CancelExecutionHandler());
        this.registerHandler(ClusterOperation.GET_INSTANCES.getValue(), new GetInstancesHandler());
        this.registerHandler(ClusterOperation.GET_MEMBERS.getValue(), new GetMembersHandler());
        this.registerHandler(ClusterOperation.GET_CLUSTER_TIME.getValue(), new GetClusterTimeHandler());
        this.registerHandler(ClusterOperation.CLIENT_AUTHENTICATE.getValue(), new ClientAuthenticateHandler());
        this.registerHandler(ClusterOperation.CLIENT_ADD_INSTANCE_LISTENER.getValue(), new ClientAddInstanceListenerHandler());
        this.registerHandler(ClusterOperation.CLIENT_GET_PARTITIONS.getValue(), new GetPartitionsHandler());
        this.registerHandler(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET.getValue(), new AtomicLongAddAndGetHandler());
        this.registerHandler(ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET.getValue(), new AtomicLongCompareAndSetHandler());
        this.registerHandler(ClusterOperation.ATOMIC_NUMBER_GET_AND_SET.getValue(), new AtomicLongGetAndSetHandler());
        this.registerHandler(ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD.getValue(), new AtomicLongGetAndAddHandler());
        this.registerHandler(ClusterOperation.COUNT_DOWN_LATCH_AWAIT.getValue(), new CountDownLatchAwaitHandler());
        this.registerHandler(ClusterOperation.COUNT_DOWN_LATCH_COUNT_DOWN.getValue(), new CountDownLatchCountDownHandler());
        this.registerHandler(ClusterOperation.COUNT_DOWN_LATCH_GET_COUNT.getValue(), new CountDownLatchGetCountHandler());
        this.registerHandler(ClusterOperation.COUNT_DOWN_LATCH_GET_OWNER.getValue(), new CountDownLatchGetOwnerHandler());
        this.registerHandler(ClusterOperation.COUNT_DOWN_LATCH_SET_COUNT.getValue(), new CountDownLatchSetCountHandler());
        this.registerHandler(ClusterOperation.SEMAPHORE_ATTACH_DETACH_PERMITS.getValue(), new SemaphoreAttachDetachHandler());
        this.registerHandler(ClusterOperation.SEMAPHORE_CANCEL_ACQUIRE.getValue(), new SemaphoreCancelAcquireHandler());
        this.registerHandler(ClusterOperation.SEMAPHORE_DRAIN_PERMITS.getValue(), new SemaphoreDrainHandler());
        this.registerHandler(ClusterOperation.SEMAPHORE_GET_ATTACHED_PERMITS.getValue(), new SemaphoreGetAttachedHandler());
        this.registerHandler(ClusterOperation.SEMAPHORE_GET_AVAILABLE_PERMITS.getValue(), new SemaphoreGetAvailableHandler());
        this.registerHandler(ClusterOperation.SEMAPHORE_REDUCE_PERMITS.getValue(), new SemaphoreReduceHandler());
        this.registerHandler(ClusterOperation.SEMAPHORE_RELEASE.getValue(), new SemaphoreReleaseHandler());
        this.registerHandler(ClusterOperation.SEMAPHORE_TRY_ACQUIRE.getValue(), new SemaphoreTryAcquireHandler());
        this.registerHandler(ClusterOperation.LOCK_LOCK.getValue(), new LockOperationHandler());
        this.registerHandler(ClusterOperation.LOCK_UNLOCK.getValue(), new UnlockOperationHandler());
        this.registerHandler(ClusterOperation.LOCK_FORCE_UNLOCK.getValue(), new UnlockOperationHandler());
        node.connectionManager.addConnectionListener(this);
        this.THREAD_COUNT = node.getGroupProperties().EXECUTOR_CLIENT_THREAD_COUNT.getInteger();
        this.workers = new Worker[this.THREAD_COUNT];
        for (int i = 0; i < this.THREAD_COUNT; ++i) {
            this.workers[i] = new Worker();
        }
        this.factory = node.factory;
    }

    void registerHandler(short operation, ClientOperationHandler handler) {
        this.clientOperationHandlers[operation] = handler;
    }

    public void handle(Packet packet) {
        if (this.firstCall) {
            String threadNamePrefix = this.node.getThreadPoolNamePrefix("client.service");
            for (int i = 0; i < this.THREAD_COUNT; ++i) {
                Worker worker = this.workers[i];
                new Thread(this.node.threadGroup, worker, threadNamePrefix + i).start();
            }
            this.firstCall = false;
        }
        ClientEndpoint clientEndpoint = this.getClientEndpoint(packet.conn);
        CallContext callContext = clientEndpoint.getCallContext(packet.threadId);
        ClientOperationHandler clientOperationHandler = this.clientOperationHandlers[packet.operation.getValue()];
        if (clientOperationHandler == null) {
            clientOperationHandler = this.unknownOperationHandler;
        }
        if (packet.operation != ClusterOperation.CLIENT_AUTHENTICATE && !clientEndpoint.isAuthenticated()) {
            this.logger.log(Level.SEVERE, "A Client " + packet.conn + " must authenticate before any operation.");
            this.node.clientHandlerService.removeClientEndpoint(packet.conn);
            if (packet.conn != null) {
                packet.conn.close();
            }
            return;
        }
        ClientRequestHandler clientRequestHandler = new ClientRequestHandler(this.node, packet, callContext, clientOperationHandler, clientEndpoint.getSubject());
        clientEndpoint.addRequest(clientRequestHandler);
        if (packet.operation == ClusterOperation.CONCURRENT_MAP_UNLOCK) {
            this.node.executorManager.executeNow(clientRequestHandler);
        } else {
            int hash = this.hash(callContext.getThreadId(), this.THREAD_COUNT);
            this.workers[hash].addWork(clientRequestHandler);
        }
    }

    public void shutdown() {
        this.mapClientEndpoints.clear();
        for (Worker worker : this.workers) {
            worker.stop();
        }
    }

    public void restart() {
        for (List listeners : this.node.listenerManager.namedListeners.values()) {
            for (ListenerManager.ListenerItem listener : listeners) {
                if (!(listener instanceof ClientListener)) continue;
                this.node.listenerManager.removeListener(listener.name, listener, listener.key);
            }
        }
    }

    private int hash(int id, int maxCount) {
        return id == Integer.MIN_VALUE ? 0 : Math.abs(id) % maxCount;
    }

    public int numberOfConnectedClients() {
        return this.mapClientEndpoints.size();
    }

    public ClientEndpoint getClientEndpoint(Connection conn) {
        ClientEndpoint clientEndpoint = this.mapClientEndpoints.get(conn);
        if (clientEndpoint == null) {
            clientEndpoint = new ClientEndpoint(this.node, conn);
            this.mapClientEndpoints.put(conn, clientEndpoint);
        }
        return clientEndpoint;
    }

    public void connectionAdded(Connection connection) {
    }

    public void connectionRemoved(final Connection connection) {
        final ClientEndpoint clientEndpoint = this.removeClientEndpoint(connection);
        if (clientEndpoint != null) {
            this.node.executorManager.executeNow(new FallThroughRunnable(){

                public void doRun() {
                    clientEndpoint.connectionRemoved(connection);
                    if (((ClientHandlerService)ClientHandlerService.this).node.securityContext != null) {
                        try {
                            clientEndpoint.getLoginContext().logout();
                        }
                        catch (LoginException e) {
                            ClientHandlerService.this.logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
            });
        }
    }

    ClientEndpoint removeClientEndpoint(Connection connection) {
        return this.mapClientEndpoints.remove(connection);
    }

    private class ClientServiceMembershipListener
    implements MembershipListener {
        private ClientServiceMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            this.notifyEndPoints(membershipEvent);
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            this.notifyEndPoints(membershipEvent);
        }

        void notifyEndPoints(MembershipEvent membershipEvent) {
            for (ClientEndpoint endpoint : ClientHandlerService.this.mapClientEndpoints.values()) {
                Packet membershipEventPacket = endpoint.createMembershipEventPacket(membershipEvent);
                endpoint.sendPacket(membershipEventPacket);
            }
        }
    }

    private abstract class ClientTransactionOperationHandler
    extends ClientOperationHandler {
        private ClientTransactionOperationHandler() {
        }

        public abstract void processTransactionOp(Transaction var1);

        public void processCall(Node node, Packet packet) {
            Transaction transaction = ClientHandlerService.this.factory.getTransaction();
            this.processTransactionOp(transaction);
        }
    }

    private abstract class ClientCollectionOperationHandler
    extends ClientOperationHandler {
        private ClientCollectionOperationHandler() {
        }

        public abstract void doMapOp(Node var1, Packet var2);

        public abstract void doListOp(Node var1, Packet var2);

        public abstract void doSetOp(Node var1, Packet var2);

        public abstract void doMultiMapOp(Node var1, Packet var2);

        public abstract void doQueueOp(Node var1, Packet var2);

        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.LIST)) {
                this.doListOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.SET)) {
                this.doSetOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                this.doMapOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                this.doMultiMapOp(node, packet);
            } else if (instanceType.equals((Object)Instance.InstanceType.QUEUE)) {
                this.doQueueOp(node, packet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClientQueueOperationHandler
    extends ClientOperationHandler {
        private ClientQueueOperationHandler() {
        }

        public abstract Data processQueueOp(IQueue<Object> var1, Data var2, Data var3);

        @Override
        public void processCall(Node node, Packet packet) {
            IQueue queue = (IQueue)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            Data value = this.processQueueOp(queue, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClientMapOperationHandlerWithTTL
    extends ClientOperationHandler {
        private ClientMapOperationHandlerWithTTL() {
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            long ttl = packet.timeout;
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData(), ttl);
            packet.clearForResponse();
            packet.setValue(value);
        }

        protected abstract Data processMapOp(IMap<Object, Object> var1, Data var2, Data var3, long var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ClientMapOperationHandler
    extends ClientOperationHandler {
        private ClientMapOperationHandler() {
        }

        public abstract Data processMapOp(IMap<Object, Object> var1, Data var2, Data var3);

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    private final class UnknownClientOperationHandler
    extends ClientOperationHandler {
        private UnknownClientOperationHandler() {
        }

        public void processCall(Node node, Packet packet) {
            String error = "Unknown Client Operation, can not handle " + (Object)((Object)packet.operation);
            if (node.isActive()) {
                throw new RuntimeException(error);
            }
            ClientHandlerService.this.logger.log(Level.WARNING, error);
        }
    }

    public abstract class ClientOperationHandler {
        public abstract void processCall(Node var1, Packet var2);

        public void handle(Node node, Packet packet) {
            try {
                this.processCall(node, packet);
            }
            catch (RuntimeException e) {
                ClientHandlerService.this.logger.log(Level.WARNING, "exception during handling " + (Object)((Object)packet.operation) + ": " + e.getMessage(), e);
                packet.clearForResponse();
                packet.setValue(IOUtil.toData(new ClientServiceException(e)));
            }
            this.sendResponse(packet);
        }

        protected void sendResponse(Packet request) {
            request.lockAddress = null;
            request.operation = ClusterOperation.RESPONSE;
            request.responseType = (byte)3;
            if (request.conn != null && request.conn.live()) {
                request.conn.getWriteHandler().enqueueSocketWritable(request);
            } else {
                ClientHandlerService.this.logger.log(Level.WARNING, "unable to send response " + request);
            }
        }
    }

    private class MapItemRemoveHandler
    extends ClientOperationHandler {
        private MapItemRemoveHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Collection collection = (Collection)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            Data value = IOUtil.toData(collection.remove(packet.getKeyData()));
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    private class SetAddHandler
    extends ClientOperationHandler {
        private SetAddHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ISet list = (ISet)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            boolean value = list.add(packet.getKeyData());
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(value));
        }
    }

    private class ListAddHandler
    extends ClientOperationHandler {
        private ListAddHandler() {
        }

        public void processCall(Node node, Packet packet) {
            IList list = (IList)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            Boolean value = list.add(packet.getKeyData());
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(value));
        }
    }

    private class RemoveListenerHandler
    extends ClientOperationHandler {
        private RemoveListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClientEndpoint clientEndpoint = ClientHandlerService.this.getClientEndpoint(packet.conn);
            if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                clientEndpoint.removeThisListener(map, packet.getKeyData());
            }
            if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.MULTIMAP)) {
                MultiMap multiMap = (MultiMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                clientEndpoint.removeThisListener(multiMap, packet.getKeyData());
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.TOPIC)) {
                ITopic topic = (ITopic)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                topic.removeMessageListener(clientEndpoint.messageListeners.remove(topic));
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.QUEUE)) {
                IQueue queue = (IQueue)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                queue.removeItemListener(clientEndpoint.queueItemListeners.remove(queue));
            }
        }
    }

    public class ClientMessageListener
    implements MessageListener,
    ClientListener {
        final ClientEndpoint clientEndpoint;
        final String name;

        ClientMessageListener(ClientEndpoint clientEndpoint, String name) {
            this.clientEndpoint = clientEndpoint;
            this.name = name;
        }

        public void onMessage(Message msg) {
            Packet p = new Packet();
            DataMessage dataMessage = (DataMessage)msg;
            p.set(this.name, ClusterOperation.EVENT, dataMessage.getMessageData(), null);
            this.clientEndpoint.sendPacket(p);
        }
    }

    public class ClientItemListener
    implements ItemListener,
    ClientListener {
        final ClientEndpoint clientEndpoint;
        final String name;

        ClientItemListener(ClientEndpoint clientEndpoint, String name) {
            this.clientEndpoint = clientEndpoint;
            this.name = name;
        }

        public void itemAdded(ItemEvent itemEvent) {
            Packet p = new Packet();
            DataAwareItemEvent dataAwareItemEvent = (DataAwareItemEvent)itemEvent;
            p.set(this.name, ClusterOperation.EVENT, dataAwareItemEvent.getItemData(), true);
            this.clientEndpoint.sendPacket(p);
        }

        public void itemRemoved(ItemEvent itemEvent) {
            Packet p = new Packet();
            DataAwareItemEvent dataAwareItemEvent = (DataAwareItemEvent)itemEvent;
            p.set(this.name, ClusterOperation.EVENT, dataAwareItemEvent.getItemData(), false);
            this.clientEndpoint.sendPacket(p);
        }
    }

    public static interface ClientListener {
    }

    private class AddListenerHandler
    extends ClientOperationHandler {
        private AddListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            boolean includeValue;
            ClientEndpoint clientEndpoint = ClientHandlerService.this.getClientEndpoint(packet.conn);
            boolean bl = includeValue = (int)packet.longValue == 1;
            if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                clientEndpoint.addThisAsListener(map, packet.getKeyData(), includeValue);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.MULTIMAP)) {
                MultiMap multiMap = (MultiMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                clientEndpoint.addThisAsListener(multiMap, packet.getKeyData(), includeValue);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.LIST)) {
                ListProxyImpl listProxy = (ListProxyImpl)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName("c:" + (String)listProxy.getId());
                clientEndpoint.addThisAsListener(map, null, true);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.SET)) {
                SetProxy collectionProxy = (SetProxy)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                MProxy map = collectionProxy.getMProxy();
                clientEndpoint.addThisAsListener(map, null, includeValue);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.QUEUE)) {
                IQueue queue = (IQueue)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                String packetName = packet.name;
                ClientItemListener itemListener = new ClientItemListener(clientEndpoint, packetName);
                queue.addItemListener(itemListener, includeValue);
                clientEndpoint.queueItemListeners.put(queue, itemListener);
            } else if (BaseManager.getInstanceType(packet.name).equals((Object)Instance.InstanceType.TOPIC)) {
                ITopic topic = (ITopic)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                String packetName = packet.name;
                ClientMessageListener messageListener = new ClientMessageListener(clientEndpoint, packetName);
                topic.addMessageListener(messageListener);
                clientEndpoint.messageListeners.put(topic, messageListener);
            }
            packet.clearForResponse();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapIterateKeysHandler
    extends ClientCollectionOperationHandler {
        private MapIterateKeysHandler() {
        }

        public Data getMapKeys(IMap<Object, Object> map, Data key, Data value, Collection<Data> collection) {
            Entries entries = null;
            if (value == null) {
                entries = (Entries)map.keySet();
            } else {
                Predicate p = (Predicate)IOUtil.toObject(value);
                entries = (Entries)map.keySet(p);
            }
            Collection<Map.Entry> colEntries = entries.getKeyValues();
            Keys keys = new Keys(collection);
            for (Map.Entry obj : colEntries) {
                KeyValue entry = (KeyValue)obj;
                keys.add(entry.getKeyData());
            }
            return IOUtil.toData(keys);
        }

        @Override
        public void doListOp(Node node, Packet packet) {
            IMap mapProxy = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName("c:q:" + packet.name);
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData(), new ArrayList<Data>()));
        }

        @Override
        public void doMapOp(Node node, Packet packet) {
            packet.setValue(this.getMapKeys((IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name), packet.getKeyData(), packet.getValueData(), new HashSet<Data>()));
        }

        @Override
        public void doSetOp(Node node, Packet packet) {
            SetProxy collectionProxy = (SetProxy)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = collectionProxy.getMProxy();
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData(), new HashSet<Data>()));
        }

        @Override
        public void doMultiMapOp(Node node, Packet packet) {
            MultiMapProxy multiMap = (MultiMapProxy)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = multiMap.getMProxy();
            Data value = this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData(), new HashSet<Data>());
            packet.clearForResponse();
            packet.setValue(value);
        }

        @Override
        public void doQueueOp(Node node, Packet packet) {
            IQueue queue = (IQueue)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapIterateEntriesHandler
    extends ClientCollectionOperationHandler {
        private MapIterateEntriesHandler() {
        }

        public Data getMapKeys(IMap<Object, Object> map, Data key, Data value) {
            Entries entries = null;
            if (value == null) {
                entries = (Entries)map.entrySet();
            } else {
                Predicate p = (Predicate)IOUtil.toObject(value);
                entries = (Entries)map.entrySet(p);
            }
            Collection<Map.Entry> colEntries = entries.getKeyValues();
            Keys keys = new Keys(new ArrayList<Data>(colEntries.size() << 1));
            for (Map.Entry obj : colEntries) {
                KeyValue entry = (KeyValue)obj;
                keys.add(IOUtil.toData(entry));
            }
            return IOUtil.toData(keys);
        }

        @Override
        public void doListOp(Node node, Packet packet) {
            IMap mapProxy = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName("c:q:" + packet.name);
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData()));
        }

        @Override
        public void doMapOp(Node node, Packet packet) {
            packet.setValue(this.getMapKeys((IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name), packet.getKeyData(), packet.getValueData()));
        }

        @Override
        public void doSetOp(Node node, Packet packet) {
            SetProxy collectionProxy = (SetProxy)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = collectionProxy.getMProxy();
            packet.setValue(this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData()));
        }

        @Override
        public void doMultiMapOp(Node node, Packet packet) {
            MultiMapProxy multiMap = (MultiMapProxy)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            MProxy mapProxy = multiMap.getMProxy();
            Data value = this.getMapKeys(mapProxy, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }

        @Override
        public void doQueueOp(Node node, Packet packet) {
            IQueue queue = (IQueue)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
        }
    }

    private class TransactionRollbackHandler
    extends ClientTransactionOperationHandler {
        private TransactionRollbackHandler() {
        }

        public void processTransactionOp(Transaction transaction) {
            transaction.rollback();
        }
    }

    private class TransactionCommitHandler
    extends ClientTransactionOperationHandler {
        private TransactionCommitHandler() {
        }

        public void processTransactionOp(Transaction transaction) {
            transaction.commit();
        }
    }

    private class TransactionBeginHandler
    extends ClientTransactionOperationHandler {
        private TransactionBeginHandler() {
        }

        public void processTransactionOp(Transaction transaction) {
            transaction.begin();
        }
    }

    private class UnlockOperationHandler
    extends ClientOperationHandler {
        private UnlockOperationHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Object key = IOUtil.toObject(packet.getKeyData());
            ILock lock = ClientHandlerService.this.factory.getLock(key);
            if (packet.operation == ClusterOperation.LOCK_UNLOCK) {
                lock.unlock();
            } else if (packet.operation == ClusterOperation.LOCK_FORCE_UNLOCK) {
                lock.forceUnlock();
            }
            packet.clearForResponse();
            packet.setValue(null);
        }
    }

    private class LockOperationHandler
    extends ClientOperationHandler {
        private LockOperationHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Object key = IOUtil.toObject(packet.getKeyData());
            ILock lock = ClientHandlerService.this.factory.getLock(key);
            long timeout = packet.timeout;
            Data value = null;
            if (timeout == -1L) {
                lock.lock();
            } else if (timeout == 0L) {
                value = IOUtil.toData(lock.tryLock());
            } else {
                try {
                    value = IOUtil.toData(lock.tryLock(timeout, TimeUnit.MILLISECONDS));
                }
                catch (InterruptedException e) {
                    ClientHandlerService.this.logger.log(Level.FINEST, "Lock interrupted!");
                    value = IOUtil.toData(Boolean.FALSE);
                }
            }
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapUnlockMapHandler
    extends ClientMapOperationHandler {
        private MapUnlockMapHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.unlockMap();
            return null;
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapLockMapHandler
    extends ClientMapOperationHandler {
        private MapLockMapHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            throw new RuntimeException("Shouldn't invoke this method");
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            long timeout = packet.timeout;
            TimeUnit timeUnit = (TimeUnit)((Object)IOUtil.toObject(packet.getValueData()));
            timeUnit = timeUnit == null ? TimeUnit.MILLISECONDS : timeUnit;
            Data value = IOUtil.toData(map.lockMap(timeout, timeUnit));
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapUnlockHandler
    extends ClientMapOperationHandler {
        private MapUnlockHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.unlock(key);
            return null;
        }

        @Override
        public void processCall(Node node, Packet packet) {
            Instance.InstanceType type = BaseManager.getInstanceType(packet.name);
            IMap map = null;
            if (type == Instance.InstanceType.MAP) {
                map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            } else {
                MultiMapProxy multiMapProxy = (MultiMapProxy)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                map = multiMapProxy.getMProxy();
            }
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData());
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapForceUnlockHandler
    extends MapUnlockHandler {
        private MapForceUnlockHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.forceUnlock(key);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapLockHandler
    extends ClientMapOperationHandler {
        private MapLockHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            throw new RuntimeException("Shouldn't invoke this method");
        }

        @Override
        public void processCall(Node node, Packet packet) {
            Instance.InstanceType type = BaseManager.getInstanceType(packet.name);
            long timeout = packet.timeout;
            Data value = null;
            IMap map = null;
            if (type == Instance.InstanceType.MAP) {
                map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            } else {
                MultiMapProxy multiMapProxy = (MultiMapProxy)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                map = multiMapProxy.getMProxy();
            }
            if (timeout == -1L) {
                map.lock(packet.getKeyData());
                value = null;
            } else if (timeout == 0L) {
                value = IOUtil.toData(map.tryLock(packet.getKeyData()));
            } else {
                TimeUnit timeUnit = (TimeUnit)((Object)IOUtil.toObject(packet.getValueData()));
                timeUnit = timeUnit == null ? TimeUnit.MILLISECONDS : timeUnit;
                value = IOUtil.toData(map.tryLock(packet.getKeyData(), timeout, timeUnit));
            }
            packet.setValue(value);
        }
    }

    private class MapSizeHandler
    extends ClientCollectionOperationHandler {
        private MapSizeHandler() {
        }

        public void doListOp(Node node, Packet packet) {
            IList list = (IList)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(list.size()));
        }

        public void doMapOp(Node node, Packet packet) {
            IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(map.size()));
        }

        public void doSetOp(Node node, Packet packet) {
            ISet set = (ISet)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(set.size()));
        }

        public void doMultiMapOp(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(multiMap.size()));
        }

        public void doQueueOp(Node node, Packet packet) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapContainsValueHandler
    extends ClientOperationHandler {
        private MapContainsValueHandler() {
        }

        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.containsValue(value));
        }

        @Override
        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(map.containsValue(packet.getValueData())));
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                MultiMap multiMap = (MultiMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                if (packet.getKeyData() != null && packet.getKeyData().size() > 0) {
                    packet.setValue(IOUtil.toData(multiMap.containsEntry(packet.getKeyData(), packet.getValueData())));
                } else {
                    packet.setValue(IOUtil.toData(multiMap.containsValue(packet.getValueData())));
                }
            }
        }
    }

    private class MapContainsHandler
    extends ClientOperationHandler {
        private MapContainsHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            if (instanceType.equals((Object)Instance.InstanceType.MAP)) {
                IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(map.containsKey(packet.getKeyData())));
            } else if (instanceType.equals((Object)Instance.InstanceType.LIST) || instanceType.equals((Object)Instance.InstanceType.SET)) {
                Collection collection = (Collection)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(collection.contains(packet.getKeyData())));
            } else if (instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                MultiMap multiMap = (MultiMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                packet.setValue(IOUtil.toData(multiMap.containsKey(packet.getKeyData())));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapReplaceIfSameHandler
    extends ClientMapOperationHandler {
        private MapReplaceIfSameHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            Keys keys = (Keys)IOUtil.toObject(value);
            Iterator<Data> it = keys.getKeys().iterator();
            Data expected = it.next();
            Data newValue = it.next();
            boolean replaced = map.replace(key, expected, newValue);
            return IOUtil.toData(replaced);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapReplaceIfNotNullHandler
    extends ClientMapOperationHandler {
        private MapReplaceIfNotNullHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return (Data)map.replace(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapFlushHandler
    extends ClientMapOperationHandler {
        private MapFlushHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.flush();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapEvictHandler
    extends ClientMapOperationHandler {
        private MapEvictHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.evict(key));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapRemoveIfSameHandler
    extends ClientMapOperationHandler {
        private MapRemoveIfSameHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.remove(key, value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapRemoveHandler
    extends ClientMapOperationHandler {
        private MapRemoveHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return (Data)map.remove(key);
        }
    }

    private class MapGetHandler
    extends ClientOperationHandler {
        private MapGetHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Instance.InstanceType instanceType = BaseManager.getInstanceType(packet.name);
            Data key = packet.getKeyData();
            if (instanceType == Instance.InstanceType.MAP) {
                IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                packet.setKey(null);
                packet.setValue((Data)map.get(key));
            } else if (instanceType == Instance.InstanceType.MULTIMAP) {
                MultiMapProxy multiMap = (MultiMapProxy)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
                MProxy mapProxy = multiMap.getMProxy();
                packet.setKey(null);
                packet.setValue((Data)mapProxy.get(key));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetMapEntryHandler
    extends ClientMapOperationHandler {
        private GetMapEntryHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.getMapEntry(key));
        }
    }

    private class MapGetAllHandler
    extends ClientOperationHandler {
        private MapGetAllHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Keys keys = (Keys)IOUtil.toObject(packet.getKeyData());
            Pairs pairs = node.concurrentMapManager.getAllPairs(packet.name, keys);
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(pairs));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutIfAbsentHandler
    extends ClientOperationHandler {
        private MapPutIfAbsentHandler() {
        }

        public Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientHandlerService)ClientHandlerService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            if (ttl <= 0L) {
                return (Data)map.putIfAbsent(key, v);
            }
            return (Data)map.putIfAbsent(key, v, ttl, TimeUnit.MILLISECONDS);
        }

        @Override
        public void processCall(Node node, Packet packet) {
            IMap map = (IMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            long ttl = packet.timeout;
            Data value = this.processMapOp(map, packet.getKeyData(), packet.getValueData(), ttl);
            packet.clearForResponse();
            packet.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapTryLockAndGetHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapTryLockAndGetHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            try {
                return IOUtil.toData(map.tryLockAndGet(key, ttl, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
                return IOUtil.toData(new DistributedTimeoutException());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapTryRemoveHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapTryRemoveHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            try {
                return IOUtil.toData(map.tryRemove(key, ttl, TimeUnit.MILLISECONDS));
            }
            catch (TimeoutException e) {
                return IOUtil.toData(new DistributedTimeoutException());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutAndUnlockHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapPutAndUnlockHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientHandlerService)ClientHandlerService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            map.putAndUnlock(key, v);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapTryPutHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapTryPutHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientHandlerService)ClientHandlerService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            return IOUtil.toData(map.tryPut(key, v, ttl, TimeUnit.MILLISECONDS));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapSetHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapSetHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientHandlerService)ClientHandlerService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            map.set(key, v, ttl, TimeUnit.MILLISECONDS);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutTransientHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapPutTransientHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientHandlerService)ClientHandlerService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            map.putTransient(key, v, ttl, TimeUnit.MILLISECONDS);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutHandler
    extends ClientMapOperationHandlerWithTTL {
        private MapPutHandler() {
        }

        @Override
        protected Data processMapOp(IMap<Object, Object> map, Data key, Data value, long ttl) {
            MProxy mproxy = (MProxy)map;
            Object v = value;
            if (((ClientHandlerService)ClientHandlerService.this).node.concurrentMapManager.isMapIndexed(mproxy.getLongName())) {
                v = IOUtil.toObject(value);
            }
            if (ttl <= 0L) {
                return (Data)map.put(key, v);
            }
            return (Data)map.put(key, v, ttl, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapPutAllHandler
    extends ClientMapOperationHandler {
        private MapPutAllHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Data processMapOp(IMap<Object, Object> imap, Data key, Data value) {
            MProxy mproxy = (MProxy)imap;
            Pairs pairs = (Pairs)IOUtil.toObject(value);
            try {
                ((ClientHandlerService)ClientHandlerService.this).node.concurrentMapManager.doPutAll(mproxy.getLongName(), pairs);
            }
            catch (Exception e) {
                ClientHandlerService.this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddIndexHandler
    extends ClientMapOperationHandler {
        private AddIndexHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            map.addIndex((String)IOUtil.toObject(key), (boolean)((Boolean)IOUtil.toObject(value)));
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetIdHandler
    extends ClientMapOperationHandler {
        private GetIdHandler() {
        }

        @Override
        public Data processMapOp(IMap<Object, Object> map, Data key, Data value) {
            return IOUtil.toData(map.getId());
        }
    }

    private class ClientAddInstanceListenerHandler
    extends ClientOperationHandler {
        private ClientAddInstanceListenerHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClientEndpoint endPoint = ClientHandlerService.this.getClientEndpoint(packet.conn);
            ClientHandlerService.this.factory.addInstanceListener(endPoint);
        }
    }

    class ClientAuthenticateHandler
    extends ClientOperationHandler {
        ClientAuthenticateHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Credentials credentials = (Credentials)IOUtil.toObject(packet.getValueData());
            boolean authenticated = false;
            if (credentials == null) {
                authenticated = false;
                ClientHandlerService.this.logger.log(Level.SEVERE, "Could not retrieve Credentials object!");
            } else if (node.securityContext != null) {
                Socket endpointSocket = packet.conn.getSocketChannelWrapper().socket();
                credentials.setEndpoint(endpointSocket.getInetAddress().getHostAddress());
                try {
                    LoginContext lc = node.securityContext.createClientLoginContext(credentials);
                    lc.login();
                    ClientHandlerService.this.getClientEndpoint(packet.conn).setLoginContext(lc);
                    authenticated = true;
                }
                catch (LoginException e) {
                    ClientHandlerService.this.logger.log(Level.WARNING, e.getMessage(), e);
                    authenticated = false;
                }
            } else if (credentials instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
                String nodeGroupName = ClientHandlerService.this.factory.getConfig().getGroupConfig().getName();
                String nodeGroupPassword = ClientHandlerService.this.factory.getConfig().getGroupConfig().getPassword();
                authenticated = nodeGroupName.equals(usernamePasswordCredentials.getUsername()) && nodeGroupPassword.equals(usernamePasswordCredentials.getPassword());
            } else {
                authenticated = false;
                ClientHandlerService.this.logger.log(Level.SEVERE, "Hazelcast security is disabled.\nUsernamePasswordCredentials or cluster group-name and group-password should be used for authentication!\nCurrent credentials type is: " + credentials.getClass().getName());
            }
            ClientHandlerService.this.logger.log(authenticated ? Level.INFO : Level.WARNING, "received auth from " + packet.conn + ", " + (authenticated ? "successfully authenticated" : "authentication failed"));
            packet.clearForResponse();
            packet.setValue(IOUtil.toData(authenticated));
            if (!authenticated) {
                node.clientHandlerService.removeClientEndpoint(packet.conn);
            } else {
                ClientEndpoint clientEndpoint = node.clientHandlerService.getClientEndpoint(packet.conn);
                clientEndpoint.authenticated();
            }
        }
    }

    private class GetClusterTimeHandler
    extends ClientOperationHandler {
        private GetClusterTimeHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClusterImpl cluster = ClientHandlerService.this.factory.getCluster();
            long clusterTime = cluster.getClusterTime();
            packet.setValue(IOUtil.toData(clusterTime));
        }
    }

    public static class PartitionImpl
    implements Partition,
    HazelcastInstanceAware,
    DataSerializable,
    Comparable {
        int partitionId;
        MemberImpl owner;

        PartitionImpl(int partitionId, MemberImpl owner) {
            this.partitionId = partitionId;
            this.owner = owner;
        }

        public PartitionImpl() {
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public Member getOwner() {
            return this.owner;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            if (this.owner != null) {
                this.owner.setHazelcastInstance(hazelcastInstance);
            }
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeInt(this.partitionId);
            boolean hasOwner = this.owner != null;
            out.writeBoolean(hasOwner);
            if (hasOwner) {
                this.owner.writeData(out);
            }
        }

        public void readData(DataInput in) throws IOException {
            this.partitionId = in.readInt();
            boolean hasOwner = in.readBoolean();
            if (hasOwner) {
                this.owner = new MemberImpl();
                this.owner.readData(in);
            }
        }

        public int compareTo(Object o) {
            PartitionImpl partition = (PartitionImpl)o;
            Integer id = this.partitionId;
            return id.compareTo(partition.getPartitionId());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionImpl partition = (PartitionImpl)o;
            return this.partitionId == partition.partitionId;
        }

        public int hashCode() {
            return this.partitionId;
        }

        public String toString() {
            return "Partition [" + this.partitionId + "], owner=" + this.owner;
        }
    }

    private class SemaphoreTryAcquireHandler
    extends SemaphoreClientOperationHandler {
        private SemaphoreTryAcquireHandler() {
        }

        void processCall(Packet packet, SemaphoreProxy semaphoreProxy, Integer permits, boolean attach) {
            try {
                boolean acquired;
                if (attach) {
                    acquired = semaphoreProxy.tryAcquireAttach(permits, packet.timeout, TimeUnit.MILLISECONDS);
                    if (acquired) {
                        ClientHandlerService.this.getClientEndpoint(packet.conn).attachDetachPermits(packet.name, permits);
                    }
                } else {
                    acquired = semaphoreProxy.tryAcquire(permits, packet.timeout, TimeUnit.MILLISECONDS);
                }
                packet.setValue(IOUtil.toData(acquired));
            }
            catch (Throwable e) {
                packet.setValue(IOUtil.toData(new ClientServiceException(e)));
            }
        }
    }

    private class SemaphoreReleaseHandler
    extends SemaphoreClientOperationHandler {
        private SemaphoreReleaseHandler() {
        }

        void processCall(Packet packet, SemaphoreProxy semaphoreProxy, Integer permits, boolean detach) {
            if (detach) {
                semaphoreProxy.releaseDetach(permits);
                ClientHandlerService.this.getClientEndpoint(packet.conn).attachDetachPermits(packet.name, -permits.intValue());
            } else {
                semaphoreProxy.release(permits);
            }
        }
    }

    private class SemaphoreReduceHandler
    extends SemaphoreClientOperationHandler {
        private SemaphoreReduceHandler() {
        }

        void processCall(Packet packet, SemaphoreProxy semaphoreProxy, Integer permits, boolean flag) {
            semaphoreProxy.reducePermits(permits);
        }
    }

    private class SemaphoreDrainHandler
    extends SemaphoreClientOperationHandler {
        private SemaphoreDrainHandler() {
        }

        void processCall(Packet packet, SemaphoreProxy semaphoreProxy, Integer value, boolean flag) {
            packet.setValue(IOUtil.toData(semaphoreProxy.drainPermits()));
        }
    }

    private class SemaphoreGetAvailableHandler
    extends SemaphoreClientOperationHandler {
        private SemaphoreGetAvailableHandler() {
        }

        void processCall(Packet packet, SemaphoreProxy semaphoreProxy, Integer value, boolean flag) {
            packet.setValue(IOUtil.toData(semaphoreProxy.availablePermits()));
        }
    }

    private class SemaphoreGetAttachedHandler
    extends SemaphoreClientOperationHandler {
        private SemaphoreGetAttachedHandler() {
        }

        void processCall(Packet packet, SemaphoreProxy semaphoreProxy, Integer value, boolean flag) {
            packet.setValue(IOUtil.toData(semaphoreProxy.attachedPermits()));
        }
    }

    private class SemaphoreCancelAcquireHandler
    extends ClientOperationHandler {
        private SemaphoreCancelAcquireHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ConcurrentMapManager.MSemaphore msemaphore = new ConcurrentMapManager.MSemaphore(node.concurrentMapManager);
            packet.setValue(IOUtil.toData(msemaphore.cancelAcquire(IOUtil.toData(packet.name))));
        }
    }

    private class SemaphoreAttachDetachHandler
    extends SemaphoreClientOperationHandler {
        private SemaphoreAttachDetachHandler() {
        }

        void processCall(Packet packet, SemaphoreProxy semaphoreProxy, Integer permits, boolean attach) {
            ClientEndpoint clientEndpoint = ClientHandlerService.this.getClientEndpoint(packet.conn);
            if (attach) {
                semaphoreProxy.attach(permits);
                clientEndpoint.attachDetachPermits(semaphoreProxy.getName(), permits);
            } else {
                semaphoreProxy.detach(permits);
                clientEndpoint.attachDetachPermits(semaphoreProxy.getName(), -permits.intValue());
            }
        }
    }

    private abstract class SemaphoreClientOperationHandler
    extends ClientOperationHandler {
        private SemaphoreClientOperationHandler() {
        }

        abstract void processCall(Packet var1, SemaphoreProxy var2, Integer var3, boolean var4);

        public void processCall(Node node, Packet packet) {
            SemaphoreProxy semaphoreProxy = (SemaphoreProxy)ClientHandlerService.this.factory.getSemaphore(packet.name);
            Integer value = (Integer)IOUtil.toObject(packet.getValueData());
            boolean flag = (Boolean)IOUtil.toObject(packet.getKeyData());
            this.processCall(packet, semaphoreProxy, value, flag);
        }
    }

    public static class CountDownLatchLeave
    implements RemotelyProcessable {
        Address deadAddress;
        transient Node node;

        public CountDownLatchLeave(Address deadAddress) {
            this.deadAddress = deadAddress;
        }

        public CountDownLatchLeave() {
        }

        public void setConnection(Connection conn) {
        }

        public void writeData(DataOutput out) throws IOException {
            this.deadAddress.writeData(out);
        }

        public void readData(DataInput in) throws IOException {
            this.deadAddress = new Address();
            this.deadAddress.readData(in);
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public void process() {
            this.node.concurrentMapManager.syncForDeadCountDownLatches(this.deadAddress);
        }
    }

    private class CountDownLatchSetCountHandler
    extends CountDownLatchClientHandler {
        private CountDownLatchSetCountHandler() {
        }

        void processCall(Packet packet, CountDownLatchProxy cdlProxy, Integer count) {
            Address ownerAddress = packet.conn.getEndPoint();
            packet.setValue(IOUtil.toData(cdlProxy.setCount(count, ownerAddress)));
        }
    }

    private class CountDownLatchGetOwnerHandler
    extends CountDownLatchClientHandler {
        private CountDownLatchGetOwnerHandler() {
        }

        void processCall(Packet packet, CountDownLatchProxy cdlProxy, Integer value) {
            packet.setValue(IOUtil.toData(cdlProxy.getOwner()));
        }
    }

    private class CountDownLatchGetCountHandler
    extends CountDownLatchClientHandler {
        private CountDownLatchGetCountHandler() {
        }

        void processCall(Packet packet, CountDownLatchProxy cdlProxy, Integer value) {
            packet.setValue(IOUtil.toData(cdlProxy.getCount()));
        }
    }

    private class CountDownLatchCountDownHandler
    extends CountDownLatchClientHandler {
        private CountDownLatchCountDownHandler() {
        }

        void processCall(Packet packet, CountDownLatchProxy cdlProxy, Integer value) {
            cdlProxy.countDown();
        }
    }

    private class CountDownLatchAwaitHandler
    extends CountDownLatchClientHandler {
        private CountDownLatchAwaitHandler() {
        }

        void processCall(Packet packet, CountDownLatchProxy cdlProxy, Integer value) {
            try {
                packet.setValue(IOUtil.toData(cdlProxy.await(packet.timeout, TimeUnit.MILLISECONDS)));
            }
            catch (Throwable e) {
                packet.setValue(IOUtil.toData(new ClientServiceException(e)));
            }
        }
    }

    private abstract class CountDownLatchClientHandler
    extends ClientOperationHandler {
        private CountDownLatchClientHandler() {
        }

        abstract void processCall(Packet var1, CountDownLatchProxy var2, Integer var3);

        public void processCall(Node node, Packet packet) {
            String name = packet.name.substring("d:".length());
            CountDownLatchProxy cdlProxy = (CountDownLatchProxy)ClientHandlerService.this.factory.getCountDownLatch(name);
            Integer value = (Integer)IOUtil.toObject(packet.getValueData());
            this.processCall(packet, cdlProxy, value);
        }
    }

    private class AtomicLongGetAndSetHandler
    extends AtomicLongClientHandler {
        private AtomicLongGetAndSetHandler() {
        }

        public Long processCall(AtomicNumberProxy atomicLongProxy, Long value, Long expected) {
            return atomicLongProxy.getAndSet(value);
        }
    }

    private class AtomicLongGetAndAddHandler
    extends AtomicLongClientHandler {
        private AtomicLongGetAndAddHandler() {
        }

        public Long processCall(AtomicNumberProxy atomicLongProxy, Long value, Long expected) {
            return atomicLongProxy.getAndAdd(value);
        }
    }

    private class AtomicLongCompareAndSetHandler
    extends AtomicLongClientHandler {
        private AtomicLongCompareAndSetHandler() {
        }

        public Boolean processCall(AtomicNumberProxy atomicLongProxy, Long value, Long expected) {
            return atomicLongProxy.compareAndSet(expected, value);
        }
    }

    private class AtomicLongAddAndGetHandler
    extends AtomicLongClientHandler {
        private AtomicLongAddAndGetHandler() {
        }

        public Long processCall(AtomicNumberProxy atomicLongProxy, Long value, Long expected) {
            return atomicLongProxy.addAndGet(value);
        }
    }

    private abstract class AtomicLongClientHandler
    extends ClientOperationHandler {
        private AtomicLongClientHandler() {
        }

        abstract Object processCall(AtomicNumberProxy var1, Long var2, Long var3);

        public void processCall(Node node, Packet packet) {
            AtomicNumberProxy atomicLong = (AtomicNumberProxy)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            Long value = (Long)IOUtil.toObject(packet.getValueData());
            Long expectedValue = (Long)IOUtil.toObject(packet.getKeyData());
            packet.setValue(IOUtil.toData(this.processCall(atomicLong, value, expectedValue)));
        }
    }

    private class GetPartitionsHandler
    extends ClientOperationHandler {
        private GetPartitionsHandler() {
        }

        public void processCall(Node node, Packet packet) {
            PartitionService partitionService = ClientHandlerService.this.factory.getPartitionService();
            if (packet.getKeyData() != null && packet.getKeyData().size() > 0) {
                Object key = IOUtil.toObject(packet.getKeyData());
                Partition partition = partitionService.getPartition(key);
                Data value = IOUtil.toData(new PartitionImpl(partition.getPartitionId(), (MemberImpl)partition.getOwner()));
                packet.setValue(value);
            } else {
                Set<Partition> partitions = partitionService.getPartitions();
                LinkedHashSet<Data> setData = new LinkedHashSet<Data>();
                for (Partition partition : partitions) {
                    setData.add(IOUtil.toData(new PartitionImpl(partition.getPartitionId(), (MemberImpl)partition.getOwner())));
                }
                Keys keys = new Keys(setData);
                packet.setValue(IOUtil.toData(keys));
            }
        }
    }

    private class GetMembersHandler
    extends ClientOperationHandler {
        private GetMembersHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ClusterImpl cluster = ClientHandlerService.this.factory.getCluster();
            Set<Member> members = cluster.getMembers();
            LinkedHashSet<Data> setData = new LinkedHashSet<Data>();
            if (members != null) {
                for (Member member : members) {
                    setData.add(IOUtil.toData(member));
                }
                Keys keys = new Keys(setData);
                packet.setValue(IOUtil.toData(keys));
            }
        }
    }

    private class GetInstancesHandler
    extends ClientOperationHandler {
        private GetInstancesHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Collection<Instance> instances = ClientHandlerService.this.factory.getInstances();
            Keys keys = new Keys();
            for (Instance instance : instances) {
                String idStr;
                Object key;
                Object id = instance.getId();
                if (id instanceof FactoryImpl.ProxyKey && (key = ((FactoryImpl.ProxyKey)id).getKey()) instanceof Instance) {
                    id = key.toString();
                }
                if ((idStr = id.toString()).startsWith("c:q:l:") || idStr.startsWith("c:q:")) continue;
                keys.add(IOUtil.toData(id));
            }
            packet.setValue(IOUtil.toData(keys));
        }
    }

    private class ExecutorServiceHandler
    extends ClientOperationHandler {
        private ExecutorServiceHandler() {
        }

        public void processCall(Node node, Packet packet) {
        }

        public final void handle(Node node, final Packet packet) {
            try {
                Callable callable;
                String name = packet.name;
                ExecutorService executorService = ClientHandlerService.this.factory.getExecutorService(name);
                ClientDistributedTask cdt = (ClientDistributedTask)IOUtil.toObject(packet.getKeyData());
                if (cdt.getMember() != null && cdt.getMember() instanceof HazelcastInstanceAware) {
                    ((HazelcastInstanceAware)((Object)cdt.getMember())).setHazelcastInstance(node.factory);
                }
                if (cdt.getMembers() != null) {
                    Set<Member> set = cdt.getMembers();
                    for (Member m : set) {
                        if (!(m instanceof HazelcastInstanceAware)) continue;
                        ((HazelcastInstanceAware)((Object)m)).setHazelcastInstance(node.factory);
                    }
                }
                final ClientEndpoint clientEndpoint = ClientHandlerService.this.getClientEndpoint(packet.conn);
                Callable callable2 = callable = node.securityContext == null ? cdt.getCallable() : node.securityContext.createSecureCallable(clientEndpoint.getSubject(), cdt.getCallable());
                DistributedTask task = cdt.getKey() != null ? new DistributedTask(callable, cdt.getKey()) : (cdt.getMember() != null ? new DistributedTask(callable, cdt.getMember()) : (cdt.getMembers() != null ? new MultiTask(callable, cdt.getMembers()) : new DistributedTask(callable)));
                clientEndpoint.storeTask(packet.callId, task);
                task.setExecutionCallback(new ExecutionCallback(){

                    public void done(Future future) {
                        try {
                            clientEndpoint.removeTask(packet.callId);
                            Object result = future.get();
                            packet.setValue(IOUtil.toData(result));
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        catch (CancellationException e) {
                            packet.setValue(IOUtil.toData(e));
                        }
                        catch (ExecutionException e) {
                            packet.setValue(IOUtil.toData(e));
                        }
                        ExecutorServiceHandler.this.sendResponse(packet);
                    }
                });
                executorService.execute(task);
            }
            catch (RuntimeException e) {
                ClientHandlerService.this.logger.log(Level.WARNING, "exception during handling " + (Object)((Object)packet.operation) + ": " + e.getMessage(), e);
                packet.clearForResponse();
                packet.setValue(IOUtil.toData(e));
                this.sendResponse(packet);
            }
        }
    }

    private class CancelExecutionHandler
    extends ClientOperationHandler {
        private CancelExecutionHandler() {
        }

        public void processCall(Node node, Packet packet) {
            long taskId = (Long)IOUtil.toObject(packet.getKeyData());
            boolean mayInterruptIfRunning = (Boolean)IOUtil.toObject(packet.getValue());
            ClientEndpoint thisEndPoint = ClientHandlerService.this.getClientEndpoint(packet.conn);
            DistributedTask task = thisEndPoint.getTask(taskId);
            boolean cancelled = task.cancel(mayInterruptIfRunning);
            if (cancelled) {
                thisEndPoint.removeTask(taskId);
            }
            packet.setValue(IOUtil.toData(cancelled));
        }
    }

    private class MapRemoveMultiHandler
    extends ClientOperationHandler {
        private MapRemoveMultiHandler() {
        }

        public void processCall(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            if (packet.getValueData() == null || packet.getValueData().size() == 0) {
                MultiMapProxy mmProxy = (MultiMapProxy)multiMap;
                MProxy mapProxy = mmProxy.getMProxy();
                packet.setValue((Data)mapProxy.remove(packet.getKeyData()));
            } else {
                packet.setValue(IOUtil.toData(multiMap.remove(packet.getKeyData(), packet.getValueData())));
            }
        }
    }

    private class MapValueCountHandler
    extends ClientOperationHandler {
        private MapValueCountHandler() {
        }

        public void processCall(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(multiMap.valueCount(packet.getKeyData())));
        }
    }

    private class MapPutMultiHandler
    extends ClientOperationHandler {
        private MapPutMultiHandler() {
        }

        public void processCall(Node node, Packet packet) {
            MultiMap multiMap = (MultiMap)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(multiMap.put(packet.getKeyData(), packet.getValueData())));
        }
    }

    private class NewIdHandler
    extends ClientOperationHandler {
        private NewIdHandler() {
        }

        public void processCall(Node node, Packet packet) {
            IdGenerator idGen = (IdGenerator)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            packet.setValue(IOUtil.toData(idGen.newId()));
        }
    }

    private class DestroyHandler
    extends ClientOperationHandler {
        private DestroyHandler() {
        }

        public void processCall(Node node, Packet packet) {
            Instance instance = (Instance)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            instance.destroy();
        }
    }

    private class RemotelyProcessHandler
    extends ClientOperationHandler {
        private RemotelyProcessHandler() {
        }

        public void processCall(Node node, Packet packet) {
            node.clusterService.enqueuePacket(packet);
        }

        protected void sendResponse(Packet request) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueEntriesHandler
    extends ClientQueueOperationHandler {
        private QueueEntriesHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            Object[] array = queue.toArray();
            Keys keys = new Keys();
            for (Object o : array) {
                keys.add(IOUtil.toData(o));
            }
            return IOUtil.toData(keys);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueRemainingCapacityHandler
    extends ClientQueueOperationHandler {
        private QueueRemainingCapacityHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            return IOUtil.toData(queue.remainingCapacity());
        }
    }

    private class TopicPublishHandler
    extends ClientOperationHandler {
        private TopicPublishHandler() {
        }

        public void processCall(Node node, Packet packet) {
            ITopic topic = (ITopic)ClientHandlerService.this.factory.getOrCreateProxyByName(packet.name);
            topic.publish(packet.getKeyData());
        }

        protected void sendResponse(Packet request) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueSizeHandler
    extends ClientQueueOperationHandler {
        private QueueSizeHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            return IOUtil.toData(queue.size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuePeekHandler
    extends ClientQueueOperationHandler {
        private QueuePeekHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            return (Data)queue.peek();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueRemoveHandler
    extends ClientQueueOperationHandler {
        private QueueRemoveHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            if (value != null) {
                return IOUtil.toData(queue.remove(value));
            }
            return (Data)queue.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuePollHandler
    extends ClientQueueOperationHandler {
        private QueuePollHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            try {
                long millis = (Long)IOUtil.toObject(value);
                if (millis == -1L) {
                    return (Data)queue.take();
                }
                if (millis == 0L) {
                    return (Data)queue.poll();
                }
                return (Data)queue.poll(millis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueOfferHandler
    extends ClientQueueOperationHandler {
        private QueueOfferHandler() {
        }

        @Override
        public Data processQueueOp(IQueue<Object> queue, Data key, Data value) {
            long millis = (Long)IOUtil.toObject(value);
            try {
                if (millis == -1L) {
                    queue.put(key);
                    return IOUtil.toData(true);
                }
                if (millis == 0L) {
                    return IOUtil.toData(queue.offer(key));
                }
                return IOUtil.toData(queue.offer(key, (Long)IOUtil.toObject(value), TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                throw new RuntimeException();
            }
        }
    }

    class Worker
    implements Runnable {
        private final BlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
        private volatile boolean active = true;

        Worker() {
        }

        public void run() {
            ThreadContext.get().setCurrentFactory(((ClientHandlerService)ClientHandlerService.this).node.factory);
            while (this.active) {
                Runnable r = null;
                try {
                    r = this.q.take();
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    r.run();
                }
                catch (Throwable throwable) {}
            }
        }

        public void stop() {
            this.active = false;
            this.q.offer(new Runnable(){

                public void run() {
                }
            });
        }

        public void addWork(Runnable runnable) {
            this.q.offer(runnable);
        }
    }
}

