/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.core.Member;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.base.SystemLog;
import com.hazelcast.impl.partition.MigratingPartition;
import com.hazelcast.impl.partition.PartitionInfo;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Data;
import java.util.HashSet;
import java.util.Set;

public class MapSystemLogFactory {
    public static SystemLog newScheduleRequest(DistributedLock lock, int size) {
        return new RequestScheduled(lock, size);
    }

    public static SystemLog newRedoLog(Node node, Request request) {
        HashSet<Member> members = new HashSet<Member>(node.getClusterImpl().getMembers());
        Data key = request.key;
        Address target = request.target;
        PartitionInfo partitionInfo = null;
        PartitionManager pm = node.concurrentMapManager.getPartitionManager();
        if (key != null) {
            partitionInfo = new PartitionInfo(pm.getPartition(node.concurrentMapManager.getPartitionId(key)));
        }
        boolean targetConnected = false;
        if (target != null && node.getThisAddress().equals(target)) {
            Connection targetConnection = node.connectionManager.getConnection(target);
            targetConnected = targetConnection != null && targetConnection.live();
        }
        return new RedoLog(key, request.operation, target, targetConnected, members, partitionInfo, request.redoCount, pm.getMigratingPartition());
    }

    static class RequestScheduled
    extends SystemLog {
        private final DistributedLock lock;
        private final int size;

        public RequestScheduled(DistributedLock lock, int size) {
            this.lock = lock;
            this.size = size;
        }

        public String toString() {
            DistributedLock l = this.lock;
            StringBuilder sb = new StringBuilder("Scheduled[size=");
            sb.append(this.size).append("]");
            if (l != null) {
                sb.append(" {");
                sb.append(l.toString());
                sb.append("}");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RedoLog
    extends SystemLog {
        final Data key;
        final ClusterOperation operation;
        final Address target;
        final boolean targetConnected;
        final Set<Member> members;
        final PartitionInfo partition;
        final MigratingPartition migratingPartition;
        final int redoCount;

        RedoLog(Data key, ClusterOperation operation, Address target, boolean targetConnected, Set<Member> members, PartitionInfo partition, int redoCount, MigratingPartition migratingPartition) {
            this.key = key;
            this.operation = operation;
            this.target = target;
            this.targetConnected = targetConnected;
            this.members = members;
            this.partition = partition;
            this.redoCount = redoCount;
            this.migratingPartition = migratingPartition;
        }

        private boolean contains(Address address) {
            for (Member member : this.members) {
                MemberImpl m = (MemberImpl)member;
                if (!m.getAddress().equals(address)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("RedoLog{");
            sb.append("key=" + this.key + ", operation=" + (Object)((Object)this.operation) + ", target=" + this.target + ", targetConnected=" + this.targetConnected + ", redoCount=" + this.redoCount + ", migrating=" + this.migratingPartition + "\n" + "partition=" + this.partition + "\n");
            if (this.partition != null) {
                for (int i = 0; i < 7; ++i) {
                    Address replicaAddress = this.partition.getReplicaAddress(i);
                    if (replicaAddress == null || this.contains(replicaAddress)) continue;
                    sb.append(replicaAddress + " not a member!\n");
                }
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

