/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.impl.AbstractJoiner;
import com.hazelcast.impl.MulticastListener;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.SplitBrainHandler;
import com.hazelcast.impl.TcpIpJoiner;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.Clock;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class MulticastJoiner
extends AbstractJoiner {
    final AtomicInteger currentTryCount = new AtomicInteger(0);
    final AtomicInteger tryCount = new AtomicInteger(this.calculateTryCount());

    public MulticastJoiner(Node node) {
        super(node);
    }

    public void doJoin(AtomicBoolean joined) {
        int tryCount = 0;
        long joinStartTime = Clock.currentTimeMillis();
        long maxJoinMillis = this.node.getGroupProperties().MAX_JOIN_SECONDS.getInteger() * 1000;
        while (this.node.isActive() && !joined.get() && Clock.currentTimeMillis() - joinStartTime < maxJoinMillis) {
            String msg = "Joining master: " + this.node.getMasterAddress();
            this.logger.log(Level.FINEST, msg);
            this.systemLogService.logJoin(msg);
            Address masterAddressNow = this.findMasterWithMulticast();
            this.node.setMasterAddress(masterAddressNow);
            this.systemLogService.logJoin("Setting master " + masterAddressNow);
            if (this.node.getMasterAddress() == null || this.node.address.equals(this.node.getMasterAddress())) {
                TcpIpConfig tcpIpConfig = this.config.getNetworkConfig().getJoin().getTcpIpConfig();
                if (tcpIpConfig != null && tcpIpConfig.isEnabled()) {
                    this.doTCP(joined);
                } else {
                    this.systemLogService.logJoin("Setting as master");
                    this.node.setAsMaster();
                }
                return;
            }
            if (++tryCount > 49) {
                this.failedJoiningToMaster(true, tryCount);
            }
            if (!this.node.getMasterAddress().equals(this.node.address)) {
                this.connectAndSendJoinRequest(this.node.getMasterAddress());
            } else {
                this.node.setMasterAddress(null);
                tryCount = 0;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
    }

    private void doTCP(AtomicBoolean joined) {
        this.node.setMasterAddress(null);
        this.logger.log(Level.FINEST, "Multicast couldn't find cluster. Trying TCP/IP");
        new TcpIpJoiner(this.node).join(joined);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchForOtherClusters(SplitBrainHandler splitBrainHandler) {
        final LinkedBlockingQueue q = new LinkedBlockingQueue();
        MulticastListener listener = new MulticastListener(){

            public void onMessage(Object msg) {
                MulticastJoiner.this.systemLogService.logJoin("MulticastListener onMessage " + msg);
                if (msg != null && msg instanceof JoinInfo) {
                    JoinInfo joinInfo = (JoinInfo)msg;
                    if (MulticastJoiner.this.node.address != null && !MulticastJoiner.this.node.address.equals(joinInfo.address)) {
                        q.offer(msg);
                    }
                }
            }
        };
        this.node.multicastService.addMulticastListener(listener);
        this.node.multicastService.send(this.node.createJoinInfo());
        this.systemLogService.logJoin("Sent multicast join request");
        try {
            JoinInfo joinInfo = (JoinInfo)q.poll(3L, TimeUnit.SECONDS);
            if (joinInfo != null) {
                if (joinInfo.getMemberCount() == 1) {
                    Thread.sleep((long)this.node.groupProperties.WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L * 2L);
                }
                if (this.shouldMerge(joinInfo)) {
                    this.logger.log(Level.WARNING, this.node.address + " is merging [multicast] to " + joinInfo.address);
                    this.node.factory.restart();
                    return;
                }
            }
        }
        catch (InterruptedException ignored) {
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        finally {
            this.node.multicastService.removeMulticastListener(listener);
        }
    }

    private boolean connectAndSendJoinRequest(Address masterAddress) {
        if (masterAddress == null || masterAddress.equals(this.node.address)) {
            throw new IllegalArgumentException();
        }
        Connection conn = this.node.connectionManager.getOrConnect(masterAddress);
        this.logger.log(Level.FINEST, "Master connection " + conn);
        this.systemLogService.logJoin("Master connection " + conn);
        if (conn != null) {
            return this.node.clusterManager.sendJoinRequest(masterAddress, true);
        }
        this.logger.log(Level.INFO, "Connecting to master node: " + masterAddress);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address findMasterWithMulticast() {
        block10: {
            try {
                String ip = System.getProperty("join.ip");
                if (ip == null) {
                    JoinInfo joinInfo = this.node.createJoinInfo();
                    while (this.node.isActive() && this.currentTryCount.incrementAndGet() <= this.tryCount.get()) {
                        joinInfo.setTryCount(this.currentTryCount.get());
                        this.node.multicastService.send(joinInfo);
                        if (this.node.getMasterAddress() == null) {
                            Thread.sleep(10L);
                            continue;
                        }
                        Address address = this.node.getMasterAddress();
                        return address;
                    }
                    break block10;
                }
                this.logger.log(Level.FINEST, "RETURNING join.ip");
                Address address = new Address(ip, this.config.getPort());
                return address;
            }
            catch (Exception e) {
                if (this.logger != null) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            finally {
                this.currentTryCount.set(0);
            }
        }
        return null;
    }

    private int calculateTryCount() {
        int timeoutSeconds = this.config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastTimeoutSeconds();
        int tryCount = timeoutSeconds * 100;
        String host = this.node.address.getHost();
        int lastDigits = 0;
        try {
            lastDigits = Integer.valueOf(host.substring(host.lastIndexOf(".") + 1));
        }
        catch (NumberFormatException e) {
            lastDigits = (int)(512.0 * Math.random());
        }
        return tryCount += (lastDigits %= 100) + (this.node.address.getPort() - this.node.config.getPort()) * timeoutSeconds * 3;
    }

    public void onReceivedJoinInfo(JoinInfo joinInfo) {
        if (joinInfo.getTryCount() > this.currentTryCount.get() + 20) {
            int timeoutSeconds = (this.config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastTimeoutSeconds() + 4) * 100;
            this.tryCount.set(timeoutSeconds);
        }
    }
}

