/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.Join;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.TcpIpJoiner;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.util.AddressUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddressPicker {
    private final Node node;
    private final ILogger logger;
    private ServerSocketChannel serverSocketChannel;
    private Address address;

    public AddressPicker(Node node) {
        this.node = node;
        this.logger = Logger.getLogger(AddressPicker.class.getName());
    }

    public void pickAddress() throws Exception {
        if (this.address != null) {
            return;
        }
        try {
            Config config = this.node.getConfig();
            InetAddress inetAddress = this.pickInetAddress(config);
            boolean reuseAddress = config.isReuseAddress();
            boolean bindAny = this.node.getGroupProperties().SOCKET_BIND_ANY.getBoolean();
            this.serverSocketChannel = ServerSocketChannel.open();
            ServerSocket serverSocket = this.serverSocketChannel.socket();
            this.logger.log(Level.FINEST, "inet reuseAddress:" + reuseAddress);
            serverSocket.setReuseAddress(reuseAddress);
            serverSocket.setSoTimeout(1000);
            int port = config.getPort();
            for (int i = 0; i < 100; ++i) {
                try {
                    InetSocketAddress isa = bindAny ? new InetSocketAddress(port) : new InetSocketAddress(inetAddress, port);
                    this.logger.log(Level.FINEST, "Trying to bind inet socket address:" + isa);
                    serverSocket.bind(isa, 100);
                    break;
                }
                catch (Exception e) {
                    if (config.isPortAutoIncrement()) {
                        ++port;
                        continue;
                    }
                    String msg = "Port [" + port + "] is already in use and auto-increment is " + "disabled. Hazelcast cannot start.";
                    this.logger.log(Level.SEVERE, msg, e);
                    throw e;
                }
            }
            this.serverSocketChannel.configureBlocking(false);
            this.address = new Address(inetAddress, port);
            this.logger.log(Level.INFO, "Picked " + this.address + " using socket " + serverSocket + ", bind any local is " + bindAny);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    private InetAddress pickInetAddress(Config config) throws UnknownHostException, SocketException {
        InetAddress currentInetAddress = this.getSystemConfiguredAddress();
        if (currentInetAddress == null) {
            NetworkConfig networkConfig = config.getNetworkConfig();
            Collection<String> interfaces = this.getInterfaces(networkConfig);
            if (interfaces.contains("127.0.0.1") || interfaces.contains("localhost")) {
                currentInetAddress = this.pickLoopbackAddress();
            } else {
                if (interfaces.size() > 0) {
                    currentInetAddress = this.pickInetAddress(interfaces);
                }
                if (currentInetAddress == null) {
                    if (networkConfig.getInterfaces().isEnabled()) {
                        String msg = "Hazelcast CANNOT start on this node. No matching network interface found. ";
                        msg = msg + "\nInterface matching must be either disabled or updated in the hazelcast.xml config file.";
                        this.logger.log(Level.SEVERE, msg);
                        throw new RuntimeException(msg);
                    }
                    if (networkConfig.getJoin().getTcpIpConfig().isEnabled()) {
                        this.logger.log(Level.WARNING, "Could not find a matching address to start with! Picking one of non-loopback addresses.");
                    }
                    currentInetAddress = this.pickInetAddress((Collection<String>)null);
                }
            }
        }
        if (currentInetAddress != null) {
            currentInetAddress = AddressUtil.fixScopeIdAndGetInetAddress(currentInetAddress);
        }
        if (currentInetAddress == null) {
            currentInetAddress = this.pickLoopbackAddress();
        }
        return currentInetAddress;
    }

    private Collection<String> getInterfaces(NetworkConfig networkConfig) throws UnknownHostException {
        HashSet<String> interfaces = new HashSet<String>();
        if (networkConfig.getInterfaces().isEnabled()) {
            interfaces.addAll(networkConfig.getInterfaces().getInterfaces());
            this.logger.log(Level.INFO, "Interfaces is enabled, trying to pick one address matching to one of: " + interfaces);
            this.removeDomainNames(interfaces);
        } else if (networkConfig.getJoin().getTcpIpConfig().isEnabled()) {
            Collection<String> possibleAddresses = TcpIpJoiner.getConfigurationMembers(this.node.config);
            for (String possibleAddress : possibleAddresses) {
                String s = AddressUtil.getAddressHolder((String)possibleAddress).address;
                if (AddressUtil.isIpAddress(s)) {
                    interfaces.add(s);
                    continue;
                }
                String address = this.resolveDomainName(s);
                this.logger.log(Level.INFO, "Updating interface list with " + address + " for domain name '" + s + "'.");
                interfaces.add(address);
            }
            this.logger.log(Level.INFO, "Interfaces is disabled, trying to pick one address from TCP-IP config addresses: " + interfaces);
        }
        return interfaces;
    }

    private void removeDomainNames(Collection<String> interfaces) throws UnknownHostException {
        Iterator<String> iter = interfaces.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            if (AddressUtil.isIpAddress(s)) continue;
            this.logger.log(Level.INFO, "'" + s + "' is not an IP address! Removing from interface list.");
            iter.remove();
        }
    }

    private String resolveDomainName(String domainName) throws UnknownHostException {
        Object[] inetAddresses = InetAddress.getAllByName(domainName);
        if (inetAddresses.length > 1) {
            this.logger.log(Level.WARNING, "Domain name '" + domainName + "' resolves to more than one address: " + Arrays.toString(inetAddresses) + "! Hazelcast will use the first one.");
        }
        InetAddress inetAddress = inetAddresses[0];
        return inetAddress.getHostAddress();
    }

    private InetAddress getSystemConfiguredAddress() throws UnknownHostException {
        String localAddress = System.getProperty("hazelcast.local.localAddress");
        if (localAddress != null) {
            if ("127.0.0.1".equals(localAddress.trim()) || "localhost".equals(localAddress.trim())) {
                return this.pickLoopbackAddress();
            }
            return InetAddress.getByName(localAddress.trim());
        }
        return null;
    }

    private InetAddress pickLoopbackAddress() throws UnknownHostException {
        if (System.getProperty("java.net.preferIPv6Addresses") == null && System.getProperty("java.net.preferIPv4Stack") == null) {
            this.logger.log(Level.WARNING, "Picking loopback address [127.0.0.1]; setting 'java.net.preferIPv4Stack' to true.");
            System.setProperty("java.net.preferIPv4Stack", "true");
        }
        return InetAddress.getByName("127.0.0.1");
    }

    private InetAddress pickInetAddress(Collection<String> interfaces) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        boolean preferIPv4Stack = this.preferIPv4Stack();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> e = ni.getInetAddresses();
            while (e.hasMoreElements()) {
                String address;
                InetAddress inetAddress = e.nextElement();
                if (preferIPv4Stack && inetAddress instanceof Inet6Address || !(interfaces != null && !interfaces.isEmpty() ? AddressUtil.matchAnyInterface(address = inetAddress.getHostAddress(), interfaces) : !inetAddress.isLoopbackAddress())) continue;
                return inetAddress;
            }
        }
        return null;
    }

    private boolean preferIPv4Stack() {
        boolean preferIPv4Stack = this.node.groupProperties.PREFER_IPv4_STACK.getBoolean();
        Join join = this.node.getConfig().getNetworkConfig().getJoin();
        AwsConfig awsConfig = join.getAwsConfig();
        boolean awsEnabled = awsConfig != null && awsConfig.isEnabled();
        return preferIPv4Stack || awsEnabled;
    }

    public Address getAddress() {
        return this.address;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }
}

