/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceDestroyedException;
import com.hazelcast.core.RuntimeInterruptedException;
import com.hazelcast.impl.AsyncCall;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.SemaphoreProxy;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.monitor.LocalSemaphoreStatsImpl;
import com.hazelcast.impl.monitor.SemaphoreOperationsCounter;
import com.hazelcast.monitor.LocalSemaphoreStats;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class SemaphoreProxyImpl
extends FactoryAwareNamedProxy
implements SemaphoreProxy {
    private transient SemaphoreProxy base = null;
    Data nameAsData = null;

    public SemaphoreProxyImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.base = new SemaphoreProxyReal();
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (SemaphoreProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    public String getLongName() {
        return this.name;
    }

    public String getName() {
        return this.name.substring("4:".length());
    }

    Data getNameAsData() {
        if (this.nameAsData == null) {
            this.nameAsData = IOUtil.toData(this.getName());
        }
        return this.nameAsData;
    }

    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public String toString() {
        return "Semaphore [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemaphoreProxyImpl that = (SemaphoreProxyImpl)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    public LocalSemaphoreStats getLocalSemaphoreStats() {
        this.ensure();
        return this.base.getLocalSemaphoreStats();
    }

    public SemaphoreOperationsCounter getOperationsCounter() {
        this.ensure();
        return this.base.getOperationsCounter();
    }

    public void acquire() throws InstanceDestroyedException, InterruptedException {
        this.ensure();
        this.base.acquire();
    }

    public void acquire(int permits) throws InstanceDestroyedException, InterruptedException {
        this.check(permits);
        this.ensure();
        this.base.acquire(permits);
    }

    public Future acquireAsync() {
        return this.doAsyncAcquire(1, false);
    }

    public Future acquireAsync(int permits) {
        this.check(permits);
        return this.doAsyncAcquire(permits, false);
    }

    public void acquireAttach() throws InstanceDestroyedException, InterruptedException {
        this.ensure();
        this.base.acquireAttach();
    }

    public void acquireAttach(int permits) throws InstanceDestroyedException, InterruptedException {
        this.check(permits);
        this.ensure();
        this.base.acquireAttach(permits);
    }

    public Future acquireAttachAsync() {
        return this.doAsyncAcquire(1, true);
    }

    public Future acquireAttachAsync(int permits) {
        this.check(permits);
        return this.doAsyncAcquire(permits, true);
    }

    public void attach() {
        this.ensure();
        this.base.attach();
    }

    public void attach(int permits) {
        this.check(permits);
        this.ensure();
        this.base.attach(permits);
    }

    public int attachedPermits() {
        this.ensure();
        return this.base.attachedPermits();
    }

    public int availablePermits() {
        this.ensure();
        return this.base.availablePermits();
    }

    public void detach() {
        this.ensure();
        this.base.detach();
    }

    public void detach(int permits) {
        this.check(permits);
        this.ensure();
        this.base.detach(permits);
    }

    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    public int drainPermits() {
        this.ensure();
        return this.base.drainPermits();
    }

    public void reducePermits(int permits) {
        this.check(permits);
        this.ensure();
        this.base.reducePermits(permits);
    }

    public void release() {
        this.ensure();
        this.base.release();
    }

    public void release(int permits) {
        this.check(permits);
        this.ensure();
        this.base.release(permits);
    }

    public void releaseDetach() {
        this.ensure();
        this.base.releaseDetach();
    }

    public void releaseDetach(int permits) {
        this.check(permits);
        this.ensure();
        this.base.releaseDetach(permits);
    }

    public boolean tryAcquire() {
        this.ensure();
        return this.base.tryAcquire();
    }

    public boolean tryAcquire(int permits) {
        this.check(permits);
        this.ensure();
        return this.base.tryAcquire(permits);
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
        this.ensure();
        return this.base.tryAcquire(timeout, unit);
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit timeunit) throws InstanceDestroyedException, InterruptedException {
        this.check(permits, timeout, timeunit);
        this.ensure();
        return this.base.tryAcquire(permits, timeout, timeunit);
    }

    public boolean tryAcquireAttach() {
        this.ensure();
        return this.base.tryAcquireAttach();
    }

    public boolean tryAcquireAttach(int permits) {
        this.check(permits);
        this.ensure();
        return this.base.tryAcquireAttach(permits);
    }

    public boolean tryAcquireAttach(long timeout, TimeUnit timeunit) throws InstanceDestroyedException, InterruptedException {
        this.ensure();
        return this.base.tryAcquireAttach(timeout, timeunit);
    }

    public boolean tryAcquireAttach(int permits, long timeout, TimeUnit timeunit) throws InstanceDestroyedException, InterruptedException {
        this.check(permits, timeout, timeunit);
        this.ensure();
        return this.base.tryAcquireAttach(permits, timeout, timeunit);
    }

    private void check(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Number of permits can not be negative: " + permits);
        }
    }

    private void check(int permits, long timeout, TimeUnit timeunit) {
        this.check(permits);
        if (timeout < -1L) {
            throw new IllegalArgumentException("Invalid timeout value: " + timeout);
        }
        if (timeunit == null) {
            throw new NullPointerException("TimeUnit can not be null.");
        }
    }

    private Future doAsyncAcquire(final Integer permits, final Boolean attach) {
        final SemaphoreProxyImpl semaphoreProxy = this;
        AsyncCall call = new AsyncCall(){

            protected void call() {
                try {
                    if (attach.booleanValue()) {
                        semaphoreProxy.acquireAttach(permits);
                    } else {
                        semaphoreProxy.acquire(permits);
                    }
                    this.setResult(null);
                }
                catch (InterruptedException e) {
                    this.setResult(e);
                }
                catch (InstanceDestroyedException e) {
                    e.printStackTrace();
                }
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                ConcurrentMapManager.MSemaphore msemaphore = ((SemaphoreProxyImpl)SemaphoreProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MSemaphore();
                return msemaphore.cancelAcquire(SemaphoreProxyImpl.this.getNameAsData());
            }
        };
        this.factory.node.executorManager.executeAsync(call);
        return call;
    }

    private class SemaphoreProxyReal
    implements SemaphoreProxy {
        SemaphoreOperationsCounter operationsCounter = new SemaphoreOperationsCounter();

        private SemaphoreProxyReal() {
        }

        public Object getId() {
            return SemaphoreProxyImpl.this.name;
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.SEMAPHORE;
        }

        public String getLongName() {
            return SemaphoreProxyImpl.this.name;
        }

        public String getName() {
            return SemaphoreProxyImpl.this.name.substring("4:".length());
        }

        public void destroy() {
            this.newMSemaphore().destroy(SemaphoreProxyImpl.this.getNameAsData());
            SemaphoreProxyImpl.this.factory.destroyInstanceClusterWide(SemaphoreProxyImpl.this.name, null);
        }

        public void acquire() throws InstanceDestroyedException, InterruptedException {
            this.acquire(1);
        }

        public void acquire(int permits) throws InstanceDestroyedException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                this.doTryAcquire(permits, false, -1L);
            }
            catch (RuntimeInterruptedException e) {
                throw new InterruptedException();
            }
        }

        public Future acquireAsync() {
            throw new UnsupportedOperationException();
        }

        public Future acquireAsync(int permits) {
            throw new UnsupportedOperationException();
        }

        public void acquireAttach() throws InstanceDestroyedException, InterruptedException {
            this.acquireAttach(1);
        }

        public void acquireAttach(int permits) throws InstanceDestroyedException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                this.doTryAcquire(permits, true, -1L);
            }
            catch (RuntimeInterruptedException e) {
                throw new InterruptedException();
            }
        }

        public Future acquireAttachAsync() {
            throw new UnsupportedOperationException();
        }

        public Future acquireAttachAsync(int permits) {
            throw new UnsupportedOperationException();
        }

        public void attach() {
            this.attach(1);
        }

        public void attach(int permits) {
            this.newMSemaphore().attachDetach(SemaphoreProxyImpl.this.getNameAsData(), permits);
        }

        public int attachedPermits() {
            return this.newMSemaphore().getAttached(SemaphoreProxyImpl.this.getNameAsData());
        }

        public int availablePermits() {
            return this.newMSemaphore().getAvailable(SemaphoreProxyImpl.this.getNameAsData());
        }

        public void detach() {
            this.detach(1);
        }

        public void detach(int permits) {
            this.newMSemaphore().attachDetach(SemaphoreProxyImpl.this.getNameAsData(), -permits);
        }

        public int drainPermits() {
            return this.newMSemaphore().drainPermits(SemaphoreProxyImpl.this.getNameAsData());
        }

        public void release() {
            this.release(1);
        }

        public void release(int permits) {
            this.newMSemaphore().release(SemaphoreProxyImpl.this.getNameAsData(), permits, false);
        }

        public void releaseDetach() {
            this.releaseDetach(1);
        }

        public void releaseDetach(int permits) {
            this.newMSemaphore().release(SemaphoreProxyImpl.this.getNameAsData(), permits, true);
        }

        public boolean tryAcquire() {
            return this.tryAcquire(1);
        }

        public boolean tryAcquire(int permits) {
            try {
                return this.doTryAcquire(permits, false, -1L);
            }
            catch (Throwable e) {
                return false;
            }
        }

        public boolean tryAcquire(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
            return this.tryAcquire(1, timeout, unit);
        }

        public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                return this.doTryAcquire(permits, false, unit.toMillis(timeout));
            }
            catch (RuntimeInterruptedException e) {
                throw new InterruptedException();
            }
        }

        public boolean tryAcquireAttach() {
            return this.tryAcquireAttach(1);
        }

        public boolean tryAcquireAttach(int permits) {
            try {
                return this.doTryAcquire(permits, true, -1L);
            }
            catch (Throwable e) {
                return false;
            }
        }

        public boolean tryAcquireAttach(long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
            return this.tryAcquireAttach(1, timeout, unit);
        }

        public boolean tryAcquireAttach(int permits, long timeout, TimeUnit unit) throws InstanceDestroyedException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                return this.doTryAcquire(permits, true, unit.toMillis(timeout));
            }
            catch (RuntimeInterruptedException e) {
                throw new InterruptedException();
            }
        }

        public void reducePermits(int permits) {
            this.newMSemaphore().reduce(SemaphoreProxyImpl.this.getNameAsData(), permits);
        }

        public LocalSemaphoreStats getLocalSemaphoreStats() {
            LocalSemaphoreStatsImpl localSemaphoreStats = new LocalSemaphoreStatsImpl();
            localSemaphoreStats.setOperationStats(this.operationsCounter.getPublishedStats());
            return localSemaphoreStats;
        }

        public SemaphoreOperationsCounter getOperationsCounter() {
            return this.operationsCounter;
        }

        private ConcurrentMapManager.MSemaphore newMSemaphore() {
            ConcurrentMapManager.MSemaphore msemaphore = ((SemaphoreProxyImpl)SemaphoreProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MSemaphore();
            msemaphore.setOperationsCounter(this.operationsCounter);
            return msemaphore;
        }

        private boolean doTryAcquire(int permits, boolean attach, long timeout) throws InstanceDestroyedException {
            return this.newMSemaphore().tryAcquire(SemaphoreProxyImpl.this.getNameAsData(), permits, attach, timeout);
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

