/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.ListProxy;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ListProxyImpl
extends AbstractList
implements ListProxy,
DataSerializable {
    String name;
    String queueName;
    String mapName;
    FactoryImpl factory;

    public ListProxyImpl() {
    }

    public ListProxyImpl(String name, FactoryImpl factory) {
        this.factory = factory;
        this.setName(name);
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.LIST;
    }

    public void destroy() {
        this.factory.destroyInstanceClusterWide(this.name, null);
        this.factory.destroyInstanceClusterWide(this.queueName, null);
        this.factory.destroyInstanceClusterWide(this.mapName, null);
    }

    public Object getId() {
        return this.queueName;
    }

    public int size() {
        return this.factory.node.blockingQueueManager.size(this.queueName);
    }

    public boolean contains(Object o) {
        Set<Long> keys = this.factory.node.blockingQueueManager.getValueKeys(this.queueName, IOUtil.toData(o));
        return keys != null && keys.size() > 0;
    }

    public Iterator iterator() {
        return this.factory.node.blockingQueueManager.iterate(this.queueName);
    }

    public boolean add(Object o) {
        return this.factory.node.blockingQueueManager.add(this.queueName, o, Integer.MAX_VALUE);
    }

    public boolean remove(Object o) {
        return this.factory.node.blockingQueueManager.remove(this.queueName, o);
    }

    public boolean addAll(Collection c) {
        for (Object o : c) {
            this.add(o);
        }
        return true;
    }

    public Object get(int index) {
        return this.factory.node.blockingQueueManager.getItemByIndex(this.queueName, index);
    }

    public Object set(int index, Object element) {
        return this.factory.node.blockingQueueManager.set(this.queueName, element, index);
    }

    public void add(int index, Object element) {
        try {
            this.factory.node.blockingQueueManager.offer(this.queueName, element, index, 0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Object remove(int index) {
        return this.factory.node.blockingQueueManager.remove(this.queueName, index);
    }

    public int indexOf(Object o) {
        return this.factory.node.blockingQueueManager.getIndexOf(this.queueName, o, true);
    }

    public int lastIndexOf(Object o) {
        return this.factory.node.blockingQueueManager.getIndexOf(this.queueName, o, false);
    }

    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.setName(this.name);
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.factory = (FactoryImpl)hazelcastInstance;
    }

    public String getName() {
        return this.name.substring("l:".length());
    }

    private void setName(String n) {
        this.name = n;
        this.queueName = "q:" + this.name;
        this.mapName = "c:" + this.queueName;
    }

    public void addItemListener(ItemListener itemListener, boolean includeValue) {
        this.factory.node.blockingQueueManager.addItemListener(this.queueName, itemListener, includeValue);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.factory.node.blockingQueueManager.removeItemListener(this.queueName, itemListener);
    }

    public String toString() {
        return "List [" + this.getName() + "] ";
    }
}

