/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigBuilder;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.Join;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.impl.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlConfigBuilder
extends AbstractXmlConfigHelper
implements ConfigBuilder {
    private final ILogger logger = Logger.getLogger(XmlConfigBuilder.class.getName());
    private boolean domLevel3 = true;
    private Config config;
    private InputStream in;
    private File configurationFile;
    private URL configurationUrl;
    boolean usingSystemConfig = false;

    public XmlConfigBuilder(String xmlFileName) throws FileNotFoundException {
        this(new FileInputStream(xmlFileName));
    }

    public XmlConfigBuilder(InputStream inputStream) {
        this.in = inputStream;
    }

    public XmlConfigBuilder() {
        String configFile = System.getProperty("hazelcast.config");
        try {
            String msg;
            if (configFile != null) {
                this.configurationFile = new File(configFile);
                this.logger.log(Level.INFO, "Using configuration file at " + this.configurationFile.getAbsolutePath());
                if (!this.configurationFile.exists()) {
                    msg = "Config file at '" + this.configurationFile.getAbsolutePath() + "' doesn't exist.";
                    msg = msg + "\nHazelcast will try to use the hazelcast.xml config file in the working directory.";
                    this.logger.log(Level.WARNING, msg);
                    this.configurationFile = null;
                }
            }
            if (this.configurationFile == null) {
                configFile = "hazelcast.xml";
                this.configurationFile = new File("hazelcast.xml");
                if (!this.configurationFile.exists()) {
                    this.configurationFile = null;
                }
            }
            if (this.configurationFile != null) {
                this.logger.log(Level.INFO, "Using configuration file at " + this.configurationFile.getAbsolutePath());
                try {
                    this.in = new FileInputStream(this.configurationFile);
                    this.configurationUrl = this.configurationFile.toURI().toURL();
                    this.usingSystemConfig = true;
                }
                catch (Exception e) {
                    String msg2 = "Having problem reading config file at '" + configFile + "'.";
                    msg2 = msg2 + "\nException message: " + e.getMessage();
                    msg2 = msg2 + "\nHazelcast will try to use the hazelcast.xml config file in classpath.";
                    this.logger.log(Level.WARNING, msg2);
                    this.in = null;
                }
            }
            if (this.in == null) {
                this.logger.log(Level.INFO, "Looking for hazelcast.xml config file in classpath.");
                this.configurationUrl = Config.class.getClassLoader().getResource("hazelcast.xml");
                if (this.configurationUrl == null) {
                    this.configurationUrl = Config.class.getClassLoader().getResource("hazelcast-default.xml");
                    this.logger.log(Level.WARNING, "Could not find hazelcast.xml in classpath.\nHazelcast will use hazelcast-default.xml config file in jar.");
                    if (this.configurationUrl == null) {
                        this.logger.log(Level.WARNING, "Could not find hazelcast-default.xml in the classpath!\nThis may be due to a wrong-packaged or corrupted jar file.");
                        return;
                    }
                }
                this.logger.log(Level.INFO, "Using configuration file " + this.configurationUrl.getFile() + " in the classpath.");
                this.in = this.configurationUrl.openStream();
                if (this.in == null) {
                    msg = "Having problem reading config file hazelcast-default.xml in the classpath.";
                    msg = msg + "\nHazelcast will start with default configuration.";
                    this.logger.log(Level.WARNING, msg);
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Error while creating configuration:" + e.getMessage(), e);
        }
    }

    public Config build() {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        return this.build(config);
    }

    public Config build(Config config) {
        return this.build(config, null);
    }

    public Config build(Element element) {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        return this.build(config, element);
    }

    Config build(Config config, Element element) {
        try {
            this.parse(config, element);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        config.setConfigurationFile(this.configurationFile);
        config.setConfigurationUrl(this.configurationUrl);
        return config;
    }

    private void parse(Config config, Element element) throws Exception {
        this.config = config;
        if (element == null) {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            try {
                doc = builder.parse(this.in);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Util.streamXML(doc, baos);
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                config.setXmlConfig(Util.inputStreamToString(bais));
                if ("true".equals(System.getProperty("hazelcast.config.print"))) {
                    this.logger.log(Level.INFO, "Hazelcast config URL : " + config.getConfigurationUrl());
                    this.logger.log(Level.INFO, "=== Hazelcast config xml ===");
                    this.logger.log(Level.INFO, config.getXmlConfig());
                    this.logger.log(Level.INFO, "==============================");
                    this.logger.log(Level.INFO, "");
                }
            }
            catch (Exception e) {
                String msgPart = "config file '" + config.getConfigurationFile() + "' set as a system property.";
                if (!this.usingSystemConfig) {
                    msgPart = "hazelcast-default.xml config file in the classpath.";
                }
                String msg = "Having problem parsing the " + msgPart;
                msg = msg + "\nException: " + e.getMessage();
                msg = msg + "\nHazelcast will start with default configuration.";
                this.logger.log(Level.WARNING, msg);
                return;
            }
            element = doc.getDocumentElement();
        }
        try {
            element.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.handleConfig(element);
    }

    private void handleConfig(Element docElement) throws Exception {
        for (Node node : new AbstractXmlConfigHelper.IterableNodeList(docElement.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(node.getNodeName());
            if ("network".equals(nodeName)) {
                this.handleNetwork(node);
                continue;
            }
            if ("group".equals(nodeName)) {
                this.handleGroup(node);
                continue;
            }
            if ("properties".equals(nodeName)) {
                this.handleProperties(node, this.config.getProperties());
                continue;
            }
            if ("wan-replication".equals(nodeName)) {
                this.handleWanReplication(node);
                continue;
            }
            if ("executor-service".equals(nodeName)) {
                this.handleExecutor(node);
                continue;
            }
            if ("queue".equals(nodeName)) {
                this.handleQueue(node);
                continue;
            }
            if ("map".equals(nodeName)) {
                this.handleMap(node);
                continue;
            }
            if ("multimap".equals(nodeName)) {
                this.handleMultiMap(node);
                continue;
            }
            if ("topic".equals(nodeName)) {
                this.handleTopic(node);
                continue;
            }
            if ("semaphore".equals(nodeName)) {
                this.handleSemaphore(node);
                continue;
            }
            if ("merge-policies".equals(nodeName)) {
                this.handleMergePolicies(node);
                continue;
            }
            if ("listeners".equals(nodeName)) {
                this.handleListeners(node);
                continue;
            }
            if ("partition-group".equals(nodeName)) {
                this.handlePartitionGroup(node);
                continue;
            }
            if ("security".equals(nodeName)) {
                this.handleSecurity(node);
                continue;
            }
            if ("license-key".equals(nodeName)) {
                this.config.setLicenseKey(this.getValue(node));
                continue;
            }
            if (!"management-center".equals(nodeName)) continue;
            this.handleManagementCenterConfig(node);
        }
    }

    private void handleWanReplication(Node node) throws Exception {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        WanReplicationConfig wanReplicationConfig = new WanReplicationConfig();
        wanReplicationConfig.setName(name);
        for (Node nodeTarget : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(nodeTarget.getNodeName());
            if (!"target-cluster".equals(nodeName)) continue;
            WanTargetClusterConfig wanTarget = new WanTargetClusterConfig();
            String groupName = this.getAttribute(nodeTarget, "group-name");
            String groupPassword = this.getAttribute(nodeTarget, "group-password");
            if (groupName != null) {
                wanTarget.setGroupName(groupName);
            }
            if (groupPassword != null) {
                wanTarget.setGroupPassword(groupPassword);
            }
            for (Node targetChild : new AbstractXmlConfigHelper.IterableNodeList(nodeTarget.getChildNodes())) {
                String targetChildName = XmlConfigBuilder.cleanNodeName(targetChild.getNodeName());
                if ("replication-impl".equals(targetChildName)) {
                    wanTarget.setReplicationImpl(this.getTextContent(targetChild));
                    continue;
                }
                if (!"end-points".equals(targetChildName)) continue;
                for (Node address : new AbstractXmlConfigHelper.IterableNodeList(targetChild.getChildNodes())) {
                    String addressNodeName = XmlConfigBuilder.cleanNodeName(address.getNodeName());
                    if (!"address".equals(addressNodeName)) continue;
                    String addressStr = this.getTextContent(address);
                    wanTarget.addEndpoint(addressStr);
                }
            }
            wanReplicationConfig.addTargetClusterConfig(wanTarget);
        }
        this.config.addWanReplicationConfig(wanReplicationConfig);
    }

    private void handleNetwork(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("port".equals(nodeName)) {
                this.handlePort(child);
                continue;
            }
            if ("join".equals(nodeName)) {
                this.handleJoin(child);
                continue;
            }
            if ("interfaces".equals(nodeName)) {
                this.handleInterfaces(child);
                continue;
            }
            if ("symmetric-encryption".equals(nodeName)) {
                this.handleViaReflection(child, this.config.getNetworkConfig(), new SymmetricEncryptionConfig());
                continue;
            }
            if ("asymmetric-encryption".equals(nodeName)) {
                this.handleViaReflection(child, this.config.getNetworkConfig(), new AsymmetricEncryptionConfig());
                continue;
            }
            if ("ssl".equals(nodeName)) {
                this.handleSSLConfig(child);
                continue;
            }
            if (!"socket-interceptor".equals(nodeName)) continue;
            this.handleSocketInterceptorConfig(child);
        }
    }

    private int getIntegerValue(String parameterName, String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, parameterName + " parameter value, [" + value + "], is not a proper integer. Default value, [" + defaultValue + "], will be used!");
            this.logger.log(Level.WARNING, e.getMessage(), e);
            return defaultValue;
        }
    }

    protected String getTextContent(Node node) {
        if (this.domLevel3) {
            return node.getTextContent();
        }
        return this.getTextContent2(node);
    }

    private void handleExecutor(Node node) throws Exception {
        ExecutorConfig executorConfig = new ExecutorConfig();
        this.handleViaReflection(node, this.config, executorConfig);
    }

    private void handleGroup(Node node) {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value = this.getTextContent(n).trim();
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if ("name".equals(nodeName)) {
                this.config.getGroupConfig().setName(value);
                continue;
            }
            if (!"password".equals(nodeName)) continue;
            this.config.getGroupConfig().setPassword(value);
        }
    }

    private void handleProperties(Node node, Properties properties) {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (n.getNodeType() == 3 || n.getNodeType() == 8) continue;
            String name = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String propertyName = "property".equals(name) ? this.getTextContent(n.getAttributes().getNamedItem("name")).trim() : name;
            String value = this.getTextContent(n).trim();
            properties.setProperty(propertyName, value);
        }
    }

    private void handleInterfaces(Node node) {
        String value;
        NamedNodeMap atts = node.getAttributes();
        Interfaces interfaces = this.config.getNetworkConfig().getInterfaces();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            if (!"enabled".equals(att.getNodeName())) continue;
            value = att.getNodeValue();
            interfaces.setEnabled(this.checkTrue(value));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"interface".equalsIgnoreCase(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
            value = this.getTextContent(n).trim();
            interfaces.addInterface(value);
        }
    }

    private void handleViaReflection(Node node, Object parent, Object target) throws Exception {
        NamedNodeMap atts = node.getAttributes();
        if (atts != null) {
            for (int a = 0; a < atts.getLength(); ++a) {
                Node att = atts.item(a);
                String methodName = "set" + this.getMethodName(att.getNodeName());
                Method method = this.getMethod(target, methodName);
                String value = att.getNodeValue();
                this.invoke(target, method, value);
            }
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value = this.getTextContent(n).trim();
            String methodName = "set" + this.getMethodName(XmlConfigBuilder.cleanNodeName(n.getNodeName()));
            Method method = this.getMethod(target, methodName);
            this.invoke(target, method, value);
        }
        String mName = "set" + target.getClass().getSimpleName();
        Method method = this.getMethod(parent, mName);
        if (method == null) {
            mName = "add" + target.getClass().getSimpleName();
            method = this.getMethod(parent, mName);
        }
        method.invoke(parent, target);
    }

    private void invoke(Object target, Method method, String value) {
        if (method == null) {
            return;
        }
        Class<?>[] args = method.getParameterTypes();
        if (args == null || args.length == 0) {
            return;
        }
        Class<?> arg = method.getParameterTypes()[0];
        try {
            if (arg == String.class) {
                method.invoke(target, value);
            } else if (arg == Integer.TYPE) {
                method.invoke(target, Integer.parseInt(value));
            } else if (arg == Long.TYPE) {
                method.invoke(target, Long.parseLong(value));
            } else if (arg == Boolean.TYPE) {
                method.invoke(target, Boolean.parseBoolean(value));
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private Method getMethod(Object target, String methodName) {
        Method[] methods;
        for (Method method : methods = target.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            return method;
        }
        return null;
    }

    private String getMethodName(String element) {
        StringBuilder sb = new StringBuilder();
        char[] chars = element.toCharArray();
        boolean upper = true;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '_' || c == '-' || c == '.') {
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(Character.toUpperCase(c));
                upper = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void handleJoin(Node node) {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String name = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("multicast".equals(name)) {
                this.handleMulticast(child);
                continue;
            }
            if ("tcp-ip".equals(name)) {
                this.handleTcpIp(child);
                continue;
            }
            if (!"aws".equals(name)) continue;
            this.handleAWS(child);
        }
    }

    private void handleAWS(Node node) {
        String value;
        Join join = this.config.getNetworkConfig().getJoin();
        NamedNodeMap atts = node.getAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            value = this.getTextContent(att).trim();
            if ("enabled".equalsIgnoreCase(att.getNodeName())) {
                join.getAwsConfig().setEnabled(true);
                continue;
            }
            if (!att.getNodeName().equals("conn-timeout-seconds")) continue;
            join.getTcpIpConfig().setConnectionTimeoutSeconds(this.getIntegerValue("conn-timeout-seconds", value, 5));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            value = this.getTextContent(n).trim();
            if ("secret-key".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                join.getAwsConfig().setSecretKey(value);
                continue;
            }
            if ("access-key".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                join.getAwsConfig().setAccessKey(value);
                continue;
            }
            if ("region".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                join.getAwsConfig().setRegion(value);
                continue;
            }
            if ("security-group-name".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                join.getAwsConfig().setSecurityGroupName(value);
                continue;
            }
            if ("tag-key".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                join.getAwsConfig().setTagKey(value);
                continue;
            }
            if (!"tag-value".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
            join.getAwsConfig().setTagValue(value);
        }
    }

    private void handleMulticast(Node node) {
        String value;
        Join join = this.config.getNetworkConfig().getJoin();
        NamedNodeMap atts = node.getAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            value = this.getTextContent(att).trim();
            if (!"enabled".equalsIgnoreCase(att.getNodeName())) continue;
            join.getMulticastConfig().setEnabled(this.checkTrue(value));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            value = this.getTextContent(n).trim();
            if ("multicast-group".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                join.getMulticastConfig().setMulticastGroup(value);
                continue;
            }
            if ("multicast-port".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                join.getMulticastConfig().setMulticastPort(Integer.parseInt(value));
                continue;
            }
            if ("multicast-timeout-seconds".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                join.getMulticastConfig().setMulticastTimeoutSeconds(Integer.parseInt(value));
                continue;
            }
            if ("multicast-time-to-live-seconds".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                join.getMulticastConfig().setMulticastTimeToLive(Integer.parseInt(value));
                continue;
            }
            if (!"trusted-interfaces".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                if (!"interface".equalsIgnoreCase(XmlConfigBuilder.cleanNodeName(child.getNodeName()))) continue;
                join.getMulticastConfig().addTrustedInterface(this.getTextContent(child).trim());
            }
        }
    }

    private void handleTcpIp(Node node) {
        NamedNodeMap atts = node.getAttributes();
        Join join = this.config.getNetworkConfig().getJoin();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if (att.getNodeName().equals("enabled")) {
                join.getTcpIpConfig().setEnabled(this.checkTrue(value));
                continue;
            }
            if (!att.getNodeName().equals("conn-timeout-seconds")) continue;
            join.getTcpIpConfig().setConnectionTimeoutSeconds(this.getIntegerValue("conn-timeout-seconds", value, 5));
        }
        NodeList nodelist = node.getChildNodes();
        HashSet<String> memberTags = new HashSet<String>(Arrays.asList("hostname", "address", "interface", "member", "members"));
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node n = nodelist.item(i);
            String value = this.getTextContent(n).trim();
            if (XmlConfigBuilder.cleanNodeName(n.getNodeName()).equals("required-member")) {
                join.getTcpIpConfig().setRequiredMember(value);
                continue;
            }
            if (!memberTags.contains(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
            join.getTcpIpConfig().addMember(value);
        }
    }

    private void handlePort(Node node) {
        String portStr = this.getTextContent(node).trim();
        if (portStr != null && portStr.length() > 0) {
            this.config.setPort(Integer.parseInt(portStr));
        }
        NamedNodeMap atts = node.getAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if (!att.getNodeName().equals("auto-increment")) continue;
            this.config.setPortAutoIncrement(this.checkTrue(value));
        }
    }

    private void handleQueue(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        QueueConfig qConfig = new QueueConfig();
        qConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("backing-map-ref".equals(nodeName)) {
                qConfig.setBackingMapRef(value);
                continue;
            }
            if ("max-size-per-jvm".equals(nodeName)) {
                qConfig.setMaxSizePerJVM(this.getIntegerValue("max-size-per-jvm", value, 0));
                continue;
            }
            if (!"item-listeners".equals(nodeName)) continue;
            for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                if (!"item-listener".equals(this.cleanNodeName(listenerNode))) continue;
                NamedNodeMap attrs = listenerNode.getAttributes();
                boolean incValue = this.checkTrue(this.getValue(attrs.getNamedItem("include-value")));
                String listenerClass = this.getValue(listenerNode);
                qConfig.addItemListenerConfig(new ItemListenerConfig(listenerClass, incValue));
            }
        }
        this.config.addQueueConfig(qConfig);
    }

    String getAttribute(Node node, String attName) {
        Node attNode = node.getAttributes().getNamedItem(attName);
        if (attNode == null) {
            return null;
        }
        return this.getTextContent(attNode);
    }

    private void handleMultiMap(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        MultiMapConfig multiMapConfig = new MultiMapConfig();
        multiMapConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("value-collection-type".equals(nodeName)) {
                multiMapConfig.setValueCollectionType(value);
                continue;
            }
            if (!"entry-listeners".equals(nodeName)) continue;
            for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                if (!"entry-listener".equals(this.cleanNodeName(listenerNode))) continue;
                NamedNodeMap attrs = listenerNode.getAttributes();
                boolean incValue = this.checkTrue(this.getValue(attrs.getNamedItem("include-value")));
                boolean local = this.checkTrue(this.getValue(attrs.getNamedItem("local")));
                String listenerClass = this.getValue(listenerNode);
                multiMapConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
            }
        }
        this.config.addMultiMapConfig(multiMapConfig);
    }

    private void handleMap(Node node) throws Exception {
        String name = this.getAttribute(node, "name");
        MapConfig mapConfig = new MapConfig();
        mapConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("backup-count".equals(nodeName)) {
                mapConfig.setBackupCount(this.getIntegerValue("backup-count", value, 1));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                mapConfig.setAsyncBackupCount(this.getIntegerValue("async-backup-count", value, 0));
                continue;
            }
            if ("eviction-policy".equals(nodeName)) {
                mapConfig.setEvictionPolicy(value);
                continue;
            }
            if ("max-size".equals(nodeName)) {
                MaxSizeConfig msc = mapConfig.getMaxSizeConfig();
                Node maxSizePolicy = n.getAttributes().getNamedItem("policy");
                if (maxSizePolicy != null) {
                    msc.setMaxSizePolicy(this.getTextContent(maxSizePolicy));
                }
                int size = 0;
                if (value.length() < 2) {
                    size = Integer.parseInt(value);
                } else {
                    char last = value.charAt(value.length() - 1);
                    int type = 0;
                    if (last == 'g' || last == 'G') {
                        type = 1;
                    } else if (last == 'm' || last == 'M') {
                        type = 2;
                    }
                    size = type == 0 ? Integer.parseInt(value) : (type == 1 ? Integer.parseInt(value.substring(0, value.length() - 1)) * 1000 : Integer.parseInt(value.substring(0, value.length() - 1)));
                }
                msc.setSize(size);
                continue;
            }
            if ("eviction-percentage".equals(nodeName)) {
                mapConfig.setEvictionPercentage(this.getIntegerValue("eviction-percentage", value, 25));
                continue;
            }
            if ("eviction-delay-seconds".equals(nodeName)) {
                mapConfig.setEvictionDelaySeconds(this.getIntegerValue("eviction-delay-seconds", value, 3));
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                mapConfig.setTimeToLiveSeconds(this.getIntegerValue("time-to-live-seconds", value, 0));
                continue;
            }
            if ("max-idle-seconds".equals(nodeName)) {
                mapConfig.setMaxIdleSeconds(this.getIntegerValue("max-idle-seconds", value, 0));
                continue;
            }
            if ("map-store".equals(nodeName)) {
                MapStoreConfig mapStoreConfig = this.createMapStoreConfig(n);
                mapConfig.setMapStoreConfig(mapStoreConfig);
                continue;
            }
            if ("near-cache".equals(nodeName)) {
                this.handleViaReflection(n, mapConfig, new NearCacheConfig());
                continue;
            }
            if ("merge-policy".equals(nodeName)) {
                mapConfig.setMergePolicy(value);
                continue;
            }
            if ("cache-value".equals(nodeName)) {
                mapConfig.setCacheValue(this.checkTrue(value));
                continue;
            }
            if ("read-backup-data".equals(nodeName)) {
                mapConfig.setReadBackupData(this.checkTrue(value));
                continue;
            }
            if ("wan-replication-ref".equals(nodeName)) {
                WanReplicationRef wanReplicationRef = new WanReplicationRef();
                String wanName = this.getAttribute(n, "name");
                wanReplicationRef.setName(wanName);
                for (Node wanChild : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                    String wanChildName = XmlConfigBuilder.cleanNodeName(wanChild.getNodeName());
                    String wanChildValue = this.getValue(n);
                    if (!"merge-policy".equals(wanChildName)) continue;
                    wanReplicationRef.setMergePolicy(wanChildValue);
                }
                mapConfig.setWanReplicationRef(wanReplicationRef);
                continue;
            }
            if ("indexes".equals(nodeName)) {
                for (Node indexNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                    if (!"index".equals(this.cleanNodeName(indexNode))) continue;
                    NamedNodeMap attrs = indexNode.getAttributes();
                    boolean ordered = this.checkTrue(this.getValue(attrs.getNamedItem("ordered")));
                    String attribute = this.getValue(indexNode);
                    mapConfig.addMapIndexConfig(new MapIndexConfig(attribute, ordered));
                }
                continue;
            }
            if ("entry-listeners".equals(nodeName)) {
                for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                    if (!"entry-listener".equals(this.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = this.checkTrue(this.getValue(attrs.getNamedItem("include-value")));
                    boolean local = this.checkTrue(this.getValue(attrs.getNamedItem("local")));
                    String listenerClass = this.getValue(listenerNode);
                    mapConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
                }
                continue;
            }
            if (!"storage-type".equals(nodeName)) continue;
            mapConfig.setStorageType(MapConfig.StorageType.valueOf(value.toUpperCase()));
        }
        this.config.addMapConfig(mapConfig);
    }

    private MapStoreConfig createMapStoreConfig(Node node) {
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        NamedNodeMap atts = node.getAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if (!att.getNodeName().equals("enabled")) continue;
            mapStoreConfig.setEnabled(this.checkTrue(value));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if ("class-name".equals(nodeName)) {
                mapStoreConfig.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if ("factory-class-name".equals(nodeName)) {
                mapStoreConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if ("write-delay-seconds".equals(nodeName)) {
                mapStoreConfig.setWriteDelaySeconds(this.getIntegerValue("write-delay-seconds", this.getTextContent(n).trim(), 0));
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.handleProperties(n, mapStoreConfig.getProperties());
        }
        return mapStoreConfig;
    }

    private void handleSSLConfig(Node node) {
        SSLConfig sslConfig = new SSLConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null ? this.checkTrue(this.getTextContent(enabledNode).trim()) : false;
        this.config.getSecurityConfig().setEnabled(enabled);
        sslConfig.setEnabled(enabled);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if ("factory-class-name".equals(nodeName)) {
                sslConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.handleProperties(n, sslConfig.getProperties());
        }
        this.config.getNetworkConfig().setSSLConfig(sslConfig);
    }

    private void handleSocketInterceptorConfig(Node node) {
        SocketInterceptorConfig socketInterceptorConfig = new SocketInterceptorConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null ? this.checkTrue(this.getTextContent(enabledNode).trim()) : false;
        this.config.getSecurityConfig().setEnabled(enabled);
        socketInterceptorConfig.setEnabled(enabled);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if ("class-name".equals(nodeName)) {
                socketInterceptorConfig.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.handleProperties(n, socketInterceptorConfig.getProperties());
        }
        this.config.getNetworkConfig().setSocketInterceptorConfig(socketInterceptorConfig);
    }

    private void handleTopic(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        TopicConfig tConfig = new TopicConfig();
        tConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if (nodeName.equals("global-ordering-enabled")) {
                tConfig.setGlobalOrderingEnabled(this.checkTrue(this.getValue(n)));
                continue;
            }
            if (!"message-listeners".equals(nodeName)) continue;
            for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                if (!"message-listener".equals(this.cleanNodeName(listenerNode))) continue;
                tConfig.addMessageListenerConfig(new ListenerConfig(this.getValue(listenerNode)));
            }
        }
        this.config.addTopicConfig(tConfig);
    }

    private void handleSemaphore(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        SemaphoreConfig sConfig = new SemaphoreConfig(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("initial-permits".equals(nodeName)) {
                sConfig.setInitialPermits(this.getIntegerValue("initial-permits", value, 1));
                continue;
            }
            if (!"semaphore-factory".equals(nodeName)) continue;
            NamedNodeMap atts = n.getAttributes();
            for (int a = 0; a < atts.getLength(); ++a) {
                Node att = atts.item(a);
                if (!att.getNodeName().equals("enabled")) continue;
                sConfig.setFactoryEnabled(this.checkTrue(this.getTextContent(att).trim()));
                for (Node subNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                    if (!"class-name".equals(XmlConfigBuilder.cleanNodeName(subNode.getNodeName()))) continue;
                    sConfig.setFactoryClassName(this.getTextContent(n).trim());
                }
            }
        }
        this.config.addSemaphoreConfig(sConfig);
    }

    private void handleMergePolicies(Node node) throws Exception {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if (!nodeName.equals("map-merge-policy")) continue;
            this.handleViaReflection(n, this.config, new MergePolicyConfig());
        }
    }

    private void handleListeners(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"listener".equals(this.cleanNodeName(child))) continue;
            String listenerClass = this.getValue(child);
            this.config.addListenerConfig(new ListenerConfig(listenerClass));
        }
    }

    private void handlePartitionGroup(Node node) {
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null ? this.checkTrue(this.getTextContent(enabledNode).trim()) : false;
        this.config.getPartitionGroupConfig().setEnabled(enabled);
        Node groupTypeNode = atts.getNamedItem("group-type");
        PartitionGroupConfig.MemberGroupType groupType = groupTypeNode != null ? PartitionGroupConfig.MemberGroupType.valueOf(this.getValue(groupTypeNode).toUpperCase()) : null;
        this.config.getPartitionGroupConfig().setGroupType(groupType);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"member-group".equals(this.cleanNodeName(child))) continue;
            this.handleMemberGroup(child);
        }
    }

    private void handleMemberGroup(Node node) {
        MemberGroupConfig memberGroupConfig = new MemberGroupConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"interface".equals(this.cleanNodeName(child))) continue;
            String value = this.getValue(child);
            memberGroupConfig.addInterface(value);
        }
        this.config.getPartitionGroupConfig().addMemberGroupConfig(memberGroupConfig);
    }

    private void handleManagementCenterConfig(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        Node enabledNode = attrs.getNamedItem("enabled");
        boolean enabled = enabledNode != null ? this.checkTrue(this.getTextContent(enabledNode).trim()) : false;
        Node intervalNode = attrs.getNamedItem("update-interval");
        int interval = intervalNode != null ? this.getIntegerValue("update-interval", this.getValue(intervalNode), 3) : 3;
        this.config.getManagementCenterConfig().setEnabled(enabled);
        this.config.getManagementCenterConfig().setUpdateInterval(interval);
        this.config.getManagementCenterConfig().setUrl(this.getValue(node));
    }

    private void handleSecurity(Node node) throws Exception {
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null ? this.checkTrue(this.getTextContent(enabledNode).trim()) : false;
        this.config.getSecurityConfig().setEnabled(enabled);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("member-credentials-factory".equals(nodeName)) {
                this.handleCredentialsFactory(child);
                continue;
            }
            if ("member-login-modules".equals(nodeName)) {
                this.handleLoginModules(child, true);
                continue;
            }
            if ("client-login-modules".equals(nodeName)) {
                this.handleLoginModules(child, false);
                continue;
            }
            if ("client-permission-policy".equals(nodeName)) {
                this.handlePermissionPolicy(child);
                continue;
            }
            if (!"client-permissions".equals(nodeName)) continue;
            this.handleSecurityPermissions(child);
        }
    }

    private void handleCredentialsFactory(Node node) throws Exception {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        SecurityConfig cfg = this.config.getSecurityConfig();
        CredentialsFactoryConfig credentialsFactoryConfig = new CredentialsFactoryConfig(className);
        cfg.setMemberCredentialsConfig(credentialsFactoryConfig);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"properties".equals(nodeName)) continue;
            this.handleProperties(child, credentialsFactoryConfig.getProperties());
            break;
        }
    }

    private void handleLoginModules(Node node, boolean member) throws Exception {
        SecurityConfig cfg = this.config.getSecurityConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"login-module".equals(nodeName)) continue;
            LoginModuleConfig lm = this.handleLoginModule(child);
            if (member) {
                cfg.addMemberLoginModuleConfig(lm);
                continue;
            }
            cfg.addClientLoginModuleConfig(lm);
        }
    }

    private LoginModuleConfig handleLoginModule(Node node) throws Exception {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        Node usageNode = attrs.getNamedItem("usage");
        LoginModuleConfig.LoginModuleUsage usage = usageNode != null ? LoginModuleConfig.LoginModuleUsage.get(this.getTextContent(usageNode)) : LoginModuleConfig.LoginModuleUsage.REQUIRED;
        LoginModuleConfig moduleConfig = new LoginModuleConfig(className, usage);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"properties".equals(nodeName)) continue;
            this.handleProperties(child, moduleConfig.getProperties());
            break;
        }
        return moduleConfig;
    }

    private void handlePermissionPolicy(Node node) throws Exception {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        SecurityConfig cfg = this.config.getSecurityConfig();
        PermissionPolicyConfig policyConfig = new PermissionPolicyConfig(className);
        cfg.setClientPolicyConfig(policyConfig);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"properties".equals(nodeName)) continue;
            this.handleProperties(child, policyConfig.getProperties());
            break;
        }
    }

    private void handleSecurityPermissions(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            PermissionConfig.PermissionType type;
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("map-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.MAP;
            } else if ("queue-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.QUEUE;
            } else if ("multimap-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.MULTIMAP;
            } else if ("topic-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.TOPIC;
            } else if ("list-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.LIST;
            } else if ("set-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.SET;
            } else if ("lock-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.LOCK;
            } else if ("atomic-number-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.ATOMIC_NUMBER;
            } else if ("countdown-latch-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.COUNTDOWN_LATCH;
            } else if ("semaphore-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.SEMAPHORE;
            } else if ("id-generator-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.ID_GENERATOR;
            } else if ("executor-service-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.EXECUTOR_SERVICE;
            } else if ("listener-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.LISTENER;
            } else if ("transaction-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.TRANSACTION;
            } else {
                if (!"all-permissions".equals(nodeName)) continue;
                type = PermissionConfig.PermissionType.ALL;
            }
            this.handleSecurityPermission(child, type);
        }
    }

    private void handleSecurityPermission(Node node, PermissionConfig.PermissionType type) throws Exception {
        SecurityConfig cfg = this.config.getSecurityConfig();
        NamedNodeMap attrs = node.getAttributes();
        Node nameNode = attrs.getNamedItem("name");
        String name = nameNode != null ? this.getTextContent(nameNode) : "*";
        Node principalNode = attrs.getNamedItem("principal");
        String principal = principalNode != null ? this.getTextContent(principalNode) : "*";
        PermissionConfig permConfig = new PermissionConfig(type, name, principal);
        cfg.addClientPermissionConfig(permConfig);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("endpoints".equals(nodeName)) {
                this.handleSecurityPermissionEndpoints(child, permConfig);
                continue;
            }
            if (!"actions".equals(nodeName)) continue;
            this.handleSecurityPermissionActions(child, permConfig);
        }
    }

    private void handleSecurityPermissionEndpoints(Node node, PermissionConfig permConfig) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"endpoint".equals(nodeName)) continue;
            permConfig.addEndpoint(this.getTextContent(child).trim());
        }
    }

    private void handleSecurityPermissionActions(Node node, PermissionConfig permConfig) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"action".equals(nodeName)) continue;
            permConfig.addAction(this.getTextContent(child).trim());
        }
    }
}

